/*---------------------------------------------------------------------------*
 *                 Cgichk, a CGI vunerability scanner                        *
 *                      Copyright (C) , 1999 by                              *
 *                                                                           *
 *          Peter Orloff                 (fdisk@netplan.gr)                  *
 *          Chen Kin Siong              (cksss@singnet.com.sg)               *
 *                                                                           *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2, or (at your option)       *
 * any later version.                                                        *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Contact us to the above email addresses with any suggestions,problems,    *
 * modifications,config file updates,love letters,selfpics (girls only),etc. *
 *                                                                           *
 * If you are going to modify this program and republish it send a copy and  *
 * a relative email to BOTH of the original authors in the above addresses   *
 *---------------------------------------------------------------------------*/

#include <stdio.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <signal.h>
#include <string.h>
#include <netdb.h>
#include <ctype.h>
#include <arpa/nameser.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
  Implement basic subterfuge attack against naive byte-matching IDSs.
  <dugsong@monkey.org>
*/
void rand_http_escape(char *uri)
 {
   static char *hex = "0123456789ABCDEF";
   char *tmp, *p, *q;

   if ((tmp = strdup(uri)) == NULL) {
     perror("strdup");
     exit(1);
   }
   for (p = tmp, q = uri ; *p ; p++) {
     /* XXX - only handle F-Zf-z in case URI is already escaped... */
     if ((rand() & 1) &&       ((*p >= 70 && *p <= 90) || (*p >= 102 && *p <= 122))) {
       *q++ = '%';
       *q++ = hex[*p >> 4];
       *q++ = hex[*p & 15];
     }
     else *q++ = *p;
   }
   *q = '\0';
   free(tmp);
 }

main(int argc, char *argv[])
{
struct in_addr addr;
struct sockaddr_in sin;
struct hostent *he;
char foundmsg[] = "200";
char *cgistr;
char *config;
char *proxysrv;
char *logfile;
char *sserver;
char askfortxt[10];
char buffer[1024];
char tmpbuff[1024];
char tmpbuff1[1024];
char tmpbuff2[1024];
char tmpbuff3[1024];
char cginame[1024];
char cgilocate[1024];
char *cgilocate1;
char cgiurl[1024];
int proxyport=8080;
int httpdport=80; 
int gettxtmode=0;
int sock,proxymode=0;
int count=0;
int logging=0;
int numin;
int num=0;
int num1=1;
int buffnum=0;
int i;
int chk4eof=1;
char cgibuff[1024];
char httpdver[1024];
int cgidl=0;
struct cgidownload
    {
    char cginame1[1024];
    char cgiurl1[1024];
    };
struct cgidownload url[1000];
FILE *cgidata;
FILE *fp_log;

sserver = argv[1];  /* Server to scan */
config = argv[2];   /* Cgicheker config file */

if(argc==1) { usage(&argv[0]); }

if(argc<3) 
 {
 if(strstr(argv[1],"-V")) { banner(); }
 else { usage(&argv[0]); }
 }

if(argc>3) 
 {
  while ((i = getopt(argc, argv, "p:l:o:c:g")) != -1)
   {
    switch(i)
     {
      case 'p':
       { proxymode = 1; proxysrv=optarg; break; }
      case 'l':
       { logging = 1; logfile=optarg; break; }
      case 'o': 
       { proxyport = atoi(optarg); break; }
      case 'g':
       { gettxtmode = 1; break; }
      case 'c':
       { httpdport = atoi(optarg); break; }
      default :
       { usage(&argv[0]); break; }
     }
   }
 }

if(proxymode==1)
  {
  if((he=gethostbyname(proxysrv)) == NULL)
    {
    herror("gethostbyname");
    exit(0);
    }
  }
else
  {
  if((he=gethostbyname(sserver)) == NULL)
    {
    herror("gethostbyname");
    exit(0);
    }
  }

if((cgidata=fopen(config,"r")) == NULL)
    {
    printf("Could not find config file \"%s\"\n",config);
    exit(0);
    }

printf("\n\n\t\t     -=Cgi Check Version 3.0=-\n\n");

sock=socket(AF_INET, SOCK_STREAM, 0);
bcopy(he->h_addr, (char *)&sin.sin_addr, he->h_length);
sin.sin_family=AF_INET;
if(proxymode==1)
  sin.sin_port=htons(proxyport);
else
  sin.sin_port=htons(httpdport);

if(connect(sock, (struct sockaddr*)&sin, sizeof(sin))!=0)
  {
  perror("connect");
  exit(1);
  }
  
printf("\n\n\t [ Press enter to check out the httpd version...... ]\n");
getchar(); 
srand(getpid());

if(proxymode==1)           
   sprintf(tmpbuff3,"HEAD http://%s:%d HTTP/1.0\n\n",sserver,httpdport); 
else
   sprintf(tmpbuff3,"HEAD / HTTP/1.0\n\n");

send(sock,tmpbuff3,strlen(tmpbuff3),0);

while(chk4eof)
  chk4eof=recv(sock, buffer, sizeof(buffer),0);
  
close(sock); 

while(num != num1)
     {
     bzero(tmpbuff,sizeof(tmpbuff));
     num=buffnum;
     memccpy(tmpbuff,buffer+buffnum,'\n',strlen(buffer));
     if(!strncmp(tmpbuff,"Server:",7))
       {
       printf("[0;1;36m%s[0m",tmpbuff);
       strcpy(httpdver,tmpbuff);
       }
     else 
       printf("%s",tmpbuff);
     buffnum=strlen(tmpbuff)+buffnum;
     num1=buffnum;
     }

if(strstr(httpdver,"Unix") || strstr(httpdver,"Apache"))
  printf("\nMust be running on *nix OS \n\n");
if(strstr(httpdver,"Microsoft"))
  printf("\nMust be running M$ OS \n\n");
if(logging==1) {
 fp_log=fopen(logfile,"a+");
   fprintf(fp_log,"################################################################################\n");
   fprintf(fp_log,"Cgi scan results of %s\n" ,sserver);
   fprintf(fp_log,"-------------------------------HTTP SERVER INFO---------------------------------\n");
   fprintf(fp_log,"%s",buffer);
   fprintf(fp_log,"Httpd Version : %s",httpdver+7);
   fprintf(fp_log,"-------------------------------cgi scan results---------------------------------\n");
        fclose(fp_log); }

printf("\n\t     [ Press enter to search 4 CGI stuff...... ]\n");
getchar();

while(fgets(tmpbuff1,sizeof(tmpbuff1),cgidata))
     {
     if(strncmp(tmpbuff1,"#",1))
       {
       sscanf(tmpbuff1,"%s %s %s",cginame,cgilocate,cgiurl);

       cgilocate1=strdup(cgilocate);
       rand_http_escape(cgilocate + 1);

       if(strlen(cginame)>0)
         {
         sock=socket(AF_INET, SOCK_STREAM, 0);
         bcopy(he->h_addr, (char *)&sin.sin_addr, he->h_length);
         sin.sin_family=AF_INET;
         if(proxymode==1)
           sin.sin_port=htons(proxyport);
         else
  	   sin.sin_port=htons(httpdport);

         if(connect(sock, (struct sockaddr*)&sin, sizeof(sin))!=0)
           {
           perror("connect");
           exit(1);
           }

         printf("\nSearching for %-15s : ",cginame);
         bzero(cgibuff,sizeof(cgibuff));

         if(proxymode==1)
           sprintf(tmpbuff2,"GET http://%s:%d%s HTTP/1.0\n\n",sserver,httpdport,cgilocate);
         else
           sprintf(tmpbuff2,"GET %s HTTP/1.0\n\n",cgilocate);

         send(sock, tmpbuff2,strlen(tmpbuff2),0);
         recv(sock, cgibuff, sizeof(cgibuff),0);

         cgistr = strstr(cgibuff,foundmsg);
         if(cgistr != NULL)
           {
           printf("[0;1;33m!![0;1;31mFound[0;1;33m!![0m");
           if(strlen(cgiurl)>0)
             {
             cgidl++;
             strcpy(url[cgidl].cginame1,cginame);
             strcpy(url[cgidl].cgiurl1,cgiurl);
             }
           if(logging == 1)
             {
             fp_log=fopen(logfile,"a+");
             fprintf(fp_log,"Found %s in %s\n",cginame,cgilocate1);
             fclose(fp_log);
             }
 	  }
         else
           printf("Not Found");

         bzero(cgiurl,sizeof(cgiurl));
         bzero(cginame,sizeof(cginame));
         bzero(cgilocate,sizeof(cgilocate));
         close(sock);
         }
       }
     }
printf("\n\nFinished scanning\n\n\a");

if(gettxtmode==1)
  {
  while(count++ < cgidl)
    {
    printf("\nDo u wanna get the ug fix/exploit infos on %s from %s ? (y/n) : ",url[count].cginame1,url[count].cgiurl1);
    scanf("%s",askfortxt);
    if(strstr(askfortxt,"y") || strstr(askfortxt,"Y"))
      gettxtfile(url[count].cgiurl1);
    }
  }
}

gettxtfile(char dladdr[4000])
{
int sock;
int chk4eof=1;
int count;
struct in_addr addr;
struct sockaddr_in sin;
struct hostent *he;
char getcmd[200];
char txtbuff[2048];
char filename[100];
char httpdaddr[4000];
char *txtlocate;
char tmpbuff[4000];
char tmpbuff1[4000];
FILE *cgitxt;
fd_set readfds;

if(!strncmp(dladdr,"http://",7))
  {
  memccpy(tmpbuff,dladdr+7,'/',strlen(dladdr));
  strcpy(tmpbuff1,dladdr+7);
  }
else
  {
  memccpy(tmpbuff,dladdr,'/',strlen(dladdr));
  strcpy(tmpbuff1,dladdr);
  }

strncpy(httpdaddr,tmpbuff,strlen(tmpbuff)-1);  
txtlocate=strstr(tmpbuff1,"/");

if((he=gethostbyname(httpdaddr)) == NULL)
  {
  herror("gethostbyname");
  exit(0);
  }

sock=socket(AF_INET, SOCK_STREAM, 0);
bcopy(he->h_addr, (char *)&sin.sin_addr, he->h_length);
sin.sin_family=AF_INET;
sin.sin_port=htons(80);

if(connect(sock,(struct sockaddr*)&sin,sizeof(sin))!=0)
  {
  perror("connect");
  printf("Unable to connect on %s\n",dladdr);
  exit(1);
  }

printf("Enter filename to save under : ");
scanf("%s",filename);
cgitxt = fopen(filename,"a");

sprintf(getcmd,"GET %s\n\n",txtlocate);
send(sock, getcmd,strlen(getcmd),0);

FD_ZERO(&readfds);
FD_SET(sock, &readfds);

while(chk4eof)
   {
   select(sock+1, &readfds, NULL, NULL, NULL);
   if(FD_ISSET(sock,&readfds))
     {
     chk4eof=recv(sock, txtbuff, sizeof(txtbuff),0x4);
     fwrite(txtbuff,chk4eof,1,cgitxt);
     }
   }

bzero(httpdaddr,sizeof(httpdaddr));
bzero(tmpbuff,sizeof(tmpbuff));
bzero(tmpbuff1,sizeof(tmpbuff1));

fclose(cgitxt);
close(sock);
}

int usage(char *argv[])
{
 printf("-= CGI Checker Version 3.0 =-");
 printf("\n\nusage : %s target config-file",argv[0]);
 printf("\n-p <proxy>   : for stealth scanning behind proxy");
 printf("\n-o <port>    : to change proxy port (default = 8080)");
 printf("\n-c <port>    : to change httpd port (default = 80)");
 printf("\n-l <logfile> : for logging mode");
 printf("\n-g           : to get info on found cgi's");
 printf("\n-V           : print version,info and etc");
 printf("\n\nEg : %s target config-file -p some.proxy.com -g -o 3124 -l logfile\n\n",argv[0]);
 exit(0);
}

int banner()
{
 printf("CGI Checker Version 3.0 by [CKS & fdisk]\n");
 printf("Drop any bugs,changes,comments to cksss@singnet.com.sg or fdisk@netplan.gr\n\n");
 printf("Proxy support tested on Squid,winroute and netscape proxies\n\n");
 printf("Greetings to: ech0 security, boun, hury, ntwak0, datawar and Ken of PacketStorm\n");
 printf("Thanks to   : Dug Song for the subterfuge attack against IDS feature\n");
 printf("            : su1d_sh3ll for the modifications he did in the previous version\n");
 printf("            : dethwork for more CGI updates\n");
 printf("            : pestilence for giving me my net account :-)\n");
 printf("            : night and Stanly for their help\n");
 printf("            : and to those who copied our source.(you gave us hope)\n\n");
 exit(0);
}
