/********************************************************************************
*                                                                               *
*                     U n d o a b l e   C o m m a n d s                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2003 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: Commands.cpp,v 1.13 2003/10/03 20:58:44 fox Exp $                        *
********************************************************************************/
#include "fx.h"
#include "Commands.h"
#include "Hilite.h"
#include "TextWindow.h"
#include "Adie.h"


/*
  Notes:

  - When manipulating text widget, we generate callbacks even when changing
    the text via undo or redo.
  - During the execution of an undo or redo, FXUndoList is marked as busy;
    thus, the busy state may be checked to determine if one is in the middle
    of an undo or redo.
*/


/*******************************************************************************/

FXIMPLEMENT_ABSTRACT(FXTextCommand,FXCommand,NULL,0)


// Return size of record plus any data kept here
FXuint FXTextCommand::size() const {
  return sizeof(FXTextCommand)+del;
  }


FXIMPLEMENT_ABSTRACT(FXTextInsert,FXTextCommand,NULL,0)

// Insert command
FXTextInsert::FXTextInsert(FXText* txt,FXint p,FXint ni):
  FXTextCommand(txt,p,ni,0){
  }


// Undo an insert removes the inserted text
void FXTextInsert::undo(){
  FXCALLOC(&buffer,FXchar,ins);
  text->extractText(buffer,pos,ins);
  text->removeText(pos,ins,TRUE);
  text->setCursorPos(pos);
  text->makePositionVisible(pos);
  }


// Redo an insert inserts the same old text again
void FXTextInsert::redo(){
  text->insertText(pos,buffer,ins,TRUE);
  text->setCursorPos(pos+ins);
  text->makePositionVisible(pos+ins);
  FXFREE(&buffer);
  }


FXIMPLEMENT_ABSTRACT(FXTextDelete,FXTextCommand,NULL,0)

// Delete command
FXTextDelete::FXTextDelete(FXText* txt,FXint p,FXint nd):
  FXTextCommand(txt,p,0,nd){
  FXCALLOC(&buffer,FXchar,del);
  text->extractText(buffer,pos,del);
  }


// Undo a delete reinserts the old text
void FXTextDelete::undo(){
  text->insertText(pos,buffer,del,TRUE);
  text->setCursorPos(pos+del);
  text->makePositionVisible(pos+del);
  FXFREE(&buffer);
  }


// Redo a delete removes it again
void FXTextDelete::redo(){
  FXCALLOC(&buffer,FXchar,del);
  text->extractText(buffer,pos,del);
  text->removeText(pos,del,TRUE);
  text->setCursorPos(pos);
  text->makePositionVisible(pos);
  }


FXIMPLEMENT_ABSTRACT(FXTextReplace,FXTextCommand,NULL,0)

// Replace command
FXTextReplace::FXTextReplace(FXText* txt,FXint p,FXint nd,FXint ni):
  FXTextCommand(txt,p,ni,nd){
  FXCALLOC(&buffer,FXchar,del);
  text->extractText(buffer,pos,del);
  }


// Undo a replace reinserts the old text
void FXTextReplace::undo(){
  FXchar *tmp;
  FXMALLOC(&tmp,FXchar,ins);
  text->extractText(tmp,pos,ins);
  text->replaceText(pos,ins,buffer,del,TRUE);
  text->setCursorPos(pos+del);
  text->makePositionVisible(pos+del);
  FXFREE(&buffer);
  buffer=tmp;
  }


// Redo a replace reinserts the new text
void FXTextReplace::redo(){
  FXchar *tmp;
  FXMALLOC(&tmp,FXchar,del);
  text->extractText(tmp,pos,del);
  text->replaceText(pos,del,buffer,ins,TRUE);
  text->setCursorPos(pos+ins);
  text->makePositionVisible(pos+ins);
  FXFREE(&buffer);
  buffer=tmp;
  }

