//=====-- PIC16Subtarget.h - Define Subtarget for the PIC16 ---*- C++ -*--====//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source 
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file declares the PIC16 specific subclass of TargetSubtarget.
//
//===----------------------------------------------------------------------===//

#ifndef PIC16SUBTARGET_H
#define PIC16SUBTARGET_H

#include "llvm/Target/TargetMachine.h"
#include "llvm/Target/TargetSubtarget.h"

#include <string>

namespace llvm {
class Module;

class PIC16Subtarget : public TargetSubtarget {
  bool IsPIC16Old;

public:
  /// This constructor initializes the data members to match that
  /// of the specified module.
  ///
  PIC16Subtarget(const TargetMachine &TM, const Module &M, 
                 const std::string &FS);
  
  /// ParseSubtargetFeatures - Parses features string setting specified 
  /// subtarget options.  Definition of function is auto generated by tblgen.
  void ParseSubtargetFeatures(const std::string &FS, const std::string &CPU);
};
} // End llvm namespace

#endif
