// -*- c++ -*-
//
// $Id: Kendall.h,v 1.1 1999/09/24 21:40:36 bmah Exp $
//
// Kendall.h
// Bruce A. Mah <bmah@ca.sandia.gov>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//

typedef enum {
    KendallP900,
    KendallP950,
    KendallP975,
    KendallP990,
    KendallP995,
    KendallPMax
} KendallPType;

typedef struct {
    unsigned int n;
    unsigned int value[KendallPMax];
} KendallLine;

class Kendall {

  public:
    static unsigned int T(unsigned int n, KendallPType p);

  private:
    static KendallLine table[];

};

