/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.celleditor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedTableTreeEditor;
import org.eclipse.emf.common.ui.viewer.ExtendedTableTreeViewer;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class AdapterFactoryTableTreeEditor
extends ExtendedTableTreeEditor {
    protected AdapterFactory adapterFactory;
    protected AdapterFactoryItemDelegator itemDelegator;
    protected TableItem currentTableItem;
    protected TableTreeItem currentTableTreeItem;
    protected Object currentTableTreeItemData;
    protected int currentColumn;
    protected Image leftGradient;
    protected Image rightGradient;
    protected Composite canvas;
    protected KeyListener keyListener;
    protected PaintListener paintListener;
    protected Control activeEditor;
    protected boolean isDown;
    protected boolean hasDropDown;
    protected boolean hasLaunched;

    public AdapterFactoryTableTreeEditor(TableTree tableTree, AdapterFactory adapterFactory) {
        super(tableTree);
        this.adapterFactory = adapterFactory;
        this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == ' ') {
                    AdapterFactoryTableTreeEditor.this.setDown(true);
                    AdapterFactoryTableTreeEditor.this.canvas.update();
                    AdapterFactoryTableTreeEditor.this.setDown(false);
                    AdapterFactoryTableTreeEditor.this.activate();
                } else if (event.character == '\r' || event.character == '\n') {
                    AdapterFactoryTableTreeEditor.this.setDown(true);
                    AdapterFactoryTableTreeEditor.this.canvas.update();
                    AdapterFactoryTableTreeEditor.this.setDown(false);
                    AdapterFactoryTableTreeEditor.this.activate();
                } else if (event.character == '\u001b') {
                    AdapterFactoryTableTreeEditor.this.dismiss();
                } else if (event.keyCode == 0x1000003) {
                    AdapterFactoryTableTreeEditor.this.arrowLeft();
                } else if (event.keyCode == 0x1000004) {
                    AdapterFactoryTableTreeEditor.this.arrowRight();
                } else if (event.keyCode == 0x1000001) {
                    AdapterFactoryTableTreeEditor.this.arrowUp();
                } else if (event.keyCode == 0x1000002) {
                    AdapterFactoryTableTreeEditor.this.arrowDown();
                }
            }
        };
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                AdapterFactoryTableTreeEditor.this.paintControl(event);
            }
        };
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public IItemPropertyDescriptor getColumnPropertyDescriptor(Object object, int column) {
        return null;
    }

    public boolean hasInPlaceEditor(Object object, int column) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getColumnPropertyDescriptor(object, column);
        return column == 0;
    }

    public boolean hasDropDownEditor(Object object, int column) {
        return column != 0;
    }

    public Control createDropDownEditor(Composite parent, Object object, int column) {
        return null;
    }

    public boolean hasLaunchedEditor(Object object, int column) {
        return false;
    }

    public void createLaunchedEditor(Composite parent, Object object, int column) {
    }

    protected void setDown(boolean isDown) {
        this.isDown = isDown;
        this.canvas.redraw();
    }

    protected boolean isDown() {
        return this.isDown;
    }

    protected void editItem(TableItem tableItem, TableTreeItem tableTreeItem, int column) {
        if (this.getEditor() != null) {
            this.getEditor().dispose();
        }
        this.currentTableItem = tableItem;
        this.currentTableTreeItem = tableTreeItem;
        this.currentTableTreeItemData = tableTreeItem.getData();
        this.currentColumn = column;
        this.horizontalAlignment = 16384;
        this.grabHorizontal = true;
        this.minimumWidth = Math.max(50, this.currentTableTreeItem.getBounds((int)column).width);
        this.hasDropDown = this.hasDropDownEditor(this.currentTableTreeItemData, this.currentColumn);
        this.hasLaunched = !this.hasDropDown && this.hasLaunchedEditor(this.currentTableTreeItemData, this.currentColumn);
        this.canvas = this.createComposite();
        this.canvas.addKeyListener(this.keyListener);
        this.canvas.addPaintListener(this.paintListener);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 1) {
                    AdapterFactoryTableTreeEditor.this.setDown(true);
                }
            }

            public void mouseUp(MouseEvent event) {
                if (event.button == 1 && AdapterFactoryTableTreeEditor.this.isDown()) {
                    new Point(event.x, event.y);
                    if (AdapterFactoryTableTreeEditor.this.currentColumn == 0 && AdapterFactoryTableTreeEditor.this.currentTableTreeItem.getItemCount() > 0) {
                        Rectangle imageBounds = AdapterFactoryTableTreeEditor.adjust(AdapterFactoryTableTreeEditor.getImageBounds(AdapterFactoryTableTreeEditor.this.currentTableItem, 0), AdapterFactoryTableTreeEditor.this.currentTableItem.getBounds(AdapterFactoryTableTreeEditor.this.currentColumn));
                        if (event.x < imageBounds.x + imageBounds.width + 3) {
                            AdapterFactoryTableTreeEditor.this.currentTableTreeItem.setExpanded(!AdapterFactoryTableTreeEditor.this.currentTableTreeItem.getExpanded());
                            Event expandEvent = new Event();
                            expandEvent.item = AdapterFactoryTableTreeEditor.this.currentTableTreeItem;
                            AdapterFactoryTableTreeEditor.this.currentTableTreeItem.getParent().notifyListeners(17, expandEvent);
                        } else {
                            AdapterFactoryTableTreeEditor.this.activate();
                        }
                    } else {
                        AdapterFactoryTableTreeEditor.this.activate();
                    }
                }
                AdapterFactoryTableTreeEditor.this.setDown(false);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 26) {
                    event.getClass();
                }
            }
        };
        this.canvas.addListener(26, listener);
        this.canvas.addListener(27, listener);
        this.setEditor((Control)this.canvas, this.currentTableTreeItem, this.currentColumn);
        this.canvas.setFocus();
    }

    protected Composite createComposite() {
        return new Canvas((Composite)this.currentTableItem.getParent(), 0);
    }

    protected void activate() {
        Control control;
        IItemPropertyDescriptor itemPropertyDescriptor = this.getColumnPropertyDescriptor(this.currentTableTreeItem.getData(), this.currentColumn);
        if (itemPropertyDescriptor != null || this.currentColumn == 0) {
            // empty if block
        }
        Rectangle itemBounds = this.currentTableItem.getBounds(this.currentColumn);
        int x = 0;
        if (this.currentColumn == 0) {
            Rectangle imageBounds = AdapterFactoryTableTreeEditor.adjust(AdapterFactoryTableTreeEditor.getImageBounds(this.currentTableItem, this.currentColumn), itemBounds);
            x += imageBounds.x + imageBounds.width;
        }
        Point point = this.currentTableItem.getParent().toDisplay(new Point(itemBounds.x, itemBounds.y));
        final Shell dropDown = new Shell(this.currentTableItem.getParent().getShell(), 16392);
        dropDown.setBackground(dropDown.getDisplay().getSystemColor(2));
        dropDown.setBounds(point.x + x, point.y + itemBounds.height, itemBounds.width - x, itemBounds.height * 5);
        Control control2 = control = this.hasDropDownEditor(this.currentTableTreeItem.getData(), this.currentColumn) ? this.createDropDownEditor((Composite)dropDown, this.currentTableTreeItem.getData(), this.currentColumn) : null;
        if (control != null) {
            control.getBounds();
            control.setBounds(1, 1, itemBounds.width - x - 2, itemBounds.height * 5 - 2);
            dropDown.setVisible(true);
            dropDown.layout();
            control.setFocus();
            Listener dropDownListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 21: {
                            AdapterFactoryTableTreeEditor.this.cancel();
                            dropDown.dispose();
                            break;
                        }
                        case 27: {
                            AdapterFactoryTableTreeEditor.this.apply();
                            dropDown.dispose();
                        }
                    }
                }
            };
            dropDown.addListener(21, dropDownListener);
            dropDown.addListener(27, dropDownListener);
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    if (event.button == 1) {
                        AdapterFactoryTableTreeEditor.this.apply();
                        dropDown.dispose();
                    }
                }
            });
            control.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == ' ' || e.character == '\r' || e.character == '\n') {
                        AdapterFactoryTableTreeEditor.this.apply();
                        dropDown.dispose();
                    } else if (e.character == '\u001b') {
                        AdapterFactoryTableTreeEditor.this.cancel();
                        dropDown.dispose();
                    }
                }
            });
        } else if (this.hasLaunchedEditor(this.currentTableTreeItem.getData(), this.currentColumn)) {
            this.createLaunchedEditor((Composite)dropDown, this.currentTableTreeItem.getData(), this.currentColumn);
        }
        this.activeEditor = control;
    }

    public void cancel() {
        this.activeEditor = null;
    }

    public void apply() {
        this.activeEditor = null;
        if (this.canvas != null && this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void dismiss() {
        if (this.canvas != null) {
            this.canvas.dispose();
            this.canvas = null;
            super.dismiss();
        }
    }

    protected void arrowLeft() {
        if (this.currentColumn > 0) {
            this.editItem(this.currentTableItem, this.currentTableTreeItem, this.currentColumn - 1);
        } else if (this.currentTableTreeItem.getItemCount() > 0) {
            this.currentTableTreeItem.setExpanded(!this.currentTableTreeItem.getExpanded());
            Event expandEvent = new Event();
            expandEvent.item = this.currentTableTreeItem;
            this.currentTableTreeItem.getParent().notifyListeners(17, expandEvent);
        }
    }

    protected void arrowRight() {
        if (this.currentColumn + 1 < this.currentTableItem.getParent().getColumnCount()) {
            this.editItem(this.currentTableItem, this.currentTableTreeItem, this.currentColumn + 1);
        }
    }

    protected void arrowUp() {
        int index = this.currentTableItem.getParent().indexOf(this.currentTableItem);
        if (index > 0) {
            TableItem newTableItem = this.currentTableItem.getParent().getItem(index - 1);
            this.currentTableItem.getParent().showItem(newTableItem);
            this.currentTableItem.getParent().setSelection(index - 1);
            this.editItem(newTableItem, (TableTreeItem)newTableItem.getData("TableTreeItemID"), this.currentColumn);
        }
    }

    protected void arrowDown() {
        int index = this.currentTableItem.getParent().indexOf(this.currentTableItem);
        if (index + 1 < this.currentTableItem.getParent().getItemCount()) {
            TableItem newTableItem = this.currentTableItem.getParent().getItem(index + 1);
            this.currentTableItem.getParent().showItem(newTableItem);
            this.currentTableItem.getParent().setSelection(index + 1);
            this.editItem(newTableItem, (TableTreeItem)newTableItem.getData("TableTreeItemID"), this.currentColumn);
        }
    }

    protected static Rectangle adjust(Rectangle bounds, Rectangle baseBounds) {
        bounds.x -= baseBounds.x;
        bounds.y -= baseBounds.y;
        return bounds;
    }

    protected static Rectangle getImageBounds(TableItem item, int column) {
        return ExtendedTableTreeViewer.getImageBounds((TableItem)item, (int)column);
    }

    protected static void drawImage(GC gc, Image image, Rectangle bounds) {
        Rectangle imageBounds = image.getBounds();
        gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paintControl(PaintEvent event) {
        int baseY;
        int baseX;
        if (this.currentTableItem.isDisposed()) {
            this.apply();
            this.dismiss();
            TableItem[] tableItems = this.table.getItems();
            int i = 0;
            while (i < tableItems.length) {
                TableTreeItem tableTreeItem = (TableTreeItem)tableItems[i].getData("TableTreeItemID");
                if (tableTreeItem.getData() == this.currentTableTreeItemData) {
                    this.editItem(tableItems[i], tableTreeItem, this.currentColumn);
                }
                ++i;
            }
            return;
        }
        Display display = this.currentTableItem.getDisplay();
        Rectangle itemBounds = this.currentTableItem.getBounds(this.currentColumn);
        String text = this.currentTableTreeItem.getText(this.currentColumn);
        Image image = this.currentTableItem.getImage(this.currentColumn);
        Rectangle imageBounds = AdapterFactoryTableTreeEditor.adjust(AdapterFactoryTableTreeEditor.getImageBounds(this.currentTableItem, this.currentColumn), itemBounds);
        Image extraImage = null;
        Rectangle extraImageBounds = null;
        int paddingWidth = 0;
        if (this.currentColumn == 0 && this.currentTableTreeItem instanceof ExtendedTableTreeViewer.ExtendedTableTreeItem) {
            ExtendedTableTreeViewer.ExtendedTableTreeItem item = (ExtendedTableTreeViewer.ExtendedTableTreeItem)this.currentTableTreeItem;
            extraImage = item.getFirstImage();
            extraImageBounds = AdapterFactoryTableTreeEditor.adjust(item.getFirstImageBounds(), itemBounds);
            paddingWidth = item.getImagePaddingWidth();
        }
        event.gc.setBackground(display.getSystemColor(25));
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        if (image != null) {
            AdapterFactoryTableTreeEditor.drawImage(event.gc, image, imageBounds);
        }
        if (extraImage != null) {
            AdapterFactoryTableTreeEditor.drawImage(event.gc, extraImage, extraImageBounds);
        }
        if (text != null) {
            int x = paddingWidth == 0 ? 3 : paddingWidth;
            x += imageBounds.x + imageBounds.width + 3;
            int width = event.gc.stringExtent((String)text).x;
            int height = event.gc.stringExtent((String)text).y;
            int y = height < itemBounds.height ? (itemBounds.height + 1 - height) / 2 : 0;
            event.gc.setForeground(display.getSystemColor(27));
            event.gc.setBackground(display.getSystemColor(26));
            event.gc.fillRectangle(x - 3, 0, width + 8, itemBounds.height);
            event.gc.drawString(text, x, y, true);
        }
        int boxX = itemBounds.width - itemBounds.height;
        int boxY = itemBounds.height - 1;
        if (this.hasLaunched || this.hasDropDown) {
            event.gc.setBackground(display.getSystemColor(22));
            event.gc.fillPolygon(new int[]{boxX, boxY, boxX + itemBounds.height - 1, boxY, boxX + itemBounds.height - 1, 1, boxX, 1});
        }
        if (this.hasDropDown) {
            event.gc.setBackground(display.getSystemColor(2));
            baseX = itemBounds.width - itemBounds.height / 2 - 1;
            baseY = itemBounds.height - itemBounds.height / 2 + 3;
            if (this.isDown()) {
                // empty if block
            }
            event.gc.fillPolygon(new int[]{++baseX, ++baseY, baseX + 4, baseY - 4, baseX - 3, baseY - 4});
        } else if (this.hasLaunched) {
            event.gc.setForeground(display.getSystemColor(2));
            event.gc.setBackground(display.getSystemColor(22));
            baseX = itemBounds.width - itemBounds.height / 2 - 1;
            baseY = 0;
            if (this.isDown()) {
                ++baseX;
                ++baseY;
            }
            event.gc.drawString("...", itemBounds.width - (itemBounds.height + event.gc.stringExtent((String)"...").x) / 2, baseY);
        }
        event.gc.setForeground(display.getSystemColor(16));
        event.gc.drawRectangle(0, 0, itemBounds.width - 1, itemBounds.height - 1);
        if (this.hasLaunched || this.hasDropDown) {
            if (this.isDown()) {
                event.gc.setForeground(display.getSystemColor(18));
                event.gc.drawLine(boxX, boxY - 1, boxX, 1);
                event.gc.drawLine(boxX, 1, boxX + itemBounds.height - 1, 1);
                event.gc.drawLine(boxX + 1, boxY - 1, boxX + itemBounds.height - 1, boxY - 1);
                event.gc.drawLine(boxX + itemBounds.height - 1, boxY - 1, boxX + itemBounds.height - 1, 2);
            } else {
                event.gc.setForeground(display.getSystemColor(20));
                event.gc.drawLine(boxX + 1, boxY - 1, boxX + 1, 2);
                event.gc.drawLine(boxX + 1, 2, boxX + itemBounds.height - 2, 2);
                event.gc.setForeground(display.getSystemColor(18));
                event.gc.drawLine(boxX + 1, boxY - 2, boxX + itemBounds.height - 3, boxY - 2);
                event.gc.drawLine(boxX + itemBounds.height - 3, boxY - 2, boxX + itemBounds.height - 3, 2);
                event.gc.setForeground(display.getSystemColor(17));
                event.gc.drawLine(boxX, boxY - 1, boxX + itemBounds.height - 2, boxY - 1);
                event.gc.drawLine(boxX + itemBounds.height - 2, boxY - 1, boxX + itemBounds.height - 2, 1);
            }
        }
    }

    protected Image getLeftGradient() {
        if (this.leftGradient == null) {
            this.getGradients();
        }
        return this.leftGradient;
    }

    protected Image getRightGradient() {
        if (this.rightGradient == null) {
            this.getGradients();
        }
        return this.rightGradient;
    }

    protected void getGradients() {
        int width = 20;
        int height = 10;
        Display display = this.canvas.getDisplay();
        this.leftGradient = new Image((Device)display, width, height);
        GC leftGC = new GC((Drawable)this.leftGradient);
        this.rightGradient = new Image((Device)display, width, height);
        GC rightGC = new GC((Drawable)this.rightGradient);
        Color startColor = display.getSystemColor(25);
        RGB rgb1 = startColor.getRGB();
        Color endColor = display.getSystemColor(25);
        RGB rgb2 = endColor.getRGB();
        int k = 0;
        while (k < width) {
            int r = rgb1.red + k * (rgb2.red - rgb1.red) / width;
            r = rgb2.red > rgb1.red ? Math.min(r, rgb2.red) : Math.max(r, rgb2.red);
            int g = rgb1.green + k * (rgb2.green - rgb1.green) / width;
            g = rgb2.green > rgb1.green ? Math.min(g, rgb2.green) : Math.max(g, rgb2.green);
            int b = rgb1.blue + k * (rgb2.blue - rgb1.blue) / width;
            b = rgb2.blue > rgb1.blue ? Math.min(b, rgb2.blue) : Math.max(b, rgb2.blue);
            Color color = new Color((Device)display, r, g, b);
            leftGC.setBackground(color);
            leftGC.fillRectangle(width - k - 1, 0, 1, height);
            rightGC.setBackground(color);
            rightGC.fillRectangle(k, 0, 1, height);
            color.dispose();
            ++k;
        }
        leftGC.dispose();
        rightGC.dispose();
    }
}

