/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;

public class RedoAction
extends Action {
    protected EditingDomain domain;

    public RedoAction(EditingDomain domain) {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
        this.domain = domain;
        this.update();
    }

    public RedoAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void run() {
        this.domain.getCommandStack().redo();
    }

    public void update() {
        this.setEnabled(this.domain.getCommandStack().canRedo());
        Command redoCommand = this.domain.getCommandStack().getRedoCommand();
        if (redoCommand != null && redoCommand.getLabel() != null) {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{redoCommand.getLabel()}));
        } else {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
        }
        if (redoCommand != null && redoCommand.getDescription() != null) {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item_description", new Object[]{redoCommand.getDescription()}));
        } else {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item_simple_description"));
        }
    }

    public void setActiveEditor(IEditorPart editorPart) {
        if (editorPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
        }
    }
}

