/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: TCPServiceDialog.cpp,v 1.23 2006/05/13 06:53:05 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "TCPServiceDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/TCPService.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>

using namespace std;
using namespace libfwbuilder;

void TCPServiceDialog::loadFWObject(FWObject *o)
{
    obj=o;
    TCPService *s = dynamic_cast<TCPService*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    ss->setValue( s->getInt("src_range_start") );
    se->setValue( s->getInt("src_range_end") );
    ds->setValue( s->getInt("dst_range_start") );
    de->setValue( s->getInt("dst_range_end") );

    urg_m->setChecked( s->getBool("urg_flag_mask") );
    ack_m->setChecked( s->getBool("ack_flag_mask") );
    psh_m->setChecked( s->getBool("psh_flag_mask") );
    rst_m->setChecked( s->getBool("rst_flag_mask") );
    syn_m->setChecked( s->getBool("syn_flag_mask") );
    fin_m->setChecked( s->getBool("fin_flag_mask") );

    urg_s->setChecked( s->getBool("urg_flag") );
    ack_s->setChecked( s->getBool("ack_flag") );
    psh_s->setChecked( s->getBool("psh_flag") );
    rst_s->setChecked( s->getBool("rst_flag") );
    syn_s->setChecked( s->getBool("syn_flag") );
    fin_s->setChecked( s->getBool("fin_flag") );

    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    //apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    ss->setEnabled(!o->isReadOnly());
    setDisabledPalette(ss);

    se->setEnabled(!o->isReadOnly());
    setDisabledPalette(se);

    ds->setEnabled(!o->isReadOnly());
    setDisabledPalette(ds);

    de->setEnabled(!o->isReadOnly());
    setDisabledPalette(de);

    urg_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(urg_m);

    ack_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(ack_m);

    psh_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(psh_m);

    rst_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(rst_m);

    syn_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(syn_m);

    fin_m->setEnabled(!o->isReadOnly());
    setDisabledPalette(fin_m);

    urg_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(urg_s);

    ack_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(ack_s);

    psh_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(psh_s);

    rst_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(rst_s);

    syn_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(syn_s);

    fin_s->setEnabled(!o->isReadOnly());
    setDisabledPalette(fin_s);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void TCPServiceDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void TCPServiceDialog::validate(bool *res)
{
    *res=true;
}

void TCPServiceDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void TCPServiceDialog::libChanged()
{
    changed();
}

void TCPServiceDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );

    if (ss->value()!=0 && se->value()==0) se->setValue( ss->value() );
    if (ds->value()!=0 && de->value()==0) de->setValue( ds->value() );

    obj->setInt("src_range_start", ss->value() );
    obj->setInt("src_range_end",   se->value() );
    obj->setInt("dst_range_start", ds->value() );
    obj->setInt("dst_range_end",   de->value() );
        
    obj->setBool("urg_flag_mask", urg_m->isChecked() );
    obj->setBool("ack_flag_mask", ack_m->isChecked() );
    obj->setBool("psh_flag_mask", psh_m->isChecked() );
    obj->setBool("rst_flag_mask", rst_m->isChecked() );
    obj->setBool("syn_flag_mask", syn_m->isChecked() );
    obj->setBool("fin_flag_mask", fin_m->isChecked() );

    obj->setBool("urg_flag",      urg_s->isChecked() );
    obj->setBool("ack_flag",      ack_s->isChecked() );
    obj->setBool("psh_flag",      psh_s->isChecked() );
    obj->setBool("rst_flag",      rst_s->isChecked() );
    obj->setBool("syn_flag",      syn_s->isChecked() );
    obj->setBool("fin_flag",      fin_s->isChecked() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void TCPServiceDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void TCPServiceDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

