
[spec]

; Format and options of this spec file:
options = "+spec2"

[info]

artists = "
    Ralph Engels <rengels@hydra.informatik.uni-ulm.de>
    Jeff Mallatt <jjm@codewell.com> (additional specials)
"

[file]
gfx = "engels/tiles"

[grid_main]

x_top_left = 0
y_top_left = 0
dx = 45
dy = 45

tiles = { "row", "column", "tag"

; "Shoreline" "corner" tiles, designate shores north, south, east, 
; west, actually that direction rotated 45 degrees clockwise:

  0,  0, "tx.coast_cape_n1s0e0w0"
  0,  1, "tx.coast_cape_n0s0e1w0"
  0,  2, "tx.coast_cape_n1s0e1w0"
  0,  3, "tx.coast_cape_n0s1e0w0"
  0,  4, "tx.coast_cape_n1s1e0w0"
  0,  5, "tx.coast_cape_n0s1e1w0"
  0,  6, "tx.coast_cape_n1s1e1w0"
  0,  7, "tx.coast_cape_n0s0e0w1"
  0,  8, "tx.coast_cape_n1s0e0w1"
  0,  9, "tx.coast_cape_n0s0e1w1"
  0, 10, "tx.coast_cape_n1s0e1w1"
  0, 11, "tx.coast_cape_n0s1e0w1"
  0, 12, "tx.coast_cape_n1s1e0w1"
  0, 13, "tx.coast_cape_n0s1e1w1"
  0, 14, "tx.coast_cape_n1s1e1w1"

; Grassland, and whether terrain to north, south, east, west 
; is more grassland:

  1,  0, "t.grassland_n1s1e1w1"
  1,  1, "t.grassland_n0s1e1w1"
  1,  2, "t.grassland_n1s1e0w1"
  1,  3, "t.grassland_n0s1e0w1"
  1,  4, "t.grassland_n1s0e1w1"
  1,  5, "t.grassland_n0s0e1w1"
  1,  6, "t.grassland_n1s0e0w1"
  1,  7, "t.grassland_n0s0e0w1"
  1,  8, "t.grassland_n1s1e1w0"
  1,  9, "t.grassland_n0s1e1w0"
  1, 10, "t.grassland_n1s1e0w0"
  1, 11, "t.grassland_n0s1e0w0"
  1, 12, "t.grassland_n1s0e1w0"
  1, 13, "t.grassland_n0s0e1w0"
  1, 14, "t.grassland_n1s0e0w0"
  1, 15, "t.grassland_n0s0e0w0"

; Desert, and whether terrain to north, south, east, west 
; is more desert:

  2,  0, "t.desert_n1s1e1w1"
  2,  1, "t.desert_n0s1e1w1"
  2,  2, "t.desert_n1s1e0w1"
  2,  3, "t.desert_n0s1e0w1"
  2,  4, "t.desert_n1s0e1w1"
  2,  5, "t.desert_n0s0e1w1"
  2,  6, "t.desert_n1s0e0w1"
  2,  7, "t.desert_n0s0e0w1"
  2,  8, "t.desert_n1s1e1w0"
  2,  9, "t.desert_n0s1e1w0"
  2, 10, "t.desert_n1s1e0w0"
  2, 11, "t.desert_n0s1e0w0"
  2, 12, "t.desert_n1s0e1w0"
  2, 13, "t.desert_n0s0e1w0"
  2, 14, "t.desert_n1s0e0w0"
  2, 15, "t.desert_n0s0e0w0"

; Arctic, and whether terrain to north, south, east, west 
; is more arctic:

  3,  0, "t.arctic_n1s1e1w1"
  3,  1, "t.arctic_n0s1e1w1"
  3,  2, "t.arctic_n1s1e0w1"
  3,  3, "t.arctic_n0s1e0w1"
  3,  4, "t.arctic_n1s0e1w1"
  3,  5, "t.arctic_n0s0e1w1"
  3,  6, "t.arctic_n1s0e0w1"
  3,  7, "t.arctic_n0s0e0w1"
  3,  8, "t.arctic_n1s1e1w0"
  3,  9, "t.arctic_n0s1e1w0"
  3, 10, "t.arctic_n1s1e0w0"
  3, 11, "t.arctic_n0s1e0w0"
  3, 12, "t.arctic_n1s0e1w0"
  3, 13, "t.arctic_n0s0e1w0"
  3, 14, "t.arctic_n1s0e0w0"
  3, 15, "t.arctic_n0s0e0w0"

; Jungle, and whether terrain to north, south, east, west 
; is more jungle:

  4,  0, "t.jungle_n1s1e1w1"
  4,  1, "t.jungle_n0s1e1w1"
  4,  2, "t.jungle_n1s1e0w1"
  4,  3, "t.jungle_n0s1e0w1"
  4,  4, "t.jungle_n1s0e1w1"
  4,  5, "t.jungle_n0s0e1w1"
  4,  6, "t.jungle_n1s0e0w1"
  4,  7, "t.jungle_n0s0e0w1"
  4,  8, "t.jungle_n1s1e1w0"
  4,  9, "t.jungle_n0s1e1w0"
  4, 10, "t.jungle_n1s1e0w0"
  4, 11, "t.jungle_n0s1e0w0"
  4, 12, "t.jungle_n1s0e1w0"
  4, 13, "t.jungle_n0s0e1w0"
  4, 14, "t.jungle_n1s0e0w0"
  4, 15, "t.jungle_n0s0e0w0"

; Plains, and whether terrain to north, south, east, west 
; is more plains:

  5,  0, "t.plains_n1s1e1w1"
  5,  1, "t.plains_n0s1e1w1"
  5,  2, "t.plains_n1s1e0w1"
  5,  3, "t.plains_n0s1e0w1"
  5,  4, "t.plains_n1s0e1w1"
  5,  5, "t.plains_n0s0e1w1"
  5,  6, "t.plains_n1s0e0w1"
  5,  7, "t.plains_n0s0e0w1"
  5,  8, "t.plains_n1s1e1w0"
  5,  9, "t.plains_n0s1e1w0"
  5, 10, "t.plains_n1s1e0w0"
  5, 11, "t.plains_n0s1e0w0"
  5, 12, "t.plains_n1s0e1w0"
  5, 13, "t.plains_n0s0e1w0"
  5, 14, "t.plains_n1s0e0w0"
  5, 15, "t.plains_n0s0e0w0"

; Swamp, and whether terrain to north, south, east, west 
; is more swamp:

  6,  0, "t.swamp_n1s1e1w1"
  6,  1, "t.swamp_n0s1e1w1"
  6,  2, "t.swamp_n1s1e0w1"
  6,  3, "t.swamp_n0s1e0w1"
  6,  4, "t.swamp_n1s0e1w1"
  6,  5, "t.swamp_n0s0e1w1"
  6,  6, "t.swamp_n1s0e0w1"
  6,  7, "t.swamp_n0s0e0w1"
  6,  8, "t.swamp_n1s1e1w0"
  6,  9, "t.swamp_n0s1e1w0"
  6, 10, "t.swamp_n1s1e0w0"
  6, 11, "t.swamp_n0s1e0w0"
  6, 12, "t.swamp_n1s0e1w0"
  6, 13, "t.swamp_n0s0e1w0"
  6, 14, "t.swamp_n1s0e0w0"
  6, 15, "t.swamp_n0s0e0w0"

; Tundra, and whether terrain to north, south, east, west 
; is more tundra:

  7,  0, "t.tundra_n1s1e1w1"
  7,  1, "t.tundra_n0s1e1w1"
  7,  2, "t.tundra_n1s1e0w1"
  7,  3, "t.tundra_n0s1e0w1"
  7,  4, "t.tundra_n1s0e1w1"
  7,  5, "t.tundra_n0s0e1w1"
  7,  6, "t.tundra_n1s0e0w1"
  7,  7, "t.tundra_n0s0e0w1"
  7,  8, "t.tundra_n1s1e1w0"
  7,  9, "t.tundra_n0s1e1w0"
  7, 10, "t.tundra_n1s1e0w0"
  7, 11, "t.tundra_n0s1e0w0"
  7, 12, "t.tundra_n1s0e1w0"
  7, 13, "t.tundra_n0s0e1w0"
  7, 14, "t.tundra_n1s0e0w0"
  7, 15, "t.tundra_n0s0e0w0"

; Rivers (as terrain type), and whether terrain to north, south, 
; east, west is also river terrain, or ocean:

  8,  0, "t.t_river_n0s0e0w0"
  8,  1, "t.t_river_n1s0e0w0"
  8,  2, "t.t_river_n0s0e1w0"
  8,  3, "t.t_river_n1s0e1w0"
  8,  4, "t.t_river_n0s1e0w0"
  8,  5, "t.t_river_n1s1e0w0"
  8,  6, "t.t_river_n0s1e1w0"
  8,  7, "t.t_river_n1s1e1w0"
  8,  8, "t.t_river_n0s0e0w1"
  8,  9, "t.t_river_n1s0e0w1"
  8, 10, "t.t_river_n0s0e1w1"
  8, 11, "t.t_river_n1s0e1w1"
  8, 12, "t.t_river_n0s1e0w1"
  8, 13, "t.t_river_n1s1e0w1"
  8, 14, "t.t_river_n0s1e1w1"
  8, 15, "t.t_river_n1s1e1w1"

; Rivers (as special type), and whether north, south, east, west 
; also has river or is ocean:

 18,  0, "tx.s_river_n0s0e0w0"
 18,  1, "tx.s_river_n1s0e0w0"
 18,  2, "tx.s_river_n0s0e1w0"
 18,  3, "tx.s_river_n1s0e1w0"
 18,  4, "tx.s_river_n0s1e0w0"
 18,  5, "tx.s_river_n1s1e0w0"
 18,  6, "tx.s_river_n0s1e1w0"
 18,  7, "tx.s_river_n1s1e1w0"
 18,  8, "tx.s_river_n0s0e0w1"
 18,  9, "tx.s_river_n1s0e0w1"
 18, 10, "tx.s_river_n0s0e1w1"
 18, 11, "tx.s_river_n1s0e1w1"
 18, 12, "tx.s_river_n0s1e0w1"
 18, 13, "tx.s_river_n1s1e0w1"
 18, 14, "tx.s_river_n0s1e1w1"
 18, 15, "tx.s_river_n1s1e1w1"

; Ocean, and whether terrain to north, south, east, west 
; is more ocean (else shoreline)

  9,  0, "t.ocean_n1s1e1w1"
  9,  1, "t.ocean_n0s1e1w1"
  9,  2, "t.ocean_n1s1e0w1"
  9,  3, "t.ocean_n0s1e0w1"
  9,  4, "t.ocean_n1s0e1w1"
  9,  5, "t.ocean_n0s0e1w1"
  9,  6, "t.ocean_n1s0e0w1"
  9,  7, "t.ocean_n0s0e0w1"
  9,  8, "t.ocean_n1s1e1w0"
  9,  9, "t.ocean_n0s1e1w0"
  9, 10, "t.ocean_n1s1e0w0"
  9, 11, "t.ocean_n0s1e0w0"
  9, 12, "t.ocean_n1s0e1w0"
  9, 13, "t.ocean_n0s0e1w0"
  9, 14, "t.ocean_n1s0e0w0"
  9, 15, "t.ocean_n0s0e0w0"

; For hills, forest and mountains don't currently have a full set,
; re-use values but provide for future expansion; current sets
; effectively ignore N/S terrain.

; Hills, and whether terrain to north, south, east, west 
; is more hills.

 10,  0, "t.hills_n0s0e0w0",  ; not-hills E and W
         "t.hills_n0s1e0w0", 
         "t.hills_n1s0e0w0", 
         "t.hills_n1s1e0w0" 
 10,  1, "t.hills_n0s0e1w0",  ; hills E
         "t.hills_n0s1e1w0", 
         "t.hills_n1s0e1w0", 
         "t.hills_n1s1e1w0" 
 10,  2, "t.hills_n0s0e1w1",  ; hills E and W
         "t.hills_n0s1e1w1", 
         "t.hills_n1s0e1w1", 
         "t.hills_n1s1e1w1" 
 10,  3, "t.hills_n0s0e0w1",  ; hills W
         "t.hills_n0s1e0w1", 
         "t.hills_n1s0e0w1", 
         "t.hills_n1s1e0w1" 

; Forest, and whether terrain to north, south, east, west 
; is more forest.

 10,  4, "t.forest_n0s0e0w0",  ; not-forest E and W
         "t.forest_n0s1e0w0", 
         "t.forest_n1s0e0w0", 
         "t.forest_n1s1e0w0" 
 10,  5, "t.forest_n0s0e1w0",  ; forest E
         "t.forest_n0s1e1w0", 
         "t.forest_n1s0e1w0", 
         "t.forest_n1s1e1w0" 
 10,  6, "t.forest_n0s0e1w1",  ; forest E and W
         "t.forest_n0s1e1w1", 
         "t.forest_n1s0e1w1", 
         "t.forest_n1s1e1w1" 
 10,  7, "t.forest_n0s0e0w1",  ; forest W
         "t.forest_n0s1e0w1", 
         "t.forest_n1s0e0w1", 
         "t.forest_n1s1e0w1" 

; Mountains, and whether terrain to north, south, east, west 
; is more mountains.

 10,  8, "t.mountains_n0s0e0w0",  ; not-mountains E and W
         "t.mountains_n0s1e0w0", 
         "t.mountains_n1s0e0w0", 
         "t.mountains_n1s1e0w0" 
 10,  9, "t.mountains_n0s0e1w0",  ; mountains E
         "t.mountains_n0s1e1w0", 
         "t.mountains_n1s0e1w0", 
         "t.mountains_n1s1e1w0" 
 10, 10, "t.mountains_n0s0e1w1",  ; mountains E and W
         "t.mountains_n0s1e1w1", 
         "t.mountains_n1s0e1w1", 
         "t.mountains_n1s1e1w1" 
 10, 11, "t.mountains_n0s0e0w1",  ; mountains W
         "t.mountains_n0s1e0w1", 
         "t.mountains_n1s0e0w1", 
         "t.mountains_n1s1e0w1" 

; Darkness (unexplored) to north, south, east, west 

 13,  1, "tx.darkness_n1s0e0w0"
 13,  2, "tx.darkness_n0s0e1w0"
 13,  3, "tx.darkness_n1s0e1w0"
 13,  4, "tx.darkness_n0s1e0w0"
 13,  5, "tx.darkness_n1s1e0w0"
 13,  6, "tx.darkness_n0s1e1w0"
 13,  7, "tx.darkness_n1s1e1w0"
 13,  8, "tx.darkness_n0s0e0w1"
 13,  9, "tx.darkness_n1s0e0w1"
 13, 10, "tx.darkness_n0s0e1w1"
 13, 11, "tx.darkness_n1s0e1w1"
 13, 12, "tx.darkness_n0s1e0w1"
 13, 13, "tx.darkness_n1s1e0w1"
 13, 14, "tx.darkness_n0s1e1w1"
 13, 15, "tx.darkness_n1s1e1w1"

; River outlets, river to north, south, east, west 

  8, 16, "tx.river_outlet_n"
  8, 17, "tx.river_outlet_w"
  8, 18, "tx.river_outlet_s"
  8, 19, "tx.river_outlet_e"

; Denmark tiles, two rows:

 10, 12, "tx.denmark_00"
 10, 13, "tx.denmark_01"
 10, 14, "tx.denmark_02"
 10, 15, "tx.denmark_10"
 10, 16, "tx.denmark_11"
 10, 17, "tx.denmark_12"

; Terrain special resources:

 11,  0, "ts.seals"
 11,  1, "ts.oasis"
 11,  2, "ts.forest_game"
 11,  3, "ts.grassland_resources",
         "ts.river_resources"  ; might as well show something
 11,  4, "ts.coal"
 11,  5, "ts.gems"
 11,  6, "ts.gold"
 11,  7, "ts.fish"
 11,  8, "ts.horses"
;; 11,  9, "ts.river_resources"  ; blank tile
 11, 10, "ts.oil"
 11, 11, "ts.tundra_game"

  5, 16, "ts.spice"
  5, 17, "ts.furs"
  5, 18, "ts.peat"
  5, 19, "ts.arctic_ivory"

  6, 16, "ts.fruit"
  6, 17, "ts.iron"
  6, 18, "ts.whales"
  6, 19, "ts.wheat"

  7, 16, "ts.pheasant"
  7, 17, "ts.buffalo"
  7, 18, "ts.silk"
  7, 19, "ts.wine"

; Terrain improvements and similar:

 12,  7, "tx.farmland"
 12,  8, "tx.irrigation"
 12,  9, "tx.mine"
 12, 10, "tx.oil_mine"
 12, 11, "tx.pollution"
 12, 14, "tx.village"
 12, 15, "tx.fortress"
 13, 16, "tx.airbase"

; Unit activity letters:  (note unit icons have just "u.")

  9, 18, "unit.auto_attack",
         "unit.auto_settler"
  9, 19, "unit.stack"
 10, 18, "unit.connect"
 10, 19, "unit.auto_explore"
 11, 12, "unit.transform"
 11, 13, "unit.sentry"
 11, 14, "unit.goto"
 11, 15, "unit.mine"
 11, 16, "unit.pollution"
 11, 17, "unit.road"
 11, 18, "unit.irrigate"
 11, 19, "unit.fortify",
         "unit.fortress"
 12, 16, "unit.airbase"
 12, 17, "unit.pillage"

; Unit hit-point bars: approx percent of hp remaining

 16,  0, "unit.hp_100"
 16,  1, "unit.hp_90"
 16,  2, "unit.hp_80"
 16,  3, "unit.hp_70"
 16,  4, "unit.hp_60"
 16,  5, "unit.hp_50"
 16,  6, "unit.hp_40"
 16,  7, "unit.hp_30"
 16,  8, "unit.hp_20"
 16,  9, "unit.hp_10"
 16, 10, "unit.hp_0"

; Numbers: city size:

 14,  0, "city.size_0"
 14,  1, "city.size_1"
 14,  2, "city.size_2"
 14,  3, "city.size_3"
 14,  4, "city.size_4"
 14,  5, "city.size_5"
 14,  6, "city.size_6"
 14,  7, "city.size_7"
 14,  8, "city.size_8"
 14,  9, "city.size_9"
 14, 10, "city.size_10"
 14, 11, "city.size_20"
 14, 12, "city.size_30"
 14, 13, "city.size_40"
 14, 14, "city.size_50"
 14, 15, "city.size_60"
 14, 16, "city.size_70"
 14, 17, "city.size_80"
 14, 18, "city.size_90"

; Numbers: city tile food/shields/trade y/g/b

 17,  0, "city.t_food_0"
 17,  1, "city.t_food_1"
 17,  2, "city.t_food_2"
 17,  3, "city.t_food_3"
 17,  4, "city.t_food_4"
 17,  5, "city.t_food_5"
 17,  6, "city.t_food_6"
 17,  7, "city.t_food_7"
 17,  8, "city.t_food_8"
 17,  9, "city.t_food_9"

 15,  0, "city.t_shields_0"
 15,  1, "city.t_shields_1"
 15,  2, "city.t_shields_2"
 15,  3, "city.t_shields_3"
 15,  4, "city.t_shields_4"
 15,  5, "city.t_shields_5"
 15,  6, "city.t_shields_6"
 15,  7, "city.t_shields_7"
 15,  8, "city.t_shields_8"
 15,  9, "city.t_shields_9"

 15, 10, "city.t_trade_0"
 15, 11, "city.t_trade_1"
 15, 12, "city.t_trade_2"
 15, 13, "city.t_trade_3"
 15, 14, "city.t_trade_4"
 15, 15, "city.t_trade_5"
 15, 16, "city.t_trade_6"
 15, 17, "city.t_trade_7"
 15, 18, "city.t_trade_8"
 15, 19, "city.t_trade_9"

; Unit upkeep in city dialog:
; These should probably be handled differently and have
; a different size...

 16, 15, "upkeep.food"
 16, 16, "upkeep.food2"
 16, 17, "upkeep.unhappy"
 16, 18, "upkeep.unhappy2"
 16, 19, "upkeep.shield"

; Nuclear explosion: this could maybe now be handled as one 
; big graphic (?), but for now is done old way as 3 by 3:

  1, 17, "explode.nuke_00"
  1, 18, "explode.nuke_01"
  1, 19, "explode.nuke_02"
  2, 17, "explode.nuke_10"
  2, 18, "explode.nuke_11"
  2, 19, "explode.nuke_12"
  3, 17, "explode.nuke_20"
  3, 18, "explode.nuke_21"
  3, 19, "explode.nuke_22"

; Misc:

  9, 17, "user.attention"	; Variously crosshair/red-square/arrows

}
