<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1396 $
 * $Id: CheckForUpdate.php 1396 2007-11-07 16:49:35Z ipso $
 * $Date: 2007-11-07 08:49:35 -0800 (Wed, 07 Nov 2007) $
 */
/*
 * Checks for any version updates...
 *
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

$ttsc = new TimeTrexSoapClient();
if ( $ttsc->isUpdateNotifyEnabled() == TRUE ) {
	$clf = new CompanyListFactory();
	$clf->getAll();
	if ( $clf->getRecordCount() > 0 ) {
		$i=0;
		foreach ( $clf as $c_obj ) {

			if ( $ttsc->getLocalRegistrationKey() == FALSE
					OR $ttsc->getLocalRegistrationKey() == '' ) {
				$ttsc->saveRegistrationKey();
			}

			//We must ensure that the data is up to date
			//Otherwise version check will fail.
			$ttsc->sendCompanyData( $c_obj->getId() );
			$ttsc->sendCompanyUserLocationData( $c_obj->getId() );
			$ttsc->sendCompanyUserCountData( $c_obj->getId() );
			$ttsc->sendCompanyVersionData( $c_obj->getId() );

			//Only need to call this on the last company
			if ( $i == $clf->getRecordCount()-1 ) {
				$latest_version = $ttsc->isLatestVersion( $c_obj->getId() );
				$latest_tax_engine_version = $ttsc->isLatestTaxEngineVersion( $c_obj->getId() );
				$latest_tax_data_version = $ttsc->isLatestTaxDataVersion( $c_obj->getId() );

				$sslf = new SystemSettingListFactory();
				$sslf->getByName('new_version');
				if ( $sslf->getRecordCount() == 1 ) {
					$obj = $sslf->getCurrent();
				} else {
					$obj = new SystemSettingListFactory();
				}
				$obj->setName( 'new_version' );

				if( $latest_version == FALSE
						OR $latest_tax_engine_version == FALSE
						OR $latest_tax_data_version == FALSE ) {
					$obj->setValue( 1 );
				} else {
					$obj->setValue( 0 );
				}

				if ( $obj->isValid() ) {
					$obj->Save();
				}
			}

			$i++;
		}
	}
} else {
	Debug::Text('Auto Update Notifications are disabled!', __FILE__, __LINE__, __METHOD__,10);
}
Debug::writeToLog();
Debug::Display();
?>