<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1676 $
 * $Id: Form941.php 1676 2008-01-22 03:28:58Z ipso $
 * $Date: 2008-01-21 19:28:58 -0800 (Mon, 21 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');
require(Environment::getBasePath() .'/classes/fpdi/fpdi.php');

if ( !$permission->Check('report','enabled')
		OR !$permission->Check('report','view_form941') ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Form 941 Report')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'setup_data',
												'generic_data',
												'filter_data'
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'filter_data' => $filter_data
//													'sort_column' => $sort_column,
//													'sort_order' => $sort_order,
												) );

$pseallf = new PayStubEntryAccountLinkListFactory();
$pseallf->getByCompanyId( $current_company->getId() );
if ( $pseallf->getRecordCount() > 0 ) {
	$pseal_obj = $pseallf->getCurrent();
}

$column_ps_entry_name_map = array(
								'2' => @$setup_data['2_psea_ids'], //Gross Pay
								'3' => @$setup_data['3_psea_ids'],
								'5a' => @$setup_data['5a_psea_ids'],
								'5b' => @$setup_data['5b_psea_ids'],
								'5c' => @$setup_data['5c_psea_ids'],
								'7b' => @$setup_data['7b_psea_ids'],
								'9' => @$setup_data['9_psea_ids'],
								);

$pplf = new PayPeriodListFactory();
$year_options = $pplf->getYearsArrayByCompanyId( $current_company->getId() );

$quarter_options = array(
						1 => TTi18n::gettext('Quarter 1 (01-Jan to 31-Mar)'),
						2 => TTi18n::gettext('Quarter 2 (01-Apr to 30-Jun)'),
						3 => TTi18n::gettext('Quarter 3 (01-Jul to 30-Sep)'),
						4 => TTi18n::gettext('Quarter 4 (01-Oct to 31-Dec)'),
						);

$quarter_dates = array(
						1 => array(
									1 => array( 'start' => mktime(0,0,0,1,1, $filter_data['year'] ), 'end' => mktime(0,0,0,2,0, $filter_data['year'] ) ),
									2 => array( 'start' => mktime(0,0,0,2,1, $filter_data['year'] ), 'end' => mktime(0,0,0,3,0, $filter_data['year'] ) ),
									3 => array( 'start' => mktime(0,0,0,3,1, $filter_data['year'] ), 'end' => mktime(0,0,0,4,0, $filter_data['year'] ) ),
									),
						2 => array(
									1 => array( 'start' => mktime(0,0,0,4,1, $filter_data['year'] ), 'end' => mktime(0,0,0,5,0, $filter_data['year'] ) ),
									2 => array( 'start' => mktime(0,0,0,5,1, $filter_data['year'] ), 'end' => mktime(0,0,0,6,0, $filter_data['year'] ) ),
									3 => array( 'start' => mktime(0,0,0,6,1, $filter_data['year'] ), 'end' => mktime(0,0,0,7,0, $filter_data['year'] ) ),
									),
						3 => array(
									1 => array( 'start' => mktime(0,0,0,7,1, $filter_data['year'] ), 'end' => mktime(0,0,0,8,0, $filter_data['year'] ) ),
									2 => array( 'start' => mktime(0,0,0,8,1, $filter_data['year'] ), 'end' => mktime(0,0,0,9,0, $filter_data['year'] ) ),
									3 => array( 'start' => mktime(0,0,0,9,1, $filter_data['year'] ), 'end' => mktime(0,0,0,10,0, $filter_data['year'] ) ),
									),
						4 => array(
									1 => array( 'start' => mktime(0,0,0,10,1, $filter_data['year'] ), 'end' => mktime(0,0,0,11,0, $filter_data['year'] ) ),
									2 => array( 'start' => mktime(0,0,0,11,1, $filter_data['year'] ), 'end' => mktime(0,0,0,12,0, $filter_data['year'] ) ),
									3 => array( 'start' => mktime(0,0,0,12,1, $filter_data['year'] ), 'end' => mktime(0,0,0,13,0, $filter_data['year'] ) ),
									)
						);

$filter_data = Misc::preSetArrayValues( $filter_data, array('include_user_ids', 'exclude_user_ids', 'user_status_ids', 'group_ids', 'branch_ids', 'department_ids', 'user_title_ids', 'pay_period_ids', 'column_ids' ), array() );

$ugdlf = new UserGenericDataListFactory();
$ugdf = new UserGenericDataFactory();

$action = Misc::findSubmitButton();
Debug::Text('Action: '. $action, __FILE__, __LINE__, __METHOD__,10);
switch ($action) {
	case 'display_form':
	case 'print_form':
	case 'display_report':
		//Debug::setVerbosity(11);
		if ( $action == 'print_form' ) {
			$show_background = FALSE;
		} else {
			$show_background = TRUE;
		}

		Debug::Text('Submit!: '. $action, __FILE__, __LINE__, __METHOD__,10);
		Debug::Arr($filter_data, 'aFilter Data', __FILE__, __LINE__, __METHOD__,10);

		//Save report setup data
		$ugdlf->getByCompanyIdAndScriptAndDefault( $current_company->getId(), $_SERVER['SCRIPT_NAME'] );
		if ( $ugdlf->getRecordCount() > 0 ) {
			$ugdf->setID( $ugdlf->getCurrent()->getID() );
		}
		$ugdf->setCompany( $current_company->getId() );
		$ugdf->setName( $title );
		$ugdf->setScript( $_SERVER['SCRIPT_NAME'] );
		$ugdf->setData( $setup_data );
		$ugdf->setDefault( TRUE );
		if ( $ugdf->isValid() ) {
			$ugdf->Save();
		}

		$ulf = new UserListFactory();
		$ulf->getSearchByCompanyIdAndArrayCriteria( $current_company->getId(), $filter_data );

		if ( $ulf->getRecordCount() > 0 ) {
			foreach( $ulf as $u_obj ) {
				$filter_data['user_ids'][] = $u_obj->getId();
			}

			if ( isset($filter_data['user_ids']) AND isset($filter_data['quarter_id']) ) {
				$pseallf = new PayStubEntryAccountLinkListFactory();
				$pseallf->getByCompanyId( $current_company->getId() );
				if ( $pseallf->getRecordCount() > 0 ) {
					$pseal_obj = $pseallf->getCurrent();
				}

				//
				//Get all data for the form.
				//
				$ein = str_replace(array('-', ' '), '', $current_company->getBusinessNumber() );

				$total_users = 0;
				foreach( $quarter_dates[$filter_data['quarter_id']] as $month_id => $quarter_dates_arr ) {
					//Get Pay Periods in date range.
					Debug::Text('Start Date: '. TTDate::getDate('DATE+TIME', $quarter_dates_arr['start']) .' End Date: '. TTDate::getDate('DATE+TIME', $quarter_dates_arr['end']), __FILE__, __LINE__, __METHOD__,10);

					$pplf = new PayPeriodListFactory();
					$pplf->getByCompanyIdAndTransactionStartDateAndTrasnactionEndDate( $current_company->getId(), $quarter_dates_arr['start'], $quarter_dates_arr['end'] );
					if ( $pplf->getRecordCount() > 0 ) {
						foreach($pplf as $pp_obj) {
							$pay_period_ids[] = $pp_obj->getID();
							$pay_period_transaction_dates[$pp_obj->getID()] = $pp_obj->getTransactionDate();
						}
					}

					if ( isset($pay_period_ids) ) {
						$pslf = new PayStubListFactory();
						$pslf->getByCompanyIdAndPayPeriodId( $current_company->getId(), $pay_period_ids );
						if ( $pslf->getRecordCount() > 0 ) {
							foreach( $pslf as $ps_obj ) {
								if ( in_array( $ps_obj->getUser(), $filter_data['user_ids']) ) {
									$pay_stub_users[] = $ps_obj->getUser();
								}
							}
							$pay_stub_users = array_unique($pay_stub_users);

							if ( count($pay_stub_users) > $total_users ) {
								$total_users = count($pay_stub_users);
							}
							unset($pay_stub_users);
						}


						foreach( $pay_period_ids as $pay_period_id ) {
							//PS Account Amounts...
							//Get employees who have recieved pay stubs.
							$pself = new PayStubEntryListFactory();
							$pself->getReportByCompanyIdAndUserIdAndPayPeriodId( $current_company->getId(), $filter_data['user_ids'], $pay_period_id );
							if ( $pself->getRecordCount() > 0 ) {
								foreach( $pself as $pse_obj ) {

									//$user_id = $pse_obj->getColumn('user_id');
									//$pay_stub_entry_name_id = $pse_obj->getColumn('pay_stub_entry_name_id');
									$pay_stub_entry_name_id = $pse_obj->getPayStubEntryNameId();

									if ( isset($ps_entries[$pay_stub_entry_name_id]) ) {
										$ps_entries[$pay_stub_entry_name_id] = bcadd($ps_entries[$pay_stub_entry_name_id],$pse_obj->getColumn('amount'),2 );
									} else {
										$ps_entries[$pay_stub_entry_name_id] = $pse_obj->getColumn('amount');
									}
								}
							}

							if ( isset($ps_entries) ) {
								$pp_lines_arr[$month_id][$pay_period_id]['2'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['2']);
								$pp_lines_arr[$month_id][$pay_period_id]['3'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['3']);

								$pp_lines_arr[$month_id][$pay_period_id]['5a'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['5a']);
								$pp_lines_arr[$month_id][$pay_period_id]['5a2'] = bcmul( $pp_lines_arr[$month_id][$pay_period_id]['5a'], 0.124 );
								$pp_lines_arr[$month_id][$pay_period_id]['5b'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['5b']);
								$pp_lines_arr[$month_id][$pay_period_id]['5b2'] = bcmul( $pp_lines_arr[$month_id][$pay_period_id]['5b'], 0.124 );
								$pp_lines_arr[$month_id][$pay_period_id]['5c'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['5c']);
								$pp_lines_arr[$month_id][$pay_period_id]['5c2'] = bcmul( $pp_lines_arr[$month_id][$pay_period_id]['5c'], 0.029 );
								$pp_lines_arr[$month_id][$pay_period_id]['5d'] =  bcadd( bcadd( $pp_lines_arr[$month_id][$pay_period_id]['5a2'], $pp_lines_arr[$month_id][$pay_period_id]['5b2']), $pp_lines_arr[$month_id][$pay_period_id]['5c2']);
								$pp_lines_arr[$month_id][$pay_period_id]['6'] = bcadd( $pp_lines_arr[$month_id][$pay_period_id]['3'], $pp_lines_arr[$month_id][$pay_period_id]['5d']);

								$pp_lines_arr[$month_id][$pay_period_id]['7a'] = bcsub( Misc::MoneyFormat($pp_lines_arr[$month_id][$pay_period_id]['5d'], FALSE) , bcadd( bcadd($pp_lines_arr[$month_id][$pay_period_id]['5a2'], $pp_lines_arr[$month_id][$pay_period_id]['5b2']), $pp_lines_arr[$month_id][$pay_period_id]['5c2'] ) );
								$pp_lines_arr[$month_id][$pay_period_id]['7b'] = Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['7b']);

								$pp_lines_arr[$month_id][$pay_period_id]['7h'] = bcadd($pp_lines_arr[$month_id][$pay_period_id]['7a'], $pp_lines_arr[$month_id][$pay_period_id]['7b']);
								$pp_lines_arr[$month_id][$pay_period_id]['8'] = bcadd( $pp_lines_arr[$month_id][$pay_period_id]['6'], $pp_lines_arr[$month_id][$pay_period_id]['7h']);
								$pp_lines_arr[$month_id][$pay_period_id]['9'] = abs(Misc::sumMultipleColumns( $ps_entries, $column_ps_entry_name_map['9']) );
								$pp_lines_arr[$month_id][$pay_period_id]['10'] = bcsub( $pp_lines_arr[$month_id][$pay_period_id]['8'], $pp_lines_arr[$month_id][$pay_period_id]['9']);
								$pp_lines_arr[$month_id][$pay_period_id]['11'] = 0;
								$pp_lines_arr[$month_id][$pay_period_id]['12'] = Misc::MoneyFormat( abs( bcsub( $pp_lines_arr[$month_id][$pay_period_id]['11'],$pp_lines_arr[$month_id][$pay_period_id]['10']) ), FALSE );
							}
							unset($ps_entries);
						}

						//Total all pay periods by month_id
						if ( isset($pp_lines_arr) ) {
							foreach( $pp_lines_arr as $month_id => $pp_data ) {
								$lines_arr[$month_id] = Misc::ArrayAssocSum($pp_data, NULL, 8);
							}
						}
					}
					unset($pay_period_ids, $ps_entries);
				}
				if ( isset($lines_arr) ) {
					$lines_arr['total'] = Misc::ArrayAssocSum($lines_arr, NULL, 6);
					Debug::Arr($lines_arr, 'Lines Array: ', __FILE__, __LINE__, __METHOD__,10);
				}

				$border = 0;

				$adjust_x = 0;
				$adjust_y = 0;

				$pdf= new fpdi();

				if ( $show_background == TRUE ) {
					//Import original Gov't supplied PDF.
					$pagecount = $pdf->setSourceFile(Environment::getBasePath().'interface'. DIRECTORY_SEPARATOR .'forms'. DIRECTORY_SEPARATOR .'us'. DIRECTORY_SEPARATOR .'tax'. DIRECTORY_SEPARATOR .'f941.pdf');
					$tplidx = $pdf->ImportPage(1);
					$tplidx2 = $pdf->ImportPage(2);
				}

				$pdf->setMargins(0,0,0,0);
				$pdf->SetAutoPageBreak(FALSE);
				$pdf->SetFont('freeserif','',10);

				$pdf->AddPage();
				if ( isset($tplidx) ) {
					$pdf->useTemplate($tplidx,0,0);
				}

				//Form year
				if ( $show_background == TRUE ) {
					//Top left form number and year
					$pdf->SetFont('freeserif','B', 18);
					$pdf->setFillColor( 255,255,255 );
					$pdf->setXY( Misc::AdjustXY(19, $adjust_x), Misc::AdjustXY(12, $adjust_y) );
					$pdf->Cell(35,6,'941 for '. $filter_data['year'], $border, 0, 'C', 1);

					//Form revision below number/year
					$pdf->SetFont('freeserif','', 7);
					$pdf->setXY( Misc::AdjustXY(28.5, $adjust_x), Misc::AdjustXY(17.5, $adjust_y) );
					$pdf->Cell(6, 4, $filter_data['year'], $border, 0, 'C', 1);

					//Form serial number at top right. (Need proper font)
					//$pdf->SetFont('freeserif','', 12);
					//$pdf->setXY( Misc::AdjustXY(186, $adjust_x), Misc::AdjustXY(17.5, $adjust_y) );
					//$pdf->Cell(20, 10, '9901'.substr( $filter_data['year'], 2, 2) , $border, 0, 'C', 1);

					//Form revision at bottom right of 1st page
					$pdf->SetFont('freeserif','', 7);
					$pdf->setXY( Misc::AdjustXY(187.5, $adjust_x), Misc::AdjustXY(270, $adjust_y) );
					$pdf->Cell(18, 4, '(Rev. 1-'. $filter_data['year'] .')', $border, 0, 'C', 1);

					//"Report for this quarter ..."
					$pdf->SetFont('freeserif','', 15);
					$pdf->setTextColor( 255,255,255 );
					$pdf->setFillColor( 0,0,0 );
					$pdf->setXY( Misc::AdjustXY(186, $adjust_x), Misc::AdjustXY(26, $adjust_y) );
					$pdf->Cell(12, 3, '...', $border, 0, 'L', 1);
					$pdf->setTextColor( 0,0,0 );
					$pdf->setFillColor( 255,255,255 );

					$pdf->SetFont('freeserif','', 10);
				}

				//EIN
				if ( isset($ein) AND strlen($ein) > 5 ) {
					$pdf->setXY( Misc::AdjustXY(54, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[0], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(63, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[1], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(77, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[2], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(85, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[3], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(94, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[4], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(103, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[5], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(112, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[6], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[7], $border, 0, 'C');

					$pdf->setXY( Misc::AdjustXY(130, $adjust_x), Misc::AdjustXY(24, $adjust_y) );
					$pdf->Cell(7,7,$ein[8], $border, 0, 'C');
				}

				//Name
				if ( $setup_data['name'] != '' ) {
					$pdf->setXY( Misc::AdjustXY(49, $adjust_x), Misc::AdjustXY(33, $adjust_y) );
					$pdf->Cell(90,6,$setup_data['name'], $border, 0, 'L');
				}

				//Trade name
				$pdf->setXY( Misc::AdjustXY(41, $adjust_x), Misc::AdjustXY(42, $adjust_y) );
				$pdf->Cell(90,6,$current_company->getName(), $border, 0, 'L');

				$pdf->setXY( Misc::AdjustXY(28, $adjust_x), Misc::AdjustXY(50, $adjust_y) );
				$pdf->Cell(100,6,$current_company->getAddress1() .' '. $current_company->getAddress2(), $border, 0, 'L');

				$pdf->setXY( Misc::AdjustXY(28, $adjust_x), Misc::AdjustXY(59, $adjust_y) );
				$pdf->Cell(65,6,$current_company->getCity(), $border, 0, 'L');

				$pdf->setXY( Misc::AdjustXY(96, $adjust_x), Misc::AdjustXY(59, $adjust_y) );
				$pdf->Cell(12,6,$current_company->getProvince(), $border, 0, 'C');

				$pdf->setXY( Misc::AdjustXY(111, $adjust_x), Misc::AdjustXY(59, $adjust_y) );
				$pdf->Cell(23,6,$current_company->getPostalCode(), $border, 0, 'C');

				//Select Quarter
				switch( $filter_data['quarter_id'] ) {
					case 1;
						$pdf->setXY( Misc::AdjustXY(150, $adjust_x), Misc::AdjustXY(36, $adjust_y) );
						break;
					case 2;
						$pdf->setXY( Misc::AdjustXY(150, $adjust_x), Misc::AdjustXY(42, $adjust_y) );
						break;
					case 3;
						$pdf->setXY( Misc::AdjustXY(150, $adjust_x), Misc::AdjustXY(49, $adjust_y) );
						break;
					case 4;
						$pdf->setXY( Misc::AdjustXY(150, $adjust_x), Misc::AdjustXY(55, $adjust_y) );
						break;
				}
				$pdf->Cell(5,6,'X', $border, 0, 'C');

				//Line1
				$pdf->setXY( Misc::AdjustXY(173, $adjust_x), Misc::AdjustXY(80, $adjust_y) );
				$pdf->Cell(25,6,$total_users, $border, 0, 'R');

				if ( isset($lines_arr) ) {
					//Line2
					$pdf->setXY( Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(88, $adjust_y) );
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['2'], FALSE) ), $border, 0, 'R');
					$pdf->setXY( Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(88, $adjust_y) );
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['2'], FALSE) ), $border, 0, 'L');

					//Line3
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(95, $adjust_y) );
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['3'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(95, $adjust_y) );
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['3'], FALSE) ), $border, 0, 'L');

					if ( $lines_arr['total']['5d'] == 0 ) {
						$pdf->setXY(Misc::AdjustXY(156, $adjust_x), Misc::AdjustXY(101, $adjust_y) );
						$pdf->Cell(5,6, 'X', $border, 0, 'L');
					}

					//Line5a - 1
					$pdf->setXY(Misc::AdjustXY(70, $adjust_x), Misc::AdjustXY(116, $adjust_y) );
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5a'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(97, $adjust_x), Misc::AdjustXY(116, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5a'], FALSE) ), $border, 0, 'L');
					//Line5a - 2
					$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(116, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5a2'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(148, $adjust_x), Misc::AdjustXY(116, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5a2'], FALSE) ), $border, 0, 'L');

					//Line5b - 1
					$pdf->setXY(Misc::AdjustXY(70, $adjust_x), Misc::AdjustXY(123, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal(Misc::MoneyFormat($lines_arr['total']['5b'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(97, $adjust_x), Misc::AdjustXY(123, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5b'], FALSE) ), $border, 0, 'L');
					//Line5b - 2
					$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(123, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5b2'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(148, $adjust_x), Misc::AdjustXY(123, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5b2'], FALSE) ), $border, 0, 'L');

					//Line5c - 1
					$pdf->setXY(Misc::AdjustXY(70, $adjust_x), Misc::AdjustXY(131, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5c'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(97, $adjust_x), Misc::AdjustXY(131, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5c'], FALSE) ), $border, 0, 'L');
					//Line5c - 2
					$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(131, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5c2'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(148, $adjust_x), Misc::AdjustXY(131, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5c2'], FALSE) ), $border, 0, 'L');

					//Line5d
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(139, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['5d'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(139, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['5d'], FALSE) ), $border, 0, 'L');

					//Line6
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(146, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['6'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(146, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['6'], FALSE) ), $border, 0, 'L');

					//Line7a
					$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(157, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['7a'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(148, $adjust_x), Misc::AdjustXY(157, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['7a'], FALSE) ), $border, 0, 'L');

					//Line7b
					$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(165, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['7b'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(148, $adjust_x), Misc::AdjustXY(165, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['7b'], FALSE) ), $border, 0, 'L');

					//Line7h
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(209, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['7h'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(209, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['7h'], FALSE) ), $border, 0, 'L');

					//Line8
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(216, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['8'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(216, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['8'], FALSE) ), $border, 0, 'L');

					//Line9
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(223, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['9'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(223, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['9'], FALSE) ), $border, 0, 'L');

					//Line10
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(231, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(231, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'L');

					//Line11
					$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(238, $adjust_y));
					$pdf->Cell(25,6, Misc::getBeforeDecimal( 0 ), $border, 0, 'R');
					$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(238, $adjust_y));
					$pdf->Cell(6,6, Misc::getAfterDecimal( '0.00' ), $border, 0, 'L');

					//Line12
					if ( isset($lines_arr['total']['12']) ) {
						$pdf->setXY(Misc::AdjustXY(165, $adjust_x), Misc::AdjustXY(245, $adjust_y));
						$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['12'], FALSE) ), $border, 0, 'R');
						$pdf->setXY(Misc::AdjustXY(193, $adjust_x), Misc::AdjustXY(245, $adjust_y));
						$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['12'], FALSE) ), $border, 0, 'L');
					}

					//Line13
					/*
					if ( isset($line13) ) {
						$pdf->setXY(121,255);
						$pdf->Cell(25,6, Misc::getBeforeDecimal( $line13 ), $border, 0, 'R');
						$pdf->setXY(148,255);
						$pdf->Cell(6,6, Misc::getAfterDecimal( $line13 ), $border, 0, 'L');
					}
					*/
				}

				$pdf->AddPage();
				if ( isset($tplidx2) ) {
					$pdf->useTemplate($tplidx2,0,0);
				}

				//Form year
				if ( $show_background == TRUE ) {

					//Form revision at bottom of 1st page
					$pdf->SetFont('freeserif','', 7);
					$pdf->setXY( Misc::AdjustXY(187.5, $adjust_x), Misc::AdjustXY(268.5, $adjust_y) );
					$pdf->Cell(18, 4, '(Rev. 1-'. $filter_data['year'] .')', $border, 0, 'C', 1);

					$pdf->SetFont('freeserif','', 10);
				}

				//Company
				$pdf->setXY(Misc::AdjustXY(14, $adjust_x), Misc::AdjustXY(23, $adjust_y));
				$pdf->Cell(90,6,$current_company->getName(), $border, 0, 'L');

				//EIN
				$pdf->setXY(Misc::AdjustXY(141, $adjust_x), Misc::AdjustXY(23, $adjust_y));
				$pdf->Cell(50,6,$current_company->getBusinessNumber(), $border, 0, 'L');

				//Deposit State
				$pdf->setXY(Misc::AdjustXY(23, $adjust_x), Misc::AdjustXY(44, $adjust_y));
				$pdf->Cell(5,6, substr($current_company->getProvince(),0,1), $border, 0, 'L');
				$pdf->setXY(Misc::AdjustXY(31, $adjust_x), Misc::AdjustXY(44, $adjust_y));
				$pdf->Cell(5,6, substr($current_company->getProvince(),1,1), $border, 0, 'L');

				//Line15
				if ( isset($setup_data['deposit_schedule']) AND $setup_data['deposit_schedule'] == 10 AND isset($lines_arr['total']) AND $lines_arr['total']['10'] < 2500 ) {
					$pdf->setXY(Misc::AdjustXY(41, $adjust_x), Misc::AdjustXY(53, $adjust_y));
					$pdf->Cell(5,6, 'X', $border, 0, 'L');
				} elseif ( isset($setup_data['deposit_schedule']) AND $setup_data['deposit_schedule'] == 10 ) {
					$pdf->setXY(Misc::AdjustXY(41, $adjust_x), Misc::AdjustXY(60, $adjust_y));
					$pdf->Cell(5,6, 'X', $border, 0, 'L');

					if ( isset($lines_arr) ) {
						//Split taxes out by month
						if ( isset($lines_arr['1']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(93, $adjust_x), Misc::AdjustXY(72, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['1']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(72, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['1']['10'], FALSE) ), $border, 0, 'L');
						}

						if ( isset($lines_arr['2']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(93, $adjust_x), Misc::AdjustXY(80, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['2']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(80, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['2']['10'], FALSE) ), $border, 0, 'L');
						}

						if ( isset($lines_arr['3']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(93, $adjust_x), Misc::AdjustXY(89, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['3']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(89, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['3']['10'], FALSE) ), $border, 0, 'L');
						}

						$pdf->setXY(Misc::AdjustXY(93, $adjust_x), Misc::AdjustXY(97, $adjust_y));
						$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'R');
						$pdf->setXY(Misc::AdjustXY(121, $adjust_x), Misc::AdjustXY(97, $adjust_y));
						$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'L');
					}
				} elseif ( isset($setup_data['deposit_schedule']) AND $setup_data['deposit_schedule'] == 20 ) {
					$pdf->setXY(Misc::AdjustXY(41, $adjust_x), Misc::AdjustXY(103, $adjust_y));
					$pdf->Cell(5,6, 'X', $border, 0, 'L');

					//Attach schedule B.
					$pdf->setSourceFile(Environment::getBasePath().'interface'. DIRECTORY_SEPARATOR .'forms'. DIRECTORY_SEPARATOR .'us'. DIRECTORY_SEPARATOR .'tax'. DIRECTORY_SEPARATOR .'f941sb.pdf');
					$tplidx3 = $pdf->ImportPage(1);

					$pdf->AddPage();
					if ( isset($tplidx3) ) {
						$pdf->useTemplate($tplidx3,0,0);
					}

					//EIN
					if ( isset($ein) AND strlen($ein) > 5 ) {
						$pdf->setXY( Misc::AdjustXY(52, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[0], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(61, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[1], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(75, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[2], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(83, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[3], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(92, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[4], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(101, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[5], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(110, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[6], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(119, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[7], $border, 0, 'C');

						$pdf->setXY( Misc::AdjustXY(128, $adjust_x), Misc::AdjustXY(32, $adjust_y) );
						$pdf->Cell(7,7,$ein[8], $border, 0, 'C');
					}

					$pdf->setXY( Misc::AdjustXY(46, $adjust_x), Misc::AdjustXY(40, $adjust_y) );
					$pdf->Cell(90,6,$current_company->getName(), $border, 0, 'L');

					switch( $filter_data['quarter_id'] ) {
						case 1;
							$pdf->setXY( Misc::AdjustXY(149, $adjust_x), Misc::AdjustXY(41, $adjust_y) );
							break;
						case 2;
							$pdf->setXY( Misc::AdjustXY(149, $adjust_x), Misc::AdjustXY(48, $adjust_y) );
							break;
						case 3;
							$pdf->setXY( Misc::AdjustXY(149, $adjust_x), Misc::AdjustXY(54, $adjust_y) );
							break;
						case 4;
							$pdf->setXY( Misc::AdjustXY(149, $adjust_x), Misc::AdjustXY(60, $adjust_y) );
							break;
					}
					$pdf->Cell(5,6,'X', $border, 0, 'C');

					//Calendar Year
					$pdf->setXY( Misc::AdjustXY(51, $adjust_x), Misc::AdjustXY(47, $adjust_y) );
					$pdf->Cell(7,7,$filter_data['year'][0], $border, 0, 'C');
					$pdf->setXY( Misc::AdjustXY(60, $adjust_x), Misc::AdjustXY(47, $adjust_y) );
					$pdf->Cell(7,7,$filter_data['year'][1], $border, 0, 'C');
					$pdf->setXY( Misc::AdjustXY(69, $adjust_x), Misc::AdjustXY(47, $adjust_y) );
					$pdf->Cell(7,7,$filter_data['year'][2], $border, 0, 'C');
					$pdf->setXY( Misc::AdjustXY(78, $adjust_x), Misc::AdjustXY(47, $adjust_y) );
					$pdf->Cell(7,7,$filter_data['year'][3], $border, 0, 'C');

					if ( isset($lines_arr) ) {
						//Split taxes out by month
						if ( isset($lines_arr['1']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(169, $adjust_x), Misc::AdjustXY(101, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['1']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(195, $adjust_x), Misc::AdjustXY(101, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['1']['10'], FALSE) ), $border, 0, 'L');
						}

						if ( isset($lines_arr['2']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(169, $adjust_x), Misc::AdjustXY(156, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['2']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(195, $adjust_x), Misc::AdjustXY(156, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['2']['10'], FALSE) ), $border, 0, 'L');
						}

						if ( isset($lines_arr['3']['10']) ) {
							$pdf->setXY(Misc::AdjustXY(169, $adjust_x), Misc::AdjustXY(212, $adjust_y));
							$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['3']['10'], FALSE) ), $border, 0, 'R');
							$pdf->setXY(Misc::AdjustXY(195, $adjust_x), Misc::AdjustXY(212, $adjust_y));
							$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['3']['10'], FALSE) ), $border, 0, 'L');
						}

						$pdf->setXY(Misc::AdjustXY(169, $adjust_x), Misc::AdjustXY(260, $adjust_y));
						$pdf->Cell(25,6, Misc::getBeforeDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'R');
						$pdf->setXY(Misc::AdjustXY(195, $adjust_x), Misc::AdjustXY(260, $adjust_y));
						$pdf->Cell(6,6, Misc::getAfterDecimal( Misc::MoneyFormat($lines_arr['total']['10'], FALSE) ), $border, 0, 'L');

						$month_offsets[1] = array( 'x' => 32, 'y' => 93 );
						$month_offsets[2] = array( 'x' => 32, 'y' => 148 );
						$month_offsets[3] = array( 'x' => 32, 'y' => 203 );
						//Fill in per day amounts.
						$border=0;
						for( $i=1; $i <= 3; $i++ ) {
							$x = Misc::AdjustXY($month_offsets[$i]['x'], $adjust_x);
							$y = Misc::AdjustXY($month_offsets[$i]['y'], $adjust_y);

							for( $d=1; $d <= 31; $d++ ) {
								if ( isset($pp_lines_arr[$i]) ) {
									foreach( $pp_lines_arr[$i] as $pay_period_id => $data ) {
										$dom = TTDate::getDayOfMonth($pay_period_transaction_dates[$pay_period_id]);
										if ( $d == $dom ) {
											Debug::Text('X: '. $x .' Y: '. $y, __FILE__, __LINE__, __METHOD__,10);
											$pdf->setXY( $x, $y );
											$pdf->Cell(6,6, Misc::getBeforeDecimal( Misc::MoneyFormat($data['10'], FALSE) ), $border, 0, 'R');
											$pdf->Cell(6,6, '  '.Misc::getAfterDecimal( Misc::MoneyFormat($data['10'], FALSE) ), $border, 0, 'L');
										}
									}
								}

								$y += 6.250;
								if ( $d > 0 AND $d % 8 == 0 ) {
									Debug::Text('  New Column', __FILE__, __LINE__, __METHOD__,10);
									$x += 37;
									$y = $month_offsets[$i]['y'];
								}
							}
						}
					}
				}

				//Finish off PDF
				$output = $pdf->Output('','S');

				if ( Debug::getVerbosity() == 11 ) {
					Debug::Display();
				} else {
					Misc::FileDownloadHeader('f941.pdf', 'application/pdf', strlen($output));
					echo $output;
				}
				exit;
			}
		}
		break;
	case 'delete':
	case 'save':
		Debug::Text('Action: '. $action, __FILE__, __LINE__, __METHOD__,10);

		$generic_data['id'] = UserGenericDataFactory::reportFormDataHandler( $action, $filter_data, $generic_data, URLBuilder::getURL(NULL, $_SERVER['SCRIPT_NAME']) );
		unset($generic_data['name']);
	default:
		BreadCrumb::setCrumb($title);

		$ugdlf->getByCompanyIdAndScriptAndDefault( $current_company->getId(), $_SERVER['SCRIPT_NAME'] );
		if ( $ugdlf->getRecordCount() > 0 ) {
			Debug::Text('Found Company Report Setup!', __FILE__, __LINE__, __METHOD__,10);
			$ugd_obj = $ugdlf->getCurrent();
			$setup_data = $ugd_obj->getData();
		}
		unset($ugd_obj);

		if ( $action == 'load' ) {
			Debug::Text('Loading Report!', __FILE__, __LINE__, __METHOD__,10);

			extract( UserGenericDataFactory::getReportFormData( $generic_data['id'] ) );
		} elseif ( $action == '' ) {
			//Check for default saved report first.
			$ugdlf->getByUserIdAndScriptAndDefault( $current_user->getId(), $_SERVER['SCRIPT_NAME'] );
			if ( $ugdlf->getRecordCount() > 0 ) {
				Debug::Text('Found Default Report!', __FILE__, __LINE__, __METHOD__,10);

				$ugd_obj = $ugdlf->getCurrent();
				$filter_data = $ugd_obj->getData();
				$generic_data['id'] = $ugd_obj->getId();
			} else {
				Debug::Text('Default Settings!', __FILE__, __LINE__, __METHOD__,10);
				//Default selections
				$filter_data['user_status_ids'] = array( -1 );
				$filter_data['branch_ids'] = array( -1 );
				$filter_data['department_ids'] = array( -1 );
				$filter_data['user_title_ids'] = array( -1 );
				$filter_data['group_ids'] = array( -1 );
			}
		}
		$filter_data = Misc::preSetArrayValues( $filter_data, array('include_user_ids', 'exclude_user_ids', 'user_status_ids', 'group_ids', 'branch_ids', 'department_ids', 'user_title_ids', 'pay_period_ids', 'column_ids' ), NULL );

		$ulf = new UserListFactory();
		$all_array_option = array('-1' => TTi18n::gettext('-- All --'));

		//Get include employee list.
		$ulf->getByCompanyId( $current_company->getId() );
		$user_options = $ulf->getArrayByListFactory( $ulf, FALSE, TRUE );

		$filter_data['src_include_user_options'] = Misc::arrayDiffByKey( (array)$filter_data['include_user_ids'], $user_options );
		$filter_data['selected_include_user_options'] = Misc::arrayIntersectByKey( (array)$filter_data['include_user_ids'], $user_options );

		//Get exclude employee list
		$exclude_user_options = Misc::prependArray( $all_array_option, $ulf->getArrayByListFactory( $ulf, FALSE, TRUE ) );
		$filter_data['src_exclude_user_options'] = Misc::arrayDiffByKey( (array)$filter_data['exclude_user_ids'], $user_options );
		$filter_data['selected_exclude_user_options'] = Misc::arrayIntersectByKey( (array)$filter_data['exclude_user_ids'], $user_options );

		//Get employee status list.
		$user_status_options = Misc::prependArray( $all_array_option, $ulf->getOptions('status') );
		$filter_data['src_user_status_options'] = Misc::arrayDiffByKey( (array)$filter_data['user_status_ids'], $user_status_options );
		$filter_data['selected_user_status_options'] = Misc::arrayIntersectByKey( (array)$filter_data['user_status_ids'], $user_status_options );

		//Get Employee Groups
		$uglf = new UserGroupListFactory();
		$group_options = Misc::prependArray( $all_array_option, $uglf->getArrayByNodes( FastTree::FormatArray( $uglf->getByCompanyIdArray( $current_company->getId() ), 'TEXT', TRUE) ) );
		$filter_data['src_group_options'] = Misc::arrayDiffByKey( (array)$filter_data['group_ids'], $group_options );
		$filter_data['selected_group_options'] = Misc::arrayIntersectByKey( (array)$filter_data['group_ids'], $group_options );

		//Get branches
		$blf = new BranchListFactory();
		$blf->getByCompanyId( $current_company->getId() );
		$branch_options = Misc::prependArray( $all_array_option, $blf->getArrayByListFactory( $blf, FALSE, TRUE ) );
		$filter_data['src_branch_options'] = Misc::arrayDiffByKey( (array)$filter_data['branch_ids'], $branch_options );
		$filter_data['selected_branch_options'] = Misc::arrayIntersectByKey( (array)$filter_data['branch_ids'], $branch_options );

		//Get departments
		$dlf = new DepartmentListFactory();
		$dlf->getByCompanyId( $current_company->getId() );
		$department_options = Misc::prependArray( $all_array_option, $dlf->getArrayByListFactory( $dlf, FALSE, TRUE ) );
		$filter_data['src_department_options'] = Misc::arrayDiffByKey( (array)$filter_data['department_ids'], $department_options );
		$filter_data['selected_department_options'] = Misc::arrayIntersectByKey( (array)$filter_data['department_ids'], $department_options );

		//Get employee titles
		$utlf = new UserTitleListFactory();
		$utlf->getByCompanyId( $current_company->getId() );
		$user_title_options = Misc::prependArray( $all_array_option, $utlf->getArrayByListFactory( $utlf, FALSE, TRUE ) );
		$filter_data['src_user_title_options'] = Misc::arrayDiffByKey( (array)$filter_data['user_title_ids'], $user_title_options );
		$filter_data['selected_user_title_options'] = Misc::arrayIntersectByKey( (array)$filter_data['user_title_ids'], $user_title_options );

		//Deduction PSEA accounts
		$psealf = new PayStubEntryAccountListFactory();
		$filter_data['deduction_pay_stub_entry_account_options'] = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(20,30), TRUE );
		$filter_data['earning_pay_stub_entry_account_options'] = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(10,40), TRUE );
		$filter_data['income_pay_stub_entry_account_options'] = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(10,30,40), TRUE );

		//Get employee list
		//$filter_data['user_options'] = UserListFactory::getByCompanyIdArray( $current_company->getId(), FALSE );

		//Quarters
		$filter_data['quarter_options'] = $quarter_options;
		$filter_data['year_options'] = $year_options;
		$filter_data['deposit_schedule_options'] = array( 10 => TTi18n::gettext('Monthly'), 20 => TTi18n::gettext('Semi-Weekly') );

		$saved_report_options = $ugdlf->getByUserIdAndScriptArray( $current_user->getId(), $_SERVER['SCRIPT_NAME']);
		$generic_data['saved_report_options'] = $saved_report_options;
		$smarty->assign_by_ref('generic_data', $generic_data);

		$smarty->assign_by_ref('filter_data', $filter_data);
		$smarty->assign_by_ref('setup_data', $setup_data);

		$smarty->assign_by_ref('ugdf', $ugdf);

		$smarty->display('report/Form941.tpl');

		break;
}
?>