<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditHoliday.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity( 11 );

if ( !$permission->Check('holiday_policy','enabled')
		OR !( $permission->Check('holiday_policy','edit') OR $permission->Check('holiday_policy','edit_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Holiday')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'holiday_policy_id',
												'id',
												'data'
												) ) );

if ( isset($data['date_stamp'] ) ) {
	$data['date_stamp'] = TTDate::parseDateTime($data['date_stamp']);
}

$hf = new HolidayFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$hf->setId( $data['id'] );
		if ( isset($data['holiday_policy_id'] ) ) {
			$hf->setHolidayPolicyId( $data['holiday_policy_id'] );
		}
		//Set datestamp first.
		$hf->setDateStamp( $data['date_stamp'] );
		$hf->setName( $data['name'] );


		if ( $hf->isValid() ) {
			$hf->Save();

			Redirect::Page( URLBuilder::getURL( array('id' => $data['holiday_policy_id']), 'HolidayList.php') );

			break;
		}

	default:
		if ( isset($id) AND $id != '' ) {
			BreadCrumb::setCrumb($title);

			$hlf = new HolidayListFactory();
			$hlf->getById($id);

			foreach ($hlf as $h_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $h_obj->getId(),
									'holiday_policy_id' => $h_obj->getHolidayPolicyID(),
									'date_stamp' => $h_obj->getDateStamp(),
									'name' => $h_obj->getName(),
									'created_date' => $h_obj->getCreatedDate(),
									'created_by' => $h_obj->getCreatedBy(),
									'updated_date' => $h_obj->getUpdatedDate(),
									'updated_by' => $h_obj->getUpdatedBy(),
									'deleted_date' => $h_obj->getDeletedDate(),
									'deleted_by' => $h_obj->getDeletedBy()
								);
			}
			$holiday_policy_id = $h_obj->getHolidayPolicyID();
		} elseif ( $action != 'submit' ) {
			$data = array(
						'date_stamp' => TTDate::getTime(),
						'holiday_policy_id' => $holiday_policy_id
						);
		}

		$smarty->assign_by_ref('holiday_policy_id', $holiday_policy_id);
/*
		$aplf = new AccrualPolicyListFactory();
		$accrual_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$psenlf = new PayStubEntryNameListFactory();
		$pay_stub_entry_options = $psenlf->getByTypeIdArray(10);

		//Select box options;
		$data['type_options'] = $apf->getOptions('type');
		$data['accrual_options'] = $accrual_options;
		$data['pay_stub_entry_options'] = $pay_stub_entry_options;
*/
		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('hf', $hf);

$smarty->display('policy/EditHoliday.tpl');
?>