<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditDepartmentBranchUser.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('department','enabled')
		OR !( $permission->Check('department','assign') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Department Employees')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'department_data'

												) ) );

$dbuf = new DepartmentBranchUserFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		Debug::Text('Department ID: '. $department_data['id'] , __FILE__, __LINE__, __METHOD__,10);


		$dbulf = new DepartmentBranchUserListFactory();

		//Delete all mappings first?
		$dblf = new DepartmentBranchListFactory();
		$dblf->getByDepartmentId( $department_data['id'] );

		foreach ($dblf as $department_branch) {
			$dbulf->getByDepartmentBranchId( $department_branch->getId() );

			foreach($dbulf as $department_branch_user) {
				Debug::Text('Deleting Department Branch Mapping: '. $department_branch_user->getId() , __FILE__, __LINE__, __METHOD__,10);
				$department_branch_user->Delete();
			}
		}

		$dbulf = new DepartmentBranchUserListFactory();

		if ( isset($department_data['branch_data']) AND is_array($department_data['branch_data']) ) {
			foreach($department_data['branch_data'] as $branch_id => $user_ids) {
				Debug::Text('BranchID: '. $branch_id , __FILE__, __LINE__, __METHOD__,10);
				Debug::Arr($user_ids, 'Branch User IDs: ', __FILE__, __LINE__, __METHOD__,10);

				//Get DepartmentBranchId
				$dblf->getByDepartmentIdAndBranchId($department_data['id'],$branch_id);
				$department_branch_id = $dblf->getIterator()->current()->getId();

				Debug::Text('DepartmentBranchID: '. $department_branch_id, __FILE__, __LINE__, __METHOD__,10);

				foreach ($user_ids as $user_id) {
					Debug::Text('Mapping User: '. $user_id .' To DepartmentBranchID: '. $department_branch_id, __FILE__, __LINE__, __METHOD__,10);
					$dbuf->setDepartmentBranch($department_branch_id);
					$dbuf->setUser($user_id);
					if ( $dbuf->isValid() ) {
						$dbuf->Save();
					}

				}
			}
		}

		if ( $dbuf->isValid() ) {

			Redirect::Page( URLBuilder::getURL(NULL, 'DepartmentList.php') );

			break;
		}

	default:
		BreadCrumb::setCrumb($title);

		$dlf = new DepartmentListFactory();

		$dlf->GetByIdAndCompanyId($id, $current_company->getId() );

		foreach ($dlf as $department) {
			//Debug::Arr($department,'Department', __FILE__, __LINE__, __METHOD__,10);

			$branch_data = array();

			$dblf = new DepartmentBranchListFactory();
			$dblf->getByDepartmentId( $department->getId() );
			foreach($dblf as $department_branch) {
				$branch_id = $department_branch->getBranch();
				Debug::Text('DepartmentBranchId: '. $branch_id , __FILE__, __LINE__, __METHOD__,10);

				if ( isset($id) ) {
					//Get User ID's from database.
					$dbulf = new DepartmentBranchUserListFactory();
					$dbulf->getByDepartmentBranchId( $department_branch->getId() );

					$department_branch_user_ids = array();
					foreach($dbulf as $department_branch_user) {
						$department_branch_user_ids[] = $department_branch_user->getUser();
						Debug::Text('DepartmentBranchUser: '. $department_branch_user->getUser(), __FILE__, __LINE__, __METHOD__,10);
					}
				} else {
					//Use selected User Id's.
					$department_branch_user_ids = $department_data['branch_data'][$branch_id];
				}

				$blf = new BranchListFactory();
				$blf->getById( $branch_id );
				$branch = $blf->getIterator()->current();
				$branch_data[$branch_id] = array(
														'id' => $branch->getId(),
														'name' => $branch->getName(),
														'user_ids' => $department_branch_user_ids
													);
			}

			$department_data = array(
								'id' => $department->getId(),
								'company_name' => $current_company->getName(),
								'status' => $department->getStatus(),
								'name' => $department->getName(),
								'branch_list' => $department->getBranch(),
								'branch_data' => $branch_data,
								'created_date' => $department->getCreatedDate(),
								'created_by' => $department->getCreatedBy(),
								'updated_date' => $department->getUpdatedDate(),
								'updated_by' => $department->getUpdatedBy(),
								'deleted_date' => $department->getDeletedDate(),
								'deleted_by' => $department->getDeletedBy()
							);
		}


		//Select box options;
		$department_data['branch_list_options'] = BranchListFactory::getByCompanyIdArray($current_company->getId());

		//$ulf = new UserListFactory;
		$department_data['user_options'] = UserListFactory::getByCompanyIdArray( $current_company->getId(), FALSE );
		//var_dump($te);

		$smarty->assign_by_ref('department_data', $department_data);

		break;
}

$smarty->assign_by_ref('dbuf', $dbuf);

$smarty->display('department/EditDepartmentBranchUser.tpl');
?>