<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: UT.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_US_UT extends PayrollDeduction_US {

	var $state_options = array(
								1199174400 => array(
													'allowance' => 125 //Completely new formula after this date.
													),
								1167638400 => array(
													'allowance' => 2040
													),
								1136102400 => array(
													'allowance' => 1800
													)
								);

	function getStatePayPeriodDeductions() {
		return bcdiv($this->getStateTaxPayable(), $this->getAnnualPayPeriods() );
	}

	function getStateAnnualTaxableIncome() {
		if ( $this->getDate() >= strtotime('01-Jan-2008') ) {
			$income = $this->getAnnualTaxableIncome();
		} else {
			$annual_income = $this->getAnnualTaxableIncome();
			$state_allowance = $this->getStateAllowanceAmount();

			$income = bcsub( $annual_income, $state_allowance );
		}

		Debug::text('State Annual Taxable Income: '. $income, __FILE__, __LINE__, __METHOD__,10);

		return $income;
	}

	function getStateAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		if ( $this->getDate() >= strtotime('01-Jan-2008') ) {
			$rate_arr = $this->getRateArray( $this->getAnnualTaxableIncome(), 'state' );
			if ( is_array($rate_arr) AND isset($rate_arr['first']) AND isset($rate_arr['last']) ) {
				if ( $rate_arr['first'] == TRUE OR $rate_arr['last'] == TRUE ) {
					Debug::text('State First or Last bracket, ignoring allowance!', __FILE__, __LINE__, __METHOD__,10);
					$retval = 0;
				} else {
					Debug::text('State NOT First or Last bracket, using allowance!', __FILE__, __LINE__, __METHOD__,10);
					$allowance_arr = $retarr['allowance'];
					$retval = bcmul( $this->getStateAllowance(), $allowance_arr );
				}
			}
		} else {
			$allowance_arr = $retarr['allowance'];
			$retval = bcmul( $this->getStateAllowance(), $allowance_arr );
		}

		Debug::text('State Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStateTaxPayable() {
		$annual_income = $this->getStateAnnualTaxableIncome();

		$retval = 0;
		if ( $annual_income > 0 ) {
			if ( $this->getDate() >= strtotime('01-Jan-2008') ) {
				$rate = $this->getData()->getStateRate($annual_income);
				$state_allowance = $this->getStateAllowanceAmount();

				$retval = bcsub( bcmul( $annual_income, $rate ), $state_allowance );
			} else {
				$rate = $this->getData()->getStateRate($annual_income);
				$state_constant = $this->getData()->getStateConstant($annual_income);
				$state_rate_income = $this->getData()->getStateRatePreviousIncome($annual_income);

				$retval = bcadd( bcmul( bcsub( $annual_income, $state_rate_income ), $rate ), $state_constant );
			}
		}

		if ( $retval < 0 ) {
			$retval = 0;
		}

		Debug::text('State Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}
}
?>
