<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: InstallSchema_1001B.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */

/**
 * @package Module_Install
 */
class InstallSchema_1026A extends InstallSchema_Base {

	function preInstall() {
		Debug::text('preInstall: '. $this->getVersion() , __FILE__, __LINE__, __METHOD__,9);

		return TRUE;
	}


	function postInstall() {
		Debug::text('postInstall: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);

		//Copy iButton,Fingerprint,EmployeeNumber (barcode/proximity) fields to new UserIdentification table.

		//Find out if they have both TimeClocks and FingerPrint stations. If they do
		//we need to copy the fingerprint data to both types of UserIdentification rows.
		$clf = new CompanyListFactory();
		$clf->getAll();

		$clf->StartTransaction();
		foreach ( $clf as $c_obj ) {
			Debug::text('Company: '. $c_obj->getName(), __FILE__, __LINE__, __METHOD__,9);

			$max_templates = 4;

			$slf = new StationListFactory();
			$slf->getByCompanyIdAndTypeId( $c_obj->getId(), array(30,40,50,100,110) );
			if ( $slf->getRecordCount() > 0 ) {
				$slf_tmp1 = $slf->getByCompanyIdAndTypeId( $c_obj->getId(), array(50) );
				$griaule_stations = $slf_tmp1->getRecordCount();
				Debug::text('  Found Griaule Stations: '. $griaule_stations, __FILE__, __LINE__, __METHOD__,9);
				unset($slf_tmp1);

				$slf_tmp2 = $slf->getByCompanyIdAndTypeId( $c_obj->getId(), array(100,110) );
				$zk_stations = $slf_tmp2->getRecordCount();
				Debug::text('  Found ZK Stations: '. $zk_stations, __FILE__, __LINE__, __METHOD__,9);
				unset($slf_tmp2);

				$slf_tmp3 = $slf->getByCompanyIdAndTypeId( $c_obj->getId(), array(40) );
				$barcode_stations = $slf_tmp3->getRecordCount();
				Debug::text('  Found Barcode Stations: '. $barcode_stations, __FILE__, __LINE__, __METHOD__,9);
				unset($slf_tmp3);

				//Loop through each user copying their data to the UserIdenfification Table.
				$ulf = new UserListFactory();
				$ulf->getByCompanyID( $c_obj->getId() );
				if ( $ulf->getRecordCount() > 0 ) {
					foreach( $ulf as $u_obj ) {
						Debug::text('  User: '. $u_obj->getUserName(), __FILE__, __LINE__, __METHOD__,9);
						if ( $u_obj->getIButtonID() != '' ) {
							Debug::text('    Converting iButton...', __FILE__, __LINE__, __METHOD__,9);
							$uif = new UserIdentificationFactory();
							$uif->setUser( $u_obj->getId() );
							$uif->setType( 10 ); //10=iButton
							$uif->setNumber( 0 );
							$uif->setValue( $u_obj->getIButtonID() );
							if ( $uif->isValid() == TRUE ) {
								$uif->Save();
								$u_obj->getIButtonID( '' );
							}
						}

						if ( $u_obj->getRFID() != '' ) {
							Debug::text('    Converting RFID...', __FILE__, __LINE__, __METHOD__,9);
							$uif = new UserIdentificationFactory();
							$uif->setUser( $u_obj->getId() );
							$uif->setType( 40 ); //40=Proximity
							$uif->setNumber( 0 );
							$uif->setValue( $u_obj->getRFID() );
							if ( $uif->isValid() == TRUE ) {
								$uif->Save();
								$u_obj->getRFID( '' );
							}
						}

						if ( $barcode_stations > 0 AND $u_obj->getEmployeeNumber() != '' ) {
							Debug::text('    Converting EmployeeNumber...', __FILE__, __LINE__, __METHOD__,9);
							$uif = new UserIdentificationFactory();
							$uif->setUser( $u_obj->getId() );
							$uif->setType( 30 ); //30=Barcode
							$uif->setNumber( 0 );
							$uif->setValue( $u_obj->getEmployeeNumber() );
							if ( $uif->isValid() == TRUE ) {
								$uif->Save();
							}
						}

						if ( $griaule_stations > 0 ) {
							for ($t=1; $t <= $max_templates; $t++ ) {
								$set_fingerprint_function = 'setFingerPrint'. $t;
								$get_fingerprint_function = 'getFingerPrint'. $t;

								//Griaule fingerprint templates start with: "p/8B"
								if ( $u_obj->$get_fingerprint_function() != ''
										AND substr($u_obj->$get_fingerprint_function(), 0, 4) == 'p/8B' ) {
									Debug::text('    Converting Griaule FingerPrint: '. $t, __FILE__, __LINE__, __METHOD__,9);

									$uif = new UserIdentificationFactory();
									$uif->setUser( $u_obj->getId() );
									$uif->setType( 20 ); //20=Griaule, 100=ZK
									$uif->setNumber( ($t*10) );
									$uif->setValue( $u_obj->$get_fingerprint_function() );
									if ( $uif->isValid() == TRUE ) {
										$uif->Save();
										$u_obj->$set_fingerprint_function( '' );
									}
								}
							}
						}

						if ( $zk_stations > 0 ) {
							for ($t=1; $t <= $max_templates; $t++ ) {
								$set_fingerprint_function = 'setFingerPrint'. $t;
								$get_fingerprint_function = 'getFingerPrint'. $t;

								//ZK fingerprint templates start with: "oco"
								if ( $u_obj->$get_fingerprint_function() != ''
										AND substr($u_obj->$get_fingerprint_function(), 0, 3) == 'oco' ) {
									Debug::text('    Converting ZK FingerPrint: '. $t, __FILE__, __LINE__, __METHOD__,9);
									$uif = new UserIdentificationFactory();
									$uif->setUser( $u_obj->getId() );
									$uif->setType( 100 ); //20=Griaule, 100=ZK
									$uif->setNumber( $t );
									$uif->setValue( $u_obj->$get_fingerprint_function() );
									if ( $uif->isValid() == TRUE ) {
										$uif->Save();
										$u_obj->$set_fingerprint_function( '' );
									}
								}
							}
						}

						if ( $u_obj->isValid() ) {
							$u_obj->Save();
						}
					}
				}
			}
		}
		$clf->CommitTransaction();


		return TRUE;

	}
}
?>
