/* **********************************************************
 * Copyright (C) 1998-2001 VMware, Inc.
 * All Rights Reserved
 * $Id: cpuid.h,v 1.1.1.1 2003/02/16 14:31:15 bad Exp $
 * **********************************************************/

/*
 * cpuid.h --
 *
 *    wrap CPUID instruction
 */

#ifndef CPUID_H
#define CPUID_H

#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

typedef enum {
   CPUID_OEM_AMD,
   CPUID_OEM_CYRIX,
   CPUID_OEM_INTEL,
   CPUID_OEM_OTHER
} CPUOem;

EXTERN void CPUID_Init(void);
EXTERN CPUOem CPUID_GetOEM(void);
EXTERN uint32 CPUID_GetFeatures(void);
EXTERN uint32 CPUID_GetVersion(void);
#endif

