/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: speaker_reg.h,v 1.2 2003/02/16 01:29:50 bad Exp $
 * **********************************************************/

/*
 * speaker_reg.h --
 *
 *      PC speaker register
 */

#ifndef _SPEAKER_REG_H_
#define _SPEAKER_REG_H_

#define SPEAKER_PORT			0x61

#define SPEAKER_RAM_PARITY_ERROR	0x80	// read/write
#define SPEAKER_IO_PARITY_ERROR		0x40	// read
#define SPEAKER_CLEAR_IRQ0_TIMER	0x40	// write
#define SPEAKER_TIMER2_OUT		0x20	// read
#define SPEAKER_REFRESH_CLOCK_DIV2	0x10	// read
#define SPEAKER_ENABLE_IO_PARITY	0x08	// read/write
#define SPEAKER_ENABLE_RAM_PARITY	0x04	// read/write
#define SPEAKER_ENABLE_SPEAKER		0x02	// read/write
#define SPEAKER_TIMER2_GATE		0x01	// read/write

#define SPEAKER_READ_ONLY (SPEAKER_RAM_PARITY_ERROR | \
			   SPEAKER_IO_PARITY_ERROR | \
			   SPEAKER_TIMER2_OUT | \
			   SPEAKER_REFRESH_CLOCK_DIV2)

#endif	// _SPEAKER_REG_H_
