/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsDevice;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.lwawt.macosx.CPlatformView;

public class CGLGraphicsConfig
extends CGraphicsConfig
implements OGLGraphicsConfig {
    private static final int kOpenGLSwapInterval = 0;
    protected static boolean cglAvailable;
    private static ImageCapabilities imageCaps;
    private int pixfmt;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;
    private Object disposerReferent = new Object();

    public static native int getDefaultPixFmt(int var0);

    private static native boolean initCGL();

    private static native long getCGLConfigInfo(int var0, int var1, int var2);

    private static native int getOGLCapabilities(long var0);

    protected CGLGraphicsConfig(CGraphicsDevice cGraphicsDevice, int n, long l, ContextCapabilities contextCapabilities) {
        super(cGraphicsDevice);
        this.pixfmt = n;
        this.pConfigInfo = l;
        this.oglCaps = contextCapabilities;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
        Disposer.addRecord(this.disposerReferent, new CGLGCDisposerRecord(this.pConfigInfo));
    }

    @Override
    public Object getProxyKey() {
        return this;
    }

    @Override
    public SurfaceData createManagedSurface(int n, int n2, int n3) {
        return CGLSurfaceData.createData(this, n, n2, this.getColorModel(n3), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGLGraphicsConfig getConfig(CGraphicsDevice cGraphicsDevice, int n) {
        if (!cglAvailable) {
            return null;
        }
        long l = 0L;
        final String[] stringArray = new String[1];
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
            l = CGLGraphicsConfig.getCGLConfigInfo(cGraphicsDevice.getCoreGraphicsScreen(), n, 0);
            OGLContext.setScratchSurface(l);
            oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                @Override
                public void run() {
                    stringArray[0] = OGLContext.getOGLIdString();
                }
            });
        }
        finally {
            oGLRenderQueue.unlock();
        }
        if (l == 0L) {
            return null;
        }
        int n2 = CGLGraphicsConfig.getOGLCapabilities(l);
        OGLContext.OGLContextCaps oGLContextCaps = new OGLContext.OGLContextCaps(n2, stringArray[0]);
        return new CGLGraphicsConfig(cGraphicsDevice, n, l, oGLContextCaps);
    }

    public static boolean isCGLAvailable() {
        return cglAvailable;
    }

    @Override
    public final boolean isCapPresent(int n) {
        return (this.oglCaps.getCaps() & n) != 0;
    }

    @Override
    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    @Override
    public final OGLContext getContext() {
        return this.context;
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2) {
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        return new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public boolean isDoubleBuffered() {
        return this.isCapPresent(65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayChanged() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    public String toString() {
        int n = this.getDevice().getCoreGraphicsScreen();
        return "CGLGraphicsConfig[dev=" + n + ",pixfmt=" + this.pixfmt + "]";
    }

    @Override
    public SurfaceData createSurfaceData(CPlatformView cPlatformView) {
        return CGLSurfaceData.createData(cPlatformView);
    }

    @Override
    public SurfaceData createSurfaceData(CGLLayer cGLLayer) {
        return CGLSurfaceData.createData(cGLLayer);
    }

    @Override
    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    @Override
    public long createBackBuffer(CPlatformView cPlatformView, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
        return 1L;
    }

    @Override
    public void destroyBackBuffer(long l) {
    }

    @Override
    public VolatileImage createBackBufferImage(Component component, long l) {
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flip(CPlatformView cPlatformView, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        Object object;
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            object = SurfaceManager.getManager(volatileImage);
            SurfaceData surfaceData = ((SurfaceManager)object).getPrimarySurfaceData();
            if (!(surfaceData instanceof CGLSurfaceData.CGLVSyncOffScreenSurfaceData)) {
                cPlatformView.drawImageOnPeer(volatileImage, n, n2, n3, n4);
                return;
            }
            CGLSurfaceData.CGLVSyncOffScreenSurfaceData cGLVSyncOffScreenSurfaceData = (CGLSurfaceData.CGLVSyncOffScreenSurfaceData)surfaceData;
            SurfaceData surfaceData2 = cGLVSyncOffScreenSurfaceData.getFlipSurface();
            SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData2, Color.black, Color.white, null);
            try {
                ((Graphics)sunGraphics2D).drawImage(volatileImage, 0, 0, null);
            }
            finally {
                ((Graphics)sunGraphics2D).dispose();
            }
        } else if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(cPlatformView.getAWTView());
        if (flipContents != BufferCapabilities.FlipContents.BACKGROUND) return;
        object = volatileImage.getGraphics();
        try {
            ((Graphics)object).setColor(component.getBackground());
            ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            return;
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new CGLBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3, int n4) {
        AccelTypedVolatileImage accelTypedVolatileImage;
        Surface surface;
        if (n4 == 4 || n4 == 1 || n4 == 0 || n3 == 2) {
            return null;
        }
        if (n4 == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (n4 == 2) {
            boolean bl;
            boolean bl2 = bl = n3 == 1;
            if (!bl && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((surface = (accelTypedVolatileImage = new AccelTypedVolatileImage((GraphicsConfiguration)this, n, n2, n3, n4)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)surface).getType() != n4) {
            accelTypedVolatileImage.flush();
            accelTypedVolatileImage = null;
        }
        return accelTypedVolatileImage;
    }

    @Override
    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    @Override
    public void addDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        int n = this.getDevice().getCoreGraphicsScreen();
        AccelDeviceEventNotifier.addListener(accelDeviceEventListener, n);
    }

    @Override
    public void removeDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.removeListener(accelDeviceEventListener);
    }

    static {
        imageCaps = new CGLImageCaps();
        cglAvailable = CGLGraphicsConfig.initCGL();
    }

    private static class CGLImageCaps
    extends ImageCapabilities {
        private CGLImageCaps() {
            super(true);
        }

        @Override
        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class CGLBufferCaps
    extends BufferCapabilities {
        public CGLBufferCaps(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class CGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;

        public CGLGCDisposerRecord(long l) {
            this.pCfgInfo = l;
        }

        @Override
        public void dispose() {
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }
}

