/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Hashing;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MIN_SEGMENT_TABLE_CAPACITY = 2;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    private final transient int hashSeed = ConcurrentHashMap.randomHashSeed(this);
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    private static final Unsafe UNSAFE;
    private static final long SBASE;
    private static final int SSHIFT;
    private static final long TBASE;
    private static final int TSHIFT;
    private static final long HASHSEED_OFFSET;

    private static int randomHashSeed(ConcurrentHashMap concurrentHashMap) {
        if (VM.isBooted() && Holder.ALTERNATIVE_HASHING) {
            return Hashing.randomHashSeed(concurrentHashMap);
        }
        return 0;
    }

    static final <K, V> HashEntry<K, V> entryAt(HashEntry<K, V>[] hashEntryArray, int n) {
        return hashEntryArray == null ? null : (HashEntry)UNSAFE.getObjectVolatile(hashEntryArray, ((long)n << TSHIFT) + TBASE);
    }

    static final <K, V> void setEntryAt(HashEntry<K, V>[] hashEntryArray, int n, HashEntry<K, V> hashEntry) {
        UNSAFE.putOrderedObject(hashEntryArray, ((long)n << TSHIFT) + TBASE, hashEntry);
    }

    private int hash(Object object) {
        int n = this.hashSeed;
        if (0 != n && object instanceof String) {
            return Hashing.stringHash32((String)object);
        }
        n ^= object.hashCode();
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    static final <K, V> Segment<K, V> segmentAt(Segment<K, V>[] segmentArray, int n) {
        long l = (long)(n << SSHIFT) + SBASE;
        return segmentArray == null ? null : (Segment)UNSAFE.getObjectVolatile(segmentArray, l);
    }

    private Segment<K, V> ensureSegment(int n) {
        Segment segment;
        block2: {
            Segment<K, V>[] segmentArray = this.segments;
            long l = (long)(n << SSHIFT) + SBASE;
            segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l);
            if (segment != null) break block2;
            Segment<K, V> segment2 = segmentArray[0];
            int n2 = segment2.table.length;
            float f = segment2.loadFactor;
            int n3 = (int)((float)n2 * f);
            HashEntry[] hashEntryArray = new HashEntry[n2];
            segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l);
            if (segment == null) {
                Segment segment3 = new Segment(f, n3, hashEntryArray);
                while ((segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l)) == null && !UNSAFE.compareAndSwapObject(segmentArray, l, null, segment = segment3)) {
                }
            }
        }
        return segment;
    }

    private Segment<K, V> segmentForHash(int n) {
        long l = (long)((n >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        return (Segment)UNSAFE.getObjectVolatile(this.segments, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final <K, V> HashEntry<K, V> entryForHash(Segment<K, V> segment, int n) {
        if (segment == null) return null;
        HashEntry<K, V>[] hashEntryArray = segment.table;
        if (segment.table == null) {
            return null;
        }
        HashEntry hashEntry = (HashEntry)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n) << TSHIFT) + TBASE);
        return hashEntry;
    }

    public ConcurrentHashMap(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 2; n3 < n4; n3 <<= 1) {
        }
        Segment segment = new Segment(f, (int)((float)n3 * f), new HashEntry[n3]);
        Segment[] segmentArray = new Segment[n5];
        UNSAFE.putOrderedObject(segmentArray, SBASE, segment);
        this.segments = segmentArray;
    }

    public ConcurrentHashMap(int n, float f) {
        this(n, f, 16);
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        Segment<K, V> segment;
        int n;
        long l = 0L;
        Segment<K, V>[] segmentArray = this.segments;
        for (n = 0; n < segmentArray.length; ++n) {
            segment = ConcurrentHashMap.segmentAt(segmentArray, n);
            if (segment == null) continue;
            if (segment.count != 0) {
                return false;
            }
            l += (long)segment.modCount;
        }
        if (l != 0L) {
            for (n = 0; n < segmentArray.length; ++n) {
                segment = ConcurrentHashMap.segmentAt(segmentArray, n);
                if (segment == null) continue;
                if (segment.count != 0) {
                    return false;
                }
                l -= (long)segment.modCount;
            }
            if (l != 0L) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        boolean bl;
        int n;
        int n2;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        int n3 = -1;
        try {
            while (true) {
                if (n3++ == 2) {
                    for (n2 = 0; n2 < segmentArray.length; ++n2) {
                        this.ensureSegment(n2).lock();
                    }
                }
                long l2 = 0L;
                n = 0;
                bl = false;
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, n2);
                    if (segment == null) continue;
                    l2 += (long)segment.modCount;
                    int n4 = segment.count;
                    if (n4 >= 0 && (n += n4) >= 0) continue;
                    bl = true;
                }
                if (l2 == l) {
                    break;
                }
                l = l2;
            }
        }
        finally {
            if (n3 > 2) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    ConcurrentHashMap.segmentAt(segmentArray, n2).unlock();
                }
            }
        }
        return bl ? Integer.MAX_VALUE : n;
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object);
        long l = (long)((n >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        Segment segment = (Segment)UNSAFE.getObjectVolatile(this.segments, l);
        if (segment != null) {
            HashEntry<K, V>[] hashEntryArray = segment.table;
            if (segment.table != null) {
                HashEntry hashEntry = (HashEntry)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n) << TSHIFT) + TBASE);
                while (hashEntry != null) {
                    Object k = hashEntry.key;
                    if (k == object || hashEntry.hash == n && object.equals(k)) {
                        return hashEntry.value;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hash(object);
        long l = (long)((n >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        Segment segment = (Segment)UNSAFE.getObjectVolatile(this.segments, l);
        if (segment != null) {
            HashEntry<K, V>[] hashEntryArray = segment.table;
            if (segment.table != null) {
                HashEntry hashEntry = (HashEntry)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n) << TSHIFT) + TBASE);
                while (hashEntry != null) {
                    Object k = hashEntry.key;
                    if (k == object || hashEntry.hash == n && object.equals(k)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        boolean bl;
        block14: {
            if (object == null) {
                throw new NullPointerException();
            }
            Segment<K, V>[] segmentArray = this.segments;
            bl = false;
            long l = 0L;
            int n = -1;
            try {
                while (true) {
                    if (n++ == 2) {
                        for (int i = 0; i < segmentArray.length; ++i) {
                            this.ensureSegment(i).lock();
                        }
                    }
                    long l2 = 0L;
                    int n2 = 0;
                    for (int i = 0; i < segmentArray.length; ++i) {
                        Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
                        if (segment == null) continue;
                        HashEntry<K, V>[] hashEntryArray = segment.table;
                        if (segment.table == null) continue;
                        for (int j = 0; j < hashEntryArray.length; ++j) {
                            HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, j);
                            while (hashEntry != null) {
                                Object v = hashEntry.value;
                                if (v != null && object.equals(v)) {
                                    bl = true;
                                    break block14;
                                }
                                hashEntry = hashEntry.next;
                            }
                        }
                        n2 += segment.modCount;
                    }
                    if (n > 0 && (long)n2 == l) {
                        break;
                    }
                    l = n2;
                }
            }
            finally {
                if (n > 2) {
                    for (int i = 0; i < segmentArray.length; ++i) {
                        ConcurrentHashMap.segmentAt(segmentArray, i).unlock();
                    }
                }
            }
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hash(k);
        int n2 = n >>> this.segmentShift & this.segmentMask;
        Segment<K, V> segment = (Segment<K, V>)UNSAFE.getObject(this.segments, (long)(n2 << SSHIFT) + SBASE);
        if (segment == null) {
            segment = this.ensureSegment(n2);
        }
        return segment.put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hash(k);
        int n2 = n >>> this.segmentShift & this.segmentMask;
        Segment<K, V> segment = (Segment<K, V>)UNSAFE.getObject(this.segments, (long)(n2 << SSHIFT) + SBASE);
        if (segment == null) {
            segment = this.ensureSegment(n2);
        }
        return segment.put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object);
        Segment<K, V> segment = this.segmentForHash(n);
        return segment == null ? null : (V)segment.remove(object, n, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Segment<K, V> segment;
        int n = this.hash(object);
        return object2 != null && (segment = this.segmentForHash(n)) != null && segment.remove(object, n, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        int n = this.hash(k);
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        Segment<K, V> segment = this.segmentForHash(n);
        return segment != null && segment.replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        int n = this.hash(k);
        if (v == null) {
            throw new NullPointerException();
        }
        Segment<K, V> segment = this.segmentForHash(n);
        return segment == null ? null : (V)segment.replace(k, n, v);
    }

    @Override
    public void clear() {
        Segment<K, V>[] segmentArray = this.segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
            if (segment == null) continue;
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        for (int i = 0; i < this.segments.length; ++i) {
            this.ensureSegment(i);
        }
        objectOutputStream.defaultWriteObject();
        Segment<K, V>[] segmentArray = this.segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
            segment.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = segment.table;
                for (int j = 0; j < hashEntryArray.length; ++j) {
                    HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, j);
                    while (hashEntry != null) {
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
                continue;
            }
            finally {
                segment.unlock();
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Segment<K, V> segment;
        objectInputStream.defaultReadObject();
        UNSAFE.putIntVolatile(this, HASHSEED_OFFSET, ConcurrentHashMap.randomHashSeed(this));
        int n = 2;
        Segment<K, V>[] segmentArray = this.segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            segment = segmentArray[i];
            if (segment == null) continue;
            segment.threshold = (int)((float)n * segment.loadFactor);
            segment.table = new HashEntry[n];
        }
        while (true) {
            Object object = objectInputStream.readObject();
            segment = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, segment);
        }
    }

    static {
        int n;
        int n2;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<HashEntry[]> clazz = HashEntry[].class;
            Class<Segment[]> clazz2 = Segment[].class;
            TBASE = UNSAFE.arrayBaseOffset(clazz);
            SBASE = UNSAFE.arrayBaseOffset(clazz2);
            n2 = UNSAFE.arrayIndexScale(clazz);
            n = UNSAFE.arrayIndexScale(clazz2);
            HASHSEED_OFFSET = UNSAFE.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("hashSeed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0 || (n2 & n2 - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        SSHIFT = 31 - Integer.numberOfLeadingZeros(n);
        TSHIFT = 31 - Integer.numberOfLeadingZeros(n2);
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = ConcurrentHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key, hashEntry.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            ConcurrentHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return super.nextEntry().value;
        }

        @Override
        public final V nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return super.nextEntry().key;
        }

        @Override
        public final K nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            while (true) {
                Segment segment;
                if (this.nextTableIndex >= 0) {
                    if ((this.nextEntry = ConcurrentHashMap.entryAt(this.currentTable, this.nextTableIndex--)) == null) continue;
                    break;
                }
                if (this.nextSegmentIndex < 0) break;
                if ((segment = ConcurrentHashMap.segmentAt(ConcurrentHashMap.this.segments, this.nextSegmentIndex--)) == null) continue;
                this.currentTable = segment.table;
                if (segment.table == null) continue;
                this.nextTableIndex = this.currentTable.length - 1;
            }
        }

        final HashEntry<K, V> nextEntry() {
            HashEntry hashEntry = this.nextEntry;
            if (hashEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = hashEntry;
            this.nextEntry = hashEntry.next;
            if (this.nextEntry == null) {
                this.advance();
            }
            return hashEntry;
        }

        public final boolean hasNext() {
            return this.nextEntry != null;
        }

        public final boolean hasMoreElements() {
            return this.nextEntry != null;
        }

        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        static final int MAX_SCAN_RETRIES = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 1;
        volatile transient HashEntry<K, V>[] table;
        transient int count;
        transient int modCount;
        transient int threshold;
        final float loadFactor;

        Segment(float f, int n, HashEntry<K, V>[] hashEntryArray) {
            this.loadFactor = f;
            this.threshold = n;
            this.table = hashEntryArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V put(K k, int n, V v, boolean bl) {
            Object v2;
            block10: {
                HashEntry<K, V> hashEntry = this.tryLock() ? null : this.scanAndLockForPut(k, n, v);
                try {
                    HashEntry<K, V> hashEntry2;
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    int n2 = hashEntryArray.length - 1 & n;
                    HashEntry<K, V> hashEntry3 = hashEntry2 = ConcurrentHashMap.entryAt(hashEntryArray, n2);
                    while (hashEntry3 != null) {
                        Object k2 = hashEntry3.key;
                        if (k2 == k || hashEntry3.hash == n && k.equals(k2)) {
                            v2 = hashEntry3.value;
                            if (!bl) {
                                hashEntry3.value = v;
                                ++this.modCount;
                            }
                            break block10;
                        }
                        hashEntry3 = hashEntry3.next;
                    }
                    if (hashEntry != null) {
                        hashEntry.setNext(hashEntry2);
                    } else {
                        hashEntry = new HashEntry<K, V>(n, k, v, hashEntry2);
                    }
                    int n3 = this.count + 1;
                    if (n3 > this.threshold && hashEntryArray.length < 0x40000000) {
                        this.rehash(hashEntry);
                    } else {
                        ConcurrentHashMap.setEntryAt(hashEntryArray, n2, hashEntry);
                    }
                    ++this.modCount;
                    this.count = n3;
                    v2 = null;
                }
                finally {
                    this.unlock();
                }
            }
            return v2;
        }

        private void rehash(HashEntry<K, V> hashEntry) {
            int n;
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n2 = hashEntryArray.length;
            int n3 = n2 << 1;
            this.threshold = (int)((float)n3 * this.loadFactor);
            HashEntry[] hashEntryArray2 = new HashEntry[n3];
            int n4 = n3 - 1;
            for (n = 0; n < n2; ++n) {
                HashEntry<K, V> hashEntry2 = hashEntryArray[n];
                if (hashEntry2 == null) continue;
                HashEntry hashEntry3 = hashEntry2.next;
                int n5 = hashEntry2.hash & n4;
                if (hashEntry3 == null) {
                    hashEntryArray2[n5] = hashEntry2;
                    continue;
                }
                HashEntry<K, V> hashEntry4 = hashEntry2;
                int n6 = n5;
                HashEntry hashEntry5 = hashEntry3;
                while (hashEntry5 != null) {
                    int n7 = hashEntry5.hash & n4;
                    if (n7 != n6) {
                        n6 = n7;
                        hashEntry4 = hashEntry5;
                    }
                    hashEntry5 = hashEntry5.next;
                }
                hashEntryArray2[n6] = hashEntry4;
                hashEntry5 = hashEntry2;
                while (hashEntry5 != hashEntry4) {
                    Object v = hashEntry5.value;
                    int n8 = hashEntry5.hash;
                    int n9 = n8 & n4;
                    HashEntry hashEntry6 = hashEntryArray2[n9];
                    hashEntryArray2[n9] = new HashEntry(n8, hashEntry5.key, v, hashEntry6);
                    hashEntry5 = hashEntry5.next;
                }
            }
            n = hashEntry.hash & n4;
            hashEntry.setNext(hashEntryArray2[n]);
            hashEntryArray2[n] = hashEntry;
            this.table = hashEntryArray2;
        }

        private HashEntry<K, V> scanAndLockForPut(K k, int n, V v) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntry = ConcurrentHashMap.entryForHash(this, n);
            HashEntry<K, V> hashEntry3 = null;
            int n2 = -1;
            while (!this.tryLock()) {
                HashEntry hashEntry4;
                if (n2 < 0) {
                    if (hashEntry2 == null) {
                        if (hashEntry3 == null) {
                            hashEntry3 = new HashEntry<K, V>(n, k, v, null);
                        }
                        n2 = 0;
                        continue;
                    }
                    if (k.equals(hashEntry2.key)) {
                        n2 = 0;
                        continue;
                    }
                    hashEntry2 = hashEntry2.next;
                    continue;
                }
                if (++n2 > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((n2 & 1) != 0 || (hashEntry4 = ConcurrentHashMap.entryForHash(this, n)) == hashEntry) continue;
                hashEntry2 = hashEntry = hashEntry4;
                n2 = -1;
            }
            return hashEntry3;
        }

        private void scanAndLock(Object object, int n) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntry = ConcurrentHashMap.entryForHash(this, n);
            int n2 = -1;
            while (!this.tryLock()) {
                HashEntry hashEntry3;
                if (n2 < 0) {
                    if (hashEntry2 == null || object.equals(hashEntry2.key)) {
                        n2 = 0;
                        continue;
                    }
                    hashEntry2 = hashEntry2.next;
                    continue;
                }
                if (++n2 > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((n2 & 1) != 0 || (hashEntry3 = ConcurrentHashMap.entryForHash(this, n)) == hashEntry) continue;
                hashEntry2 = hashEntry = hashEntry3;
                n2 = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V remove(Object object, int n, Object object2) {
            if (!this.tryLock()) {
                this.scanAndLock(object, n);
            }
            V v = null;
            try {
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n2 = hashEntryArray.length - 1 & n;
                HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, n2);
                HashEntry hashEntry2 = null;
                while (hashEntry != null) {
                    HashEntry hashEntry3 = hashEntry.next;
                    Object k = hashEntry.key;
                    if (k == object || hashEntry.hash == n && object.equals(k)) {
                        Object v2 = hashEntry.value;
                        if (object2 == null || object2 == v2 || object2.equals(v2)) {
                            if (hashEntry2 == null) {
                                ConcurrentHashMap.setEntryAt(hashEntryArray, n2, hashEntry3);
                            } else {
                                hashEntry2.setNext(hashEntry3);
                            }
                            ++this.modCount;
                            --this.count;
                            v = v2;
                        }
                        break;
                    }
                    hashEntry2 = hashEntry;
                    hashEntry = hashEntry3;
                }
            }
            finally {
                this.unlock();
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean replace(K k, int n, V v, V v2) {
            if (!this.tryLock()) {
                this.scanAndLock(k, n);
            }
            boolean bl = false;
            try {
                HashEntry hashEntry = ConcurrentHashMap.entryForHash(this, n);
                while (hashEntry != null) {
                    Object k2 = hashEntry.key;
                    if (k2 == k || hashEntry.hash == n && k.equals(k2)) {
                        if (v.equals(hashEntry.value)) {
                            hashEntry.value = v2;
                            ++this.modCount;
                            bl = true;
                        }
                        break;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            finally {
                this.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V replace(K k, int n, V v) {
            if (!this.tryLock()) {
                this.scanAndLock(k, n);
            }
            V v2 = null;
            try {
                HashEntry hashEntry = ConcurrentHashMap.entryForHash(this, n);
                while (hashEntry != null) {
                    Object k2 = hashEntry.key;
                    if (k2 == k || hashEntry.hash == n && k.equals(k2)) {
                        v2 = hashEntry.value;
                        hashEntry.value = v;
                        ++this.modCount;
                        break;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            finally {
                this.unlock();
            }
            return v2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clear() {
            this.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = this.table;
                for (int i = 0; i < hashEntryArray.length; ++i) {
                    ConcurrentHashMap.setEntryAt(hashEntryArray, i, null);
                }
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }

    static final class HashEntry<K, V> {
        final int hash;
        final K key;
        volatile V value;
        volatile HashEntry<K, V> next;
        static final Unsafe UNSAFE;
        static final long nextOffset;

        HashEntry(int n, K k, V v, HashEntry<K, V> hashEntry) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = hashEntry;
        }

        final void setNext(HashEntry<K, V> hashEntry) {
            UNSAFE.putOrderedObject(this, nextOffset, hashEntry);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<HashEntry> clazz = HashEntry.class;
                nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    private static class Holder {
        static final boolean ALTERNATIVE_HASHING;

        private Holder() {
        }

        static {
            int n;
            String string = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = null != string ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException);
            }
            ALTERNATIVE_HASHING = n <= 0x40000000;
        }
    }
}

