/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventFilter;
import java.awt.EventQueue;
import java.awt.ModalEventFilter;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.awt.EventQueueDelegate;
import sun.awt.ModalExclude;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.util.logging.PlatformLogger;

class EventDispatchThread
extends Thread {
    private static final PlatformLogger eventLog = PlatformLogger.getLogger("java.awt.event.EventDispatchThread");
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private volatile boolean shutdown = false;
    private static final int ANY_EVENT = -1;
    private ArrayList<EventFilter> eventFilters = new ArrayList();

    EventDispatchThread(ThreadGroup threadGroup, String string, EventQueue eventQueue) {
        super(threadGroup, string);
        this.setEventQueue(eventQueue);
    }

    public void stopDispatching() {
        this.doDispatch = false;
    }

    @Override
    public void interrupt() {
        this.shutdown = true;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                this.pumpEvents(new Conditional(){

                    @Override
                    public boolean evaluate() {
                        return true;
                    }
                });
                continue;
            }
            finally {
                if (this.getEventQueue().detachDispatchThread(this, this.shutdown)) break;
                continue;
            }
            break;
        }
    }

    private Conditional _macosxGetConditional(final Object object) {
        try {
            return new Conditional(){
                final Method evaluateMethod = Class.forName("sun.lwawt.macosx.EventDispatchAccess").getMethod("evaluate", null);

                @Override
                public boolean evaluate() {
                    try {
                        return (Boolean)this.evaluateMethod.invoke(object, null);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
        }
        catch (Exception exception) {
            return new Conditional(){

                @Override
                public boolean evaluate() {
                    return false;
                }
            };
        }
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEvents(-1, conditional);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.pumpEventsForHierarchy(-1, conditional, component);
    }

    void pumpEvents(int n, Conditional conditional) {
        this.pumpEventsForHierarchy(n, conditional, null);
    }

    void pumpEventsForHierarchy(int n, Conditional conditional, Component component) {
        this.pumpEventsForFilter(n, conditional, new HierarchyEventFilter(component));
    }

    void pumpEventsForFilter(Conditional conditional, EventFilter eventFilter) {
        this.pumpEventsForFilter(-1, conditional, eventFilter);
    }

    void pumpEventsForFilter(int n, Conditional conditional, EventFilter eventFilter) {
        this.addEventFilter(eventFilter);
        this.doDispatch = true;
        this.shutdown |= this.isInterrupted();
        while (this.doDispatch && !this.shutdown && conditional.evaluate()) {
            this.pumpOneEventForFilters(n);
        }
        this.removeEventFilter(eventFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEventFilter(EventFilter eventFilter) {
        eventLog.finest("adding the event filter: " + eventFilter);
        ArrayList<EventFilter> arrayList = this.eventFilters;
        synchronized (arrayList) {
            if (!this.eventFilters.contains(eventFilter)) {
                if (eventFilter instanceof ModalEventFilter) {
                    ModalEventFilter modalEventFilter;
                    EventFilter eventFilter2;
                    ModalEventFilter modalEventFilter2 = (ModalEventFilter)eventFilter;
                    int n = 0;
                    for (n = 0; !(n >= this.eventFilters.size() || (eventFilter2 = this.eventFilters.get(n)) instanceof ModalEventFilter && (modalEventFilter = (ModalEventFilter)eventFilter2).compareTo(modalEventFilter2) > 0); ++n) {
                    }
                    this.eventFilters.add(n, eventFilter);
                } else {
                    this.eventFilters.add(eventFilter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEventFilter(EventFilter eventFilter) {
        eventLog.finest("removing the event filter: " + eventFilter);
        ArrayList<EventFilter> arrayList = this.eventFilters;
        synchronized (arrayList) {
            this.eventFilters.remove(eventFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pumpOneEventForFilters(int n) {
        AWTEvent aWTEvent = null;
        boolean bl = false;
        try {
            Object object;
            EventQueue eventQueue = null;
            EventQueueDelegate.Delegate delegate = null;
            do {
                eventQueue = this.getEventQueue();
                delegate = EventQueueDelegate.getDelegate();
                aWTEvent = delegate != null && n == -1 ? delegate.getNextEvent(eventQueue) : (n == -1 ? eventQueue.getNextEvent() : eventQueue.getNextEvent(n));
                bl = true;
                object = this.eventFilters;
                synchronized (object) {
                    for (int i = this.eventFilters.size() - 1; i >= 0; --i) {
                        EventFilter eventFilter = this.eventFilters.get(i);
                        EventFilter.FilterAction filterAction = eventFilter.acceptEvent(aWTEvent);
                        if (filterAction == EventFilter.FilterAction.REJECT) {
                            bl = false;
                            break;
                        }
                        if (filterAction == EventFilter.FilterAction.ACCEPT_IMMEDIATELY) break;
                    }
                }
                boolean bl2 = bl = bl && SunDragSourceContextPeer.checkEvent(aWTEvent);
                if (bl) continue;
                aWTEvent.consume();
            } while (!bl);
            if (eventLog.isLoggable(300)) {
                eventLog.finest("Dispatching: " + aWTEvent);
            }
            object = null;
            if (delegate != null) {
                object = delegate.beforeDispatch(aWTEvent);
            }
            eventQueue.dispatchEvent(aWTEvent);
            if (delegate != null) {
                delegate.afterDispatch(aWTEvent, object);
            }
        }
        catch (ThreadDeath threadDeath) {
            this.shutdown = true;
            throw threadDeath;
        }
        catch (InterruptedException interruptedException) {
            this.shutdown = true;
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    private void processException(Throwable throwable) {
        if (eventLog.isLoggable(500)) {
            eventLog.fine("Processing exception: " + throwable);
        }
        this.getUncaughtExceptionHandler().uncaughtException(this, throwable);
    }

    public synchronized EventQueue getEventQueue() {
        return this.theQueue;
    }

    public synchronized void setEventQueue(EventQueue eventQueue) {
        this.theQueue = eventQueue;
    }

    private static class HierarchyEventFilter
    implements EventFilter {
        private Component modalComponent;

        public HierarchyEventFilter(Component component) {
            this.modalComponent = component;
        }

        @Override
        public EventFilter.FilterAction acceptEvent(AWTEvent aWTEvent) {
            if (this.modalComponent != null) {
                boolean bl;
                int n = aWTEvent.getID();
                boolean bl2 = n >= 500 && n <= 507;
                boolean bl3 = n >= 1001 && n <= 1001;
                boolean bl4 = bl = n == 201;
                if (Component.isInstanceOf(this.modalComponent, "javax.swing.JInternalFrame")) {
                    return bl ? EventFilter.FilterAction.REJECT : EventFilter.FilterAction.ACCEPT;
                }
                if (bl2 || bl3 || bl) {
                    Object object = aWTEvent.getSource();
                    if (object instanceof ModalExclude) {
                        return EventFilter.FilterAction.ACCEPT;
                    }
                    if (object instanceof Component) {
                        Component component;
                        boolean bl5 = false;
                        if (this.modalComponent instanceof Container) {
                            for (component = (Component)object; component != this.modalComponent && component != null; component = component.getParent()) {
                                if (!(component instanceof Window) || !SunToolkit.isModalExcluded((Window)component)) continue;
                                bl5 = true;
                                break;
                            }
                        }
                        if (!bl5 && component != this.modalComponent) {
                            return EventFilter.FilterAction.REJECT;
                        }
                    }
                }
            }
            return EventFilter.FilterAction.ACCEPT;
        }
    }
}

