/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.XWindow;

public class XKeyboardFocusManagerPeer
implements KeyboardFocusManagerPeer {
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XKeyboardFocusManagerPeer");
    KeyboardFocusManager manager;
    private static Object lock = new Object(){};
    private static Component currentFocusOwner;
    private static Window currentFocusedWindow;
    static Method shouldNativelyFocusHeavyweightMethod;

    XKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) {
        this.manager = keyboardFocusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusOwner(Component component) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focus owner " + component);
        }
        Object object = lock;
        synchronized (object) {
            currentFocusOwner = component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusedWindow(Window window) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focused window " + window);
        }
        Object object = lock;
        synchronized (object) {
            currentFocusedWindow = window;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Component getCurrentNativeFocusOwner() {
        Object object = lock;
        synchronized (object) {
            return currentFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Window getCurrentNativeFocusedWindow() {
        Object object = lock;
        synchronized (object) {
            return currentFocusedWindow;
        }
    }

    public Window getCurrentFocusedWindow() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
    }

    public void setCurrentFocusOwner(Component component) {
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(component);
    }

    public Component getCurrentFocusOwner() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner();
    }

    public void clearGlobalFocusOwner(Window window) {
        if (window != null) {
            Component component = window.getFocusOwner();
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Clearing global focus owner " + component);
            }
            if (component != null) {
                CausedFocusEvent causedFocusEvent = new CausedFocusEvent(component, 1005, false, null, CausedFocusEvent.Cause.CLEAR_GLOBAL_FOCUS_OWNER);
                XWindow.sendEvent(causedFocusEvent);
            }
        }
    }

    static boolean simulateMotifRequestFocus(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        Component component3;
        if (component == null) {
            component = component2;
        }
        if ((component3 = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && component3.getPeer() == null) {
            component3 = null;
        }
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Simulating transfer from " + component3 + " to " + component);
        }
        CausedFocusEvent causedFocusEvent = new CausedFocusEvent(component, 1004, false, component3, cause);
        CausedFocusEvent causedFocusEvent2 = null;
        if (component3 != null) {
            causedFocusEvent2 = new CausedFocusEvent(component3, 1005, false, component, cause);
        }
        if (causedFocusEvent2 != null) {
            XWindow.sendEvent(causedFocusEvent2);
        }
        XWindow.sendEvent(causedFocusEvent);
        return true;
    }

    static int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        int n;
        block6: {
            Object[] objectArray;
            if (shouldNativelyFocusHeavyweightMethod == null) {
                objectArray = new Class[]{Component.class, Component.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, CausedFocusEvent.Cause.class};
                shouldNativelyFocusHeavyweightMethod = SunToolkit.getMethod(KeyboardFocusManager.class, "shouldNativelyFocusHeavyweight", (Class[])objectArray);
            }
            objectArray = new Object[]{component, component2, bl, bl2, l, cause};
            n = 0;
            if (shouldNativelyFocusHeavyweightMethod != null) {
                try {
                    n = (Integer)shouldNativelyFocusHeavyweightMethod.invoke(null, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        return n;
    }
}

