/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignedInfo
extends DOMStructure
implements SignedInfo {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private List references;
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private String id;
    private Document ownerDoc;
    private Element localSiElem;
    private InputStream canonData;

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list) {
        if (canonicalizationMethod == null || signatureMethod == null || list == null) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
        this.references = Collections.unmodifiableList(new ArrayList(list));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.references.get(i);
            if (e instanceof Reference) continue;
            throw new ClassCastException("list of references contains an illegal type");
        }
    }

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list, String string) {
        this(canonicalizationMethod, signatureMethod, list);
        this.id = string;
    }

    public DOMSignedInfo(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.localSiElem = element;
        this.ownerDoc = element.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(element, "Id");
        Element element2 = DOMUtils.getFirstChildElement(element);
        this.canonicalizationMethod = new DOMCanonicalizationMethod(element2, xMLCryptoContext, provider);
        Element element3 = DOMUtils.getNextSiblingElement(element2);
        this.signatureMethod = DOMSignatureMethod.unmarshal(element3);
        ArrayList<DOMReference> arrayList = new ArrayList<DOMReference>(5);
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        while (element4 != null) {
            arrayList.add(new DOMReference(element4, xMLCryptoContext, provider));
            element4 = DOMUtils.getNextSiblingElement(element4);
        }
        this.references = Collections.unmodifiableList(arrayList);
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public InputStream getCanonicalizedData() {
        return this.canonData;
    }

    public void canonicalize(XMLCryptoContext xMLCryptoContext, ByteArrayOutputStream byteArrayOutputStream) throws XMLSignatureException {
        Object object;
        if (xMLCryptoContext == null) {
            throw new NullPointerException("context cannot be null");
        }
        UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(byteArrayOutputStream);
        try {
            ((OutputStream)unsyncBufferedOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DOMSubTreeData dOMSubTreeData = new DOMSubTreeData(this.localSiElem, true);
        try {
            object = ((DOMCanonicalizationMethod)this.canonicalizationMethod).canonicalize(dOMSubTreeData, xMLCryptoContext, unsyncBufferedOutputStream);
        }
        catch (TransformException transformException) {
            throw new XMLSignatureException(transformException);
        }
        object = byteArrayOutputStream.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])object));
            char[] cArray = new char[((Object)object).length];
            try {
                inputStreamReader.read(cArray);
                log.log(Level.FINE, "Canonicalized SignedInfo:\n" + new String(cArray));
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "IOException reading SignedInfo bytes");
            }
            log.log(Level.FINE, "Data to be signed/verified:" + Base64.encode((byte[])object));
        }
        this.canonData = new ByteArrayInputStream((byte[])object);
    }

    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(this.ownerDoc, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMCanonicalizationMethod dOMCanonicalizationMethod = (DOMCanonicalizationMethod)this.canonicalizationMethod;
        dOMCanonicalizationMethod.marshal(element, string, dOMCryptoContext);
        ((DOMSignatureMethod)this.signatureMethod).marshal(element, string, dOMCryptoContext);
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            DOMReference dOMReference = (DOMReference)this.references.get(i);
            dOMReference.marshal(element, string, dOMCryptoContext);
        }
        DOMUtils.setAttributeID(element, "Id", this.id);
        node.appendChild(element);
        this.localSiElem = element;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignedInfo)) {
            return false;
        }
        SignedInfo signedInfo = (SignedInfo)object;
        boolean bl = this.id == null ? signedInfo.getId() == null : this.id.equals(signedInfo.getId());
        return this.canonicalizationMethod.equals(signedInfo.getCanonicalizationMethod()) && this.signatureMethod.equals(signedInfo.getSignatureMethod()) && ((Object)this.references).equals(signedInfo.getReferences()) && bl;
    }
}

