/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.MXBeanProxy;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.MXBeanMappingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerInvocationHandler
implements InvocationHandler {
    private static final WeakHashMap<MXBeanMappingFactory, ClassToProxy> mxbeanProxies = MBeanServerInvocationHandler.newWeakHashMap();
    private final MBeanServerConnection connection;
    private final ObjectName objectName;
    private final JMX.MBeanOptions options;

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this(mBeanServerConnection, objectName, null);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName, boolean bl) {
        this(mBeanServerConnection, objectName, bl ? JMX.MBeanOptions.MXBEAN : null);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName, JMX.MBeanOptions mBeanOptions) {
        if (mBeanOptions == null) {
            mBeanOptions = new JMX.MBeanOptions();
        }
        if (mBeanServerConnection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null object name");
        }
        this.connection = mBeanServerConnection;
        this.objectName = objectName;
        this.options = mBeanOptions.canonical();
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isMXBean() {
        return this.options.isMXBean();
    }

    public JMX.MBeanOptions getMBeanOptions() {
        return this.options.uncanonical();
    }

    public static <T> T newProxyInstance(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        MBeanServerInvocationHandler mBeanServerInvocationHandler = new MBeanServerInvocationHandler(mBeanServerConnection, objectName);
        Class[] classArray = bl ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, mBeanServerInvocationHandler);
        return clazz.cast(object);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.equals(NotificationBroadcaster.class) || clazz.equals(NotificationEmitter.class)) {
            return this.invokeBroadcasterMethod(object, method, objectArray);
        }
        if (this.shouldDoLocally(object, method)) {
            return this.doLocally(object, method, objectArray);
        }
        try {
            int n;
            if (this.isMXBean()) {
                MXBeanProxy mXBeanProxy = this.findMXBeanProxy(clazz);
                return mXBeanProxy.invoke(this.connection, this.objectName, method, objectArray);
            }
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = method.getReturnType();
            int n2 = n = objectArray == null ? 0 : objectArray.length;
            if (string.startsWith("get") && string.length() > 3 && n == 0 && !clazz2.equals(Void.TYPE)) {
                return this.connection.getAttribute(this.objectName, string.substring(3));
            }
            if (string.startsWith("is") && string.length() > 2 && n == 0 && (clazz2.equals(Boolean.TYPE) || clazz2.equals(Boolean.class))) {
                return this.connection.getAttribute(this.objectName, string.substring(2));
            }
            if (string.startsWith("set") && string.length() > 3 && n == 1 && clazz2.equals(Void.TYPE)) {
                Attribute attribute = new Attribute(string.substring(3), objectArray[0]);
                this.connection.setAttribute(this.objectName, attribute);
                return null;
            }
            String[] stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
            return this.connection.invoke(this.objectName, string, objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException.getTargetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MXBeanProxy findMXBeanProxy(Class<?> clazz) {
        MXBeanMappingFactory mXBeanMappingFactory = this.options.getMXBeanMappingFactory();
        WeakHashMap<MXBeanMappingFactory, ClassToProxy> weakHashMap = mxbeanProxies;
        synchronized (weakHashMap) {
            MXBeanProxy mXBeanProxy;
            WeakReference weakReference;
            ClassToProxy classToProxy = mxbeanProxies.get(mXBeanMappingFactory);
            if (classToProxy == null) {
                classToProxy = new ClassToProxy();
                mxbeanProxies.put(mXBeanMappingFactory, classToProxy);
            }
            if ((weakReference = (WeakReference)classToProxy.get(clazz)) != null && (mXBeanProxy = (MXBeanProxy)weakReference.get()) != null) {
                return mXBeanProxy;
            }
            try {
                mXBeanProxy = new MXBeanProxy(clazz, mXBeanMappingFactory);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Cannot make MXBean proxy for " + clazz.getName() + ": " + illegalArgumentException.getMessage();
                throw new IllegalArgumentException(string, illegalArgumentException.getCause());
            }
            classToProxy.put(clazz, new WeakReference<MXBeanProxy>(mXBeanProxy));
            return mXBeanProxy;
        }
    }

    private static <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    private Object invokeBroadcasterMethod(Object object, Method method, Object[] objectArray) throws Exception {
        int n;
        String string = method.getName();
        int n2 = n = objectArray == null ? 0 : objectArray.length;
        if (string.equals("addNotificationListener")) {
            if (n != 3) {
                String string2 = "Bad arg count to addNotificationListener: " + n;
                throw new IllegalArgumentException(string2);
            }
            NotificationListener notificationListener = (NotificationListener)objectArray[0];
            NotificationFilter notificationFilter = (NotificationFilter)objectArray[1];
            Object object2 = objectArray[2];
            this.connection.addNotificationListener(this.objectName, notificationListener, notificationFilter, object2);
            return null;
        }
        if (string.equals("removeNotificationListener")) {
            NotificationListener notificationListener = (NotificationListener)objectArray[0];
            switch (n) {
                case 1: {
                    this.connection.removeNotificationListener(this.objectName, notificationListener);
                    return null;
                }
                case 3: {
                    NotificationFilter notificationFilter = (NotificationFilter)objectArray[1];
                    Object object3 = objectArray[2];
                    this.connection.removeNotificationListener(this.objectName, notificationListener, notificationFilter, object3);
                    return null;
                }
            }
            String string3 = "Bad arg count to removeNotificationListener: " + n;
            throw new IllegalArgumentException(string3);
        }
        if (string.equals("getNotificationInfo")) {
            if (objectArray != null) {
                throw new IllegalArgumentException("getNotificationInfo has args");
            }
            MBeanInfo mBeanInfo = this.connection.getMBeanInfo(this.objectName);
            return mBeanInfo.getNotifications();
        }
        throw new IllegalArgumentException("Bad method name: " + string);
    }

    private boolean shouldDoLocally(Object object, Method method) {
        String string = method.getName();
        if ((string.equals("hashCode") || string.equals("toString")) && method.getParameterTypes().length == 0 && MBeanServerInvocationHandler.isLocal(object, method)) {
            return true;
        }
        return string.equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class}) && MBeanServerInvocationHandler.isLocal(object, method);
    }

    private Object doLocally(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("equals")) {
            if (this == objectArray[0]) {
                return true;
            }
            if (!(objectArray[0] instanceof Proxy)) {
                return false;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(objectArray[0]);
            if (invocationHandler == null || !(invocationHandler instanceof MBeanServerInvocationHandler)) {
                return false;
            }
            MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)invocationHandler;
            return this.connection.equals(mBeanServerInvocationHandler.connection) && this.objectName.equals(mBeanServerInvocationHandler.objectName) && object.getClass().equals(objectArray[0].getClass());
        }
        if (string.equals("toString")) {
            return (this.isMXBean() ? "MX" : "M") + "BeanProxy(" + this.connection + "[" + this.objectName + "])";
        }
        if (string.equals("hashCode")) {
            return this.objectName.hashCode() + this.connection.hashCode();
        }
        throw new RuntimeException("Unexpected method name: " + string);
    }

    private static boolean isLocal(Object object, Method method) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        if (classArray == null) {
            return true;
        }
        String string = method.getName();
        Class<?>[] classArray2 = method.getParameterTypes();
        for (Class<?> clazz : classArray) {
            try {
                clazz.getMethod(string, classArray2);
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassToProxy
    extends WeakHashMap<Class<?>, WeakReference<MXBeanProxy>> {
        private ClassToProxy() {
        }
    }
}

