/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.schemagen;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.api.CompositeStructure;
import com.sun.xml.internal.bind.v2.TODO;
import com.sun.xml.internal.bind.v2.model.core.Adapter;
import com.sun.xml.internal.bind.v2.model.core.ArrayInfo;
import com.sun.xml.internal.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.ClassInfo;
import com.sun.xml.internal.bind.v2.model.core.Element;
import com.sun.xml.internal.bind.v2.model.core.ElementInfo;
import com.sun.xml.internal.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.EnumConstant;
import com.sun.xml.internal.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.internal.bind.v2.model.core.MapPropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.NonElementRef;
import com.sun.xml.internal.bind.v2.model.core.PropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.ReferencePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.internal.bind.v2.model.core.TypeRef;
import com.sun.xml.internal.bind.v2.model.core.ValuePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.internal.bind.v2.schemagen.FoolProofResolver;
import com.sun.xml.internal.bind.v2.schemagen.Form;
import com.sun.xml.internal.bind.v2.schemagen.MultiMap;
import com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Annotated;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Any;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.AttrDecls;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ComplexExtension;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ComplexType;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ComplexTypeHost;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ExplicitGroup;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.List;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.LocalAttribute;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.LocalElement;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Schema;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleExtension;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleRestriction;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleType;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleTypeHost;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TopLevelElement;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TypeHost;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TxwException;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.output.ResultFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.MimeType;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaGenerator<T, C, F, M> {
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Namespace> namespaces = new TreeMap<String, Namespace>(NAMESPACE_COMPARATOR);
    private Navigator<T, C, F, M> navigator;
    private final TypeInfoSet<T, C, F, M> types;
    private final NonElement<T, C> stringType;
    private final NonElement<T, C> anyType;
    private static final Comparator<String> NAMESPACE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return -string.compareTo(string2);
        }
    };
    private static final String newline = "\n";

    public XmlSchemaGenerator(Navigator<T, C, F, M> navigator, TypeInfoSet<T, C, F, M> typeInfoSet) {
        this.navigator = navigator;
        this.types = typeInfoSet;
        this.stringType = typeInfoSet.getTypeInfo(navigator.ref(String.class));
        this.anyType = typeInfoSet.getAnyTypeInfo();
        for (ClassInfo<T, Object> typeInfo : typeInfoSet.beans().values()) {
            this.add(typeInfo);
        }
        for (ElementInfo elementInfo : typeInfoSet.getElementMappings(null).values()) {
            this.add(elementInfo);
        }
        for (EnumLeafInfo enumLeafInfo : typeInfoSet.enums().values()) {
            this.add(enumLeafInfo);
        }
        for (ArrayInfo arrayInfo : typeInfoSet.arrays().values()) {
            this.add(arrayInfo);
        }
    }

    private Namespace getNamespace(String string) {
        Namespace namespace = this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        return namespace;
    }

    public void add(ClassInfo<T, C> classInfo) {
        Object object;
        assert (classInfo != null);
        String string = null;
        if (classInfo.getClazz() == this.navigator.asDecl(CompositeStructure.class)) {
            return;
        }
        if (classInfo.isElement()) {
            string = classInfo.getElementName().getNamespaceURI();
            object = this.getNamespace(string);
            ((Namespace)object).classes.add(classInfo);
            ((Namespace)object).addDependencyTo(classInfo.getTypeName());
            this.add(classInfo.getElementName(), false, classInfo);
        }
        if ((object = classInfo.getTypeName()) != null) {
            string = ((QName)object).getNamespaceURI();
        } else if (string == null) {
            return;
        }
        Namespace namespace = this.getNamespace(string);
        namespace.classes.add(classInfo);
        for (PropertyInfo<T, C> propertyInfo : classInfo.getProperties()) {
            PropertyInfo propertyInfo2;
            Object object2;
            namespace.processForeignNamespaces(propertyInfo);
            if (propertyInfo instanceof AttributePropertyInfo && ((String)(object2 = (propertyInfo2 = (AttributePropertyInfo)propertyInfo).getXmlName().getNamespaceURI())).length() > 0) {
                this.getNamespace((String)object2).addGlobalAttribute(propertyInfo2);
                namespace.addDependencyTo(propertyInfo2.getXmlName());
            }
            if (!(propertyInfo instanceof ElementPropertyInfo)) continue;
            propertyInfo2 = (ElementPropertyInfo)propertyInfo;
            object2 = propertyInfo2.getTypes().iterator();
            while (object2.hasNext()) {
                TypeRef typeRef = (TypeRef)object2.next();
                String string2 = typeRef.getTagName().getNamespaceURI();
                if (string2.length() <= 0 || string2.equals(namespace.uri)) continue;
                this.getNamespace(string2).addGlobalElement(typeRef);
                namespace.addDependencyTo(typeRef.getTagName());
            }
        }
        ClassInfo<T, C> classInfo2 = classInfo.getBaseClass();
        if (classInfo2 != null) {
            this.add(classInfo2);
        }
    }

    public void add(ElementInfo<T, C> elementInfo) {
        assert (elementInfo != null);
        QName qName = elementInfo.getElementName();
        Namespace namespace = this.getNamespace(qName.getNamespaceURI());
        MultiMap multiMap = namespace.elementDecls;
        String string = qName.getLocalPart();
        Namespace namespace2 = namespace;
        namespace2.getClass();
        multiMap.put(string, namespace2.new Namespace.ElementWithType(true, elementInfo.getContentType()));
        namespace.processForeignNamespaces(elementInfo.getProperty());
    }

    public void add(EnumLeafInfo<T, C> enumLeafInfo) {
        Object object;
        assert (enumLeafInfo != null);
        String string = null;
        if (enumLeafInfo.isElement()) {
            string = enumLeafInfo.getElementName().getNamespaceURI();
            object = this.getNamespace(string);
            ((Namespace)object).enums.add(enumLeafInfo);
            ((Namespace)object).addDependencyTo(enumLeafInfo.getTypeName());
            this.add(enumLeafInfo.getElementName(), false, enumLeafInfo);
        }
        if ((object = enumLeafInfo.getTypeName()) != null) {
            string = ((QName)object).getNamespaceURI();
        } else if (string == null) {
            return;
        }
        Namespace namespace = this.getNamespace(string);
        namespace.enums.add(enumLeafInfo);
        namespace.addDependencyTo(enumLeafInfo.getBaseType().getTypeName());
    }

    public void add(ArrayInfo<T, C> arrayInfo) {
        assert (arrayInfo != null);
        String string = arrayInfo.getTypeName().getNamespaceURI();
        Namespace namespace = this.getNamespace(string);
        namespace.arrays.add(arrayInfo);
        namespace.addDependencyTo(arrayInfo.getItemType().getTypeName());
    }

    public void add(QName qName, boolean bl, NonElement<T, C> nonElement) {
        if (nonElement != null && nonElement.getType() == this.navigator.ref(CompositeStructure.class)) {
            return;
        }
        Namespace namespace = this.getNamespace(qName.getNamespaceURI());
        MultiMap multiMap = namespace.elementDecls;
        String string = qName.getLocalPart();
        Namespace namespace2 = namespace;
        namespace2.getClass();
        multiMap.put(string, namespace2.new Namespace.ElementWithType(bl, nonElement));
        if (nonElement != null) {
            namespace.addDependencyTo(nonElement.getTypeName());
        }
    }

    public void write(SchemaOutputResolver schemaOutputResolver) throws IOException {
        Result result;
        if (schemaOutputResolver == null) {
            throw new IllegalArgumentException();
        }
        schemaOutputResolver = new FoolProofResolver(schemaOutputResolver);
        HashMap<Namespace, Result> hashMap = new HashMap<Namespace, Result>();
        this.namespaces.remove("http://www.w3.org/2001/XMLSchema");
        for (Namespace namespace : this.namespaces.values()) {
            result = schemaOutputResolver.createOutput(namespace.uri, "schema" + (hashMap.size() + 1) + ".xsd");
            if (result == null) continue;
            hashMap.put(namespace, result);
        }
        for (Namespace namespace : this.namespaces.values()) {
            result = (Result)hashMap.get(namespace);
            if (result == null) continue;
            namespace.writeTo(result, hashMap);
            if (!(result instanceof StreamResult)) continue;
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            if (outputStream != null) {
                outputStream.close();
                continue;
            }
            Writer writer = ((StreamResult)result).getWriter();
            if (writer == null) continue;
            writer.close();
        }
    }

    private static String getProcessContentsModeName(WildcardMode wildcardMode) {
        switch (wildcardMode) {
            case LAX: 
            case SKIP: {
                return wildcardMode.name().toLowerCase();
            }
            case STRICT: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    protected static String relativize(String string, String string2) {
        try {
            assert (string != null);
            if (string2 == null) {
                return string;
            }
            URI uRI = new URI(com.sun.xml.internal.bind.v2.schemagen.Util.escapeURI(string));
            URI uRI2 = new URI(com.sun.xml.internal.bind.v2.schemagen.Util.escapeURI(string2));
            if (uRI.isOpaque() || uRI2.isOpaque()) {
                return string;
            }
            if (!com.sun.xml.internal.bind.v2.schemagen.Util.equalsIgnoreCase(uRI.getScheme(), uRI2.getScheme()) || !com.sun.xml.internal.bind.v2.schemagen.Util.equal(uRI.getAuthority(), uRI2.getAuthority())) {
                return string;
            }
            String string3 = uRI.getPath();
            String string4 = uRI2.getPath();
            if (!string4.endsWith("/")) {
                string4 = com.sun.xml.internal.bind.v2.schemagen.Util.normalizeUriPath(string4);
            }
            if (string3.equals(string4)) {
                return ".";
            }
            String string5 = XmlSchemaGenerator.calculateRelativePath(string3, string4);
            if (string5 == null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5);
            if (uRI.getQuery() != null) {
                stringBuffer.append('?').append(uRI.getQuery());
            }
            if (uRI.getFragment() != null) {
                stringBuffer.append('#').append(uRI.getFragment());
            }
            return stringBuffer.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError("Error escaping one of these uris:\n\t" + string + "\n\t" + string2);
        }
    }

    private static String calculateRelativePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return "../" + XmlSchemaGenerator.calculateRelativePath(string, com.sun.xml.internal.bind.v2.schemagen.Util.getParentUriPath(string2));
    }

    static /* synthetic */ NonElement access$700(XmlSchemaGenerator xmlSchemaGenerator) {
        return xmlSchemaGenerator.stringType;
    }

    static /* synthetic */ NonElement access$800(XmlSchemaGenerator xmlSchemaGenerator) {
        return xmlSchemaGenerator.anyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Namespace {
        final String uri;
        private final Set<Namespace> depends = new LinkedHashSet<Namespace>();
        private boolean selfReference;
        private final Set<ClassInfo<T, C>> classes = new LinkedHashSet();
        private final Set<EnumLeafInfo<T, C>> enums = new LinkedHashSet();
        private final Set<ArrayInfo<T, C>> arrays = new LinkedHashSet();
        private final MultiMap<String, NonElement<T, C>> attributeDecls = new MultiMap(XmlSchemaGenerator.access$700(XmlSchemaGenerator.this));
        private final MultiMap<String, com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration> elementDecls = new MultiMap(new ElementWithType(true, XmlSchemaGenerator.access$800(XmlSchemaGenerator.this)));
        private Form attributeFormDefault;
        private Form elementFormDefault;

        public Namespace(String string) {
            this.uri = string;
            assert (!XmlSchemaGenerator.this.namespaces.containsKey(string));
            XmlSchemaGenerator.this.namespaces.put(string, this);
        }

        private void processForeignNamespaces(PropertyInfo<T, C> propertyInfo) {
            for (TypeInfo typeInfo : propertyInfo.ref()) {
                if (typeInfo instanceof Element) {
                    this.addDependencyTo(((Element)typeInfo).getElementName());
                }
                if (!(typeInfo instanceof NonElement)) continue;
                this.addDependencyTo(((NonElement)typeInfo).getTypeName());
            }
        }

        private void addDependencyTo(@Nullable QName qName) {
            if (qName == null) {
                return;
            }
            String string = qName.getNamespaceURI();
            if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            if (string.equals(this.uri)) {
                this.selfReference = true;
                return;
            }
            this.depends.add(XmlSchemaGenerator.this.getNamespace(string));
        }

        private void writeTo(Result result, Map<Namespace, Result> map) throws IOException {
            try {
                Annotated annotated;
                Schema schema = TXW.create(Schema.class, ResultFactory.createSerializer(result));
                Map<String, String> map2 = XmlSchemaGenerator.this.types.getXmlNs(this.uri);
                for (Map.Entry<String, String> object : map2.entrySet()) {
                    schema._namespace(object.getValue(), object.getKey());
                }
                this.attributeFormDefault = Form.get(XmlSchemaGenerator.this.types.getAttributeFormDefault(this.uri));
                this.attributeFormDefault.declare("attributeFormDefault", schema);
                this.elementFormDefault = Form.get(XmlSchemaGenerator.this.types.getElementFormDefault(this.uri));
                this.elementFormDefault.declare("elementFormDefault", schema);
                if (!map2.containsValue("http://www.w3.org/2001/XMLSchema") && !map2.containsKey("xs")) {
                    schema._namespace("http://www.w3.org/2001/XMLSchema", "xs");
                }
                schema.version("1.0");
                if (this.uri.length() != 0) {
                    schema.targetNamespace(this.uri);
                }
                for (Namespace namespace : this.depends) {
                    schema._namespace(namespace.uri);
                }
                if (this.selfReference && this.uri.length() != 0) {
                    schema._namespace(this.uri, "tns");
                }
                schema._pcdata(XmlSchemaGenerator.newline);
                for (Namespace namespace : this.depends) {
                    annotated = schema._import();
                    if (namespace.uri.length() != 0) {
                        annotated.namespace(namespace.uri);
                    }
                    annotated.schemaLocation(XmlSchemaGenerator.relativize(map.get(namespace).getSystemId(), result.getSystemId()));
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (Map.Entry entry : this.elementDecls.entrySet()) {
                    ((ElementDeclaration)entry.getValue()).writeTo((String)entry.getKey(), schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ClassInfo classInfo : this.classes) {
                    if (classInfo.getTypeName() == null) continue;
                    if (this.uri.equals(classInfo.getTypeName().getNamespaceURI())) {
                        this.writeClass(classInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (EnumLeafInfo enumLeafInfo : this.enums) {
                    if (enumLeafInfo.getTypeName() == null) continue;
                    if (this.uri.equals(enumLeafInfo.getTypeName().getNamespaceURI())) {
                        this.writeEnum(enumLeafInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ArrayInfo arrayInfo : this.arrays) {
                    this.writeArray(arrayInfo, schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (Map.Entry entry : this.attributeDecls.entrySet()) {
                    annotated = schema.attribute();
                    annotated.name((String)entry.getKey());
                    this.writeTypeRef((TypeHost)((Object)annotated), (NonElement)entry.getValue(), "type");
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                schema.commit();
            }
            catch (TxwException txwException) {
                logger.log(Level.INFO, txwException.getMessage(), txwException);
                throw new IOException(txwException.getMessage());
            }
        }

        private void writeTypeRef(TypeHost typeHost, NonElementRef<T, C> nonElementRef, String string) {
            switch (nonElementRef.getSource().id()) {
                case ID: {
                    typeHost._attribute(string, (Object)new QName("http://www.w3.org/2001/XMLSchema", "ID"));
                    return;
                }
                case IDREF: {
                    typeHost._attribute(string, (Object)new QName("http://www.w3.org/2001/XMLSchema", "IDREF"));
                    return;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            MimeType mimeType = nonElementRef.getSource().getExpectedMimeType();
            if (mimeType != null) {
                typeHost._attribute(new QName("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes", "xmime"), (Object)mimeType.toString());
            }
            if (this.generateSwaRefAdapter(nonElementRef)) {
                typeHost._attribute(string, (Object)new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef", "ref"));
                return;
            }
            if (nonElementRef.getSource().getSchemaType() != null) {
                typeHost._attribute(string, (Object)nonElementRef.getSource().getSchemaType());
                return;
            }
            this.writeTypeRef(typeHost, nonElementRef.getTarget(), string);
        }

        private boolean generateSwaRefAdapter(NonElementRef<T, C> nonElementRef) {
            Adapter adapter = nonElementRef.getSource().getAdapter();
            if (adapter == null) {
                return false;
            }
            Object c = XmlSchemaGenerator.this.navigator.asDecl(SwaRefAdapter.class);
            if (c == null) {
                return false;
            }
            return c.equals(adapter.adapterType);
        }

        private void writeTypeRef(TypeHost typeHost, NonElement<T, C> nonElement, String string) {
            if (nonElement.getTypeName() == null) {
                if (nonElement instanceof ClassInfo) {
                    this.writeClass((ClassInfo)nonElement, typeHost);
                } else {
                    this.writeEnum((EnumLeafInfo)nonElement, (SimpleTypeHost)typeHost);
                }
            } else {
                typeHost._attribute(string, (Object)nonElement.getTypeName());
            }
        }

        private void writeArray(ArrayInfo<T, C> arrayInfo, Schema schema) {
            ComplexType complexType = schema.complexType().name(arrayInfo.getTypeName().getLocalPart());
            complexType._final("#all");
            LocalElement localElement = complexType.sequence().element().name("item");
            localElement.type(arrayInfo.getItemType().getTypeName());
            localElement.minOccurs(0).maxOccurs("unbounded");
            localElement.nillable(true);
            complexType.commit();
        }

        private void writeEnum(EnumLeafInfo<T, C> enumLeafInfo, SimpleTypeHost simpleTypeHost) {
            SimpleType simpleType = simpleTypeHost.simpleType();
            this.writeName(enumLeafInfo, simpleType);
            SimpleRestriction simpleRestriction = simpleType.restriction();
            this.writeTypeRef((TypeHost)simpleRestriction, enumLeafInfo.getBaseType(), "base");
            for (EnumConstant enumConstant : enumLeafInfo.getConstants()) {
                simpleRestriction.enumeration().value(enumConstant.getLexicalValue());
            }
            simpleType.commit();
        }

        private void writeClass(ClassInfo<T, C> classInfo, TypeHost typeHost) {
            if (this.containsValueProp(classInfo)) {
                if (classInfo.getProperties().size() == 1) {
                    ValuePropertyInfo valuePropertyInfo = (ValuePropertyInfo)classInfo.getProperties().get(0);
                    SimpleType simpleType = ((SimpleTypeHost)typeHost).simpleType();
                    this.writeName(classInfo, simpleType);
                    if (valuePropertyInfo.isCollection()) {
                        this.writeTypeRef((TypeHost)simpleType.list(), valuePropertyInfo.getTarget(), "itemType");
                    } else {
                        this.writeTypeRef((TypeHost)simpleType.restriction(), valuePropertyInfo.getTarget(), "base");
                    }
                    return;
                }
                ComplexType complexType = ((ComplexTypeHost)typeHost).complexType();
                this.writeName(classInfo, complexType);
                if (classInfo.isFinal()) {
                    complexType._final("extension restriction");
                }
                SimpleExtension simpleExtension = complexType.simpleContent().extension();
                simpleExtension.block();
                block4: for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                    switch (propertyInfo.kind()) {
                        case ATTRIBUTE: {
                            this.handleAttributeProp((AttributePropertyInfo)propertyInfo, simpleExtension);
                            continue block4;
                        }
                        case VALUE: {
                            TODO.checkSpec("what if vp.isCollection() == true?");
                            ValuePropertyInfo valuePropertyInfo = (ValuePropertyInfo)propertyInfo;
                            simpleExtension.base(valuePropertyInfo.getTarget().getTypeName());
                            continue block4;
                        }
                    }
                    assert (false);
                    throw new IllegalStateException();
                }
                simpleExtension.commit();
                TODO.schemaGenerator("figure out what to do if bc != null");
                TODO.checkSpec("handle sec 8.9.5.2, bullet #4");
                return;
            }
            ComplexType complexType = ((ComplexTypeHost)typeHost).complexType();
            this.writeName(classInfo, complexType);
            if (classInfo.isFinal()) {
                complexType._final("extension restriction");
            }
            if (classInfo.isAbstract()) {
                complexType._abstract(true);
            }
            complexType.block();
            TypedXmlWriter typedXmlWriter = null;
            AttrDecls attrDecls = complexType;
            ClassInfo classInfo2 = classInfo.getBaseClass();
            if (classInfo2 != null) {
                ComplexExtension complexExtension = complexType.complexContent().extension();
                attrDecls = complexExtension;
                complexExtension.base(classInfo2.getTypeName());
                typedXmlWriter = classInfo.isOrdered() ? complexExtension.sequence() : complexExtension.all();
            }
            if (classInfo.hasProperties()) {
                if (typedXmlWriter == null) {
                    typedXmlWriter = classInfo.isOrdered() ? complexType.sequence() : complexType.all();
                }
                typedXmlWriter.block();
                for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                    if (propertyInfo instanceof ReferencePropertyInfo && ((ReferencePropertyInfo)propertyInfo).isMixed()) {
                        complexType.mixed(true);
                    }
                    this.writeProperty(propertyInfo, attrDecls, (ExplicitGroup)typedXmlWriter);
                }
                typedXmlWriter.commit();
            }
            if (classInfo.hasAttributeWildcard()) {
                attrDecls.anyAttribute().namespace("##other").processContents("skip");
            }
            complexType.commit();
        }

        private void writeName(NonElement<T, C> nonElement, TypedXmlWriter typedXmlWriter) {
            QName qName = nonElement.getTypeName();
            if (qName != null) {
                typedXmlWriter._attribute("name", (Object)qName.getLocalPart());
            }
        }

        private boolean containsValueProp(ClassInfo<T, C> classInfo) {
            for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof ValuePropertyInfo)) continue;
                return true;
            }
            return false;
        }

        private void writeProperty(PropertyInfo<T, C> propertyInfo, AttrDecls attrDecls, ExplicitGroup explicitGroup) {
            switch (propertyInfo.kind()) {
                case ELEMENT: {
                    this.handleElementProp((ElementPropertyInfo)propertyInfo, explicitGroup);
                    break;
                }
                case ATTRIBUTE: {
                    this.handleAttributeProp((AttributePropertyInfo)propertyInfo, attrDecls);
                    break;
                }
                case REFERENCE: {
                    this.handleReferenceProp((ReferencePropertyInfo)propertyInfo, explicitGroup);
                    break;
                }
                case MAP: {
                    this.handleMapProp((MapPropertyInfo)propertyInfo, explicitGroup);
                    break;
                }
                case VALUE: {
                    assert (false);
                    throw new IllegalStateException();
                }
                default: {
                    assert (false);
                    throw new IllegalStateException();
                }
            }
        }

        private void handleElementProp(ElementPropertyInfo<T, C> elementPropertyInfo, ExplicitGroup explicitGroup) {
            QName qName = elementPropertyInfo.getXmlName();
            Annotated annotated = null;
            if (elementPropertyInfo.isValueList()) {
                TypeRef typeRef = elementPropertyInfo.getTypes().get(0);
                LocalElement localElement = explicitGroup.element();
                QName qName2 = typeRef.getTagName();
                localElement.name(qName2.getLocalPart());
                List list = localElement.simpleType().list();
                this.writeTypeRef((TypeHost)list, typeRef, "itemType");
                this.elementFormDefault.writeForm(localElement, qName2);
                return;
            }
            if (elementPropertyInfo.isCollection()) {
                if (qName != null) {
                    LocalElement localElement = explicitGroup.element();
                    if (qName.getNamespaceURI().length() > 0 && !qName.getNamespaceURI().equals(this.uri)) {
                        localElement.ref(new QName(qName.getNamespaceURI(), qName.getLocalPart()));
                        return;
                    }
                    this.elementFormDefault.writeForm(localElement, qName);
                    ComplexType object = localElement.name(qName.getLocalPart()).complexType();
                    if (elementPropertyInfo.isCollectionNillable()) {
                        localElement.nillable(true);
                    } else {
                        localElement.minOccurs(0);
                    }
                    if (elementPropertyInfo.getTypes().size() == 1) {
                        explicitGroup = object.sequence();
                    } else {
                        annotated = explicitGroup = object.choice();
                    }
                } else if (elementPropertyInfo.getTypes().size() > 1) {
                    annotated = explicitGroup = explicitGroup.choice();
                }
            } else if (elementPropertyInfo.getTypes().size() > 1) {
                annotated = explicitGroup = explicitGroup.choice();
            }
            for (TypeRef typeRef : elementPropertyInfo.getTypes()) {
                QName qName3;
                LocalElement localElement = explicitGroup.element();
                if (annotated == null) {
                    annotated = localElement;
                }
                if (this.canBeDirectElementRef(typeRef, qName3 = typeRef.getTagName()) || !qName3.getNamespaceURI().equals(this.uri) && qName3.getNamespaceURI().length() > 0) {
                    localElement.ref(qName3);
                } else {
                    localElement.name(qName3.getLocalPart());
                    this.writeTypeRef((TypeHost)localElement, typeRef, "type");
                    this.elementFormDefault.writeForm(localElement, qName3);
                }
                if (typeRef.isNillable()) {
                    localElement.nillable(true);
                }
                if (typeRef.getDefaultValue() == null) continue;
                localElement._default(typeRef.getDefaultValue());
            }
            if (elementPropertyInfo.isCollection()) {
                annotated.maxOccurs("unbounded");
            }
            if (!elementPropertyInfo.isRequired()) {
                annotated.minOccurs(0);
            }
        }

        private boolean canBeDirectElementRef(TypeRef<T, C> typeRef, QName qName) {
            if (typeRef.isNillable() || typeRef.getDefaultValue() != null) {
                return false;
            }
            if (typeRef.getTarget() instanceof Element) {
                Element element = (Element)((Object)typeRef.getTarget());
                QName qName2 = element.getElementName();
                return qName2 != null && qName2.equals(qName);
            }
            return false;
        }

        private void handleAttributeProp(AttributePropertyInfo<T, C> attributePropertyInfo, AttrDecls attrDecls) {
            LocalAttribute localAttribute = attrDecls.attribute();
            String string = attributePropertyInfo.getXmlName().getNamespaceURI();
            if (string.equals("") || string.equals(this.uri)) {
                String string2;
                Annotated annotated;
                localAttribute.name(attributePropertyInfo.getXmlName().getLocalPart());
                if (attributePropertyInfo.isCollection()) {
                    annotated = localAttribute.simpleType().list();
                    string2 = "itemType";
                } else {
                    annotated = localAttribute;
                    string2 = "type";
                }
                this.writeTypeRef((TypeHost)((Object)annotated), attributePropertyInfo, string2);
                this.attributeFormDefault.writeForm(localAttribute, attributePropertyInfo.getXmlName());
            } else {
                localAttribute.ref(attributePropertyInfo.getXmlName());
            }
            if (attributePropertyInfo.isRequired()) {
                localAttribute.use("required");
            }
        }

        private void handleReferenceProp(ReferencePropertyInfo<T, C> referencePropertyInfo, ExplicitGroup explicitGroup) {
            Object object;
            Object object3;
            QName qName = referencePropertyInfo.getXmlName();
            Annotated object4 = null;
            if (referencePropertyInfo.isCollection()) {
                if (qName != null) {
                    object3 = explicitGroup.element();
                    ComplexType object22 = object3.name(qName.getLocalPart()).complexType();
                    this.elementFormDefault.writeForm((LocalElement)object3, qName);
                    if (referencePropertyInfo.isCollectionNillable()) {
                        object3.nillable(true);
                    }
                    if (referencePropertyInfo.getElements().size() == 1) {
                        explicitGroup = object22.sequence();
                    } else {
                        object4 = explicitGroup = object22.choice();
                    }
                } else if (referencePropertyInfo.getElements().size() > 1) {
                    object4 = explicitGroup = explicitGroup.choice();
                }
            }
            TODO.checkSpec("should we loop in the case of a non-collection ep?");
            for (Element element : referencePropertyInfo.getElements()) {
                object = explicitGroup.element();
                if (object4 == null) {
                    object4 = object;
                }
                QName qName2 = element.getElementName();
                if (element.getScope() != null) {
                    boolean bl = qName2.getNamespaceURI().equals(this.uri);
                    boolean bl2 = qName2.getNamespaceURI().equals("");
                    if (bl || bl2) {
                        if (bl2) {
                            if (this.elementFormDefault.isEffectivelyQualified) {
                                object.form("unqualified");
                            }
                        } else if (!this.elementFormDefault.isEffectivelyQualified) {
                            object.form("qualified");
                        }
                        object.name(qName2.getLocalPart());
                        if (element instanceof ClassInfo) {
                            this.writeTypeRef((TypeHost)object, (ClassInfo)((Object)element), "type");
                            continue;
                        }
                        this.writeTypeRef((TypeHost)object, ((ElementInfo)element).getContentType(), "type");
                        continue;
                    }
                }
                object.ref(qName2);
            }
            object3 = referencePropertyInfo.getWildcard();
            if (object3 != null) {
                Any any = explicitGroup.any();
                object = XmlSchemaGenerator.getProcessContentsModeName((WildcardMode)((Object)object3));
                if (object != null) {
                    any.processContents((String)object);
                }
                TODO.schemaGenerator("generate @namespace ???");
                if (object4 == null) {
                    object4 = any;
                }
            }
            if (referencePropertyInfo.isCollection()) {
                object4.maxOccurs("unbounded");
            }
        }

        private void handleMapProp(MapPropertyInfo<T, C> mapPropertyInfo, ExplicitGroup explicitGroup) {
            QName qName = mapPropertyInfo.getXmlName();
            LocalElement localElement = explicitGroup.element();
            this.elementFormDefault.writeForm(localElement, qName);
            if (mapPropertyInfo.isCollectionNillable()) {
                localElement.nillable(true);
            }
            ComplexType complexType = localElement.name(qName.getLocalPart()).complexType();
            localElement = complexType.sequence().element();
            localElement.name("entry").minOccurs(0).maxOccurs("unbounded");
            ExplicitGroup explicitGroup2 = localElement.complexType().sequence();
            this.writeKeyOrValue(explicitGroup2, "key", mapPropertyInfo.getKeyType());
            this.writeKeyOrValue(explicitGroup2, "value", mapPropertyInfo.getValueType());
        }

        private void writeKeyOrValue(ExplicitGroup explicitGroup, String string, NonElement<T, C> nonElement) {
            LocalElement localElement = explicitGroup.element().name(string);
            localElement.minOccurs(0);
            this.writeTypeRef((TypeHost)localElement, nonElement, "type");
        }

        public void addGlobalAttribute(AttributePropertyInfo<T, C> attributePropertyInfo) {
            this.attributeDecls.put(attributePropertyInfo.getXmlName().getLocalPart(), attributePropertyInfo.getTarget());
            this.addDependencyTo(attributePropertyInfo.getTarget().getTypeName());
        }

        public void addGlobalElement(TypeRef<T, C> typeRef) {
            this.elementDecls.put(typeRef.getTagName().getLocalPart(), (com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration)new ElementWithType(false, typeRef.getTarget()));
            this.addDependencyTo(typeRef.getTarget().getTypeName());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElementWithType
        extends ElementDeclaration {
            private final boolean nillable;
            private final NonElement<T, C> type;

            public ElementWithType(boolean bl, NonElement<T, C> nonElement) {
                this.type = nonElement;
                this.nillable = bl;
            }

            @Override
            public void writeTo(String string, Schema schema) {
                TopLevelElement topLevelElement = schema.element().name(string);
                if (this.nillable) {
                    topLevelElement.nillable(true);
                }
                if (this.type != null) {
                    Namespace.this.writeTypeRef(topLevelElement, this.type, "type");
                } else {
                    topLevelElement.complexType();
                }
                topLevelElement.commit();
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ElementWithType elementWithType = (ElementWithType)object;
                return this.type.equals(elementWithType.type);
            }

            @Override
            public int hashCode() {
                return this.type.hashCode();
            }
        }

        abstract class ElementDeclaration {
            ElementDeclaration() {
            }

            public abstract boolean equals(Object var1);

            public abstract int hashCode();

            public abstract void writeTo(String var1, Schema var2);
        }
    }
}

