# $Id: sys.clean-env.mk,v 1.15 2012/01/20 22:44:35 sjg Exp $
#
#	@(#) Copyright (c) 2009, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

# The variables used by this makefile include:
#
# MAKE_ENV_SAVE_VAR_LIST
#	The actuall list of variables from the environment that will be
#	preserved.
# MAKE_ENV_SAVE_PREFIX_LIST
#	A list of prefixes to match against the environment - the results
#	are added to MAKE_ENV_SAVE_VAR_LIST after being filtered by...
# MAKE_ENV_SAVE_EXCLUDE_LIST
#	A list of words or patterns which is turned into a list of :N
#	modifiers.

.if ${.MAKE.LEVEL} == 0 && ${MAKE_VERSION} >= 20100606
# We save any env var that starts with the words in MAKE_ENV_SAVE_PREFIX_LIST.
# This gets expanded to an egrep expression like '^(A|B|C...)'
# and added to MAKE_ENV_SAVE_VAR_LIST below.
# If any of these end up being too greedy, MAKE_ENV_SAVE_EXCLUDE_LIST
# can be used to filter.
MAKE_ENV_SAVE_PREFIX_LIST += \
	CCACHE \
	CVS \
	DEBUG \
	DISTCC \
	HOST \
	MACHINE \
	MAKE \
	MK \
	NEED_ \
	SB_ \
	SSH \
	SVN \
	USE_ \

# This could be a list of vars or patterns to explicitly exclude.
MAKE_ENV_SAVE_EXCLUDE_LIST ?= _

# This is the actual list that we will save
MAKE_ENV_SAVE_VAR_LIST += \
	HOME \
	LOGNAME \
	OBJROOT \
	OBJTOP \
	PATH \
	SB \
	SRCTOP \
	USER \
	${_env_vars:${MAKE_ENV_SAVE_EXCLUDE_LIST:${M_ListToSkip}}}

_env_vars != env | egrep '^(${MAKE_ENV_SAVE_PREFIX_LIST:ts|})' | sed 's,=.*,,'; echo

_export_list =
.for v in ${MAKE_ENV_SAVE_VAR_LIST:O:u}
.if defined($v)
_export_list += $v
# Save current value
$v := ${$v}
.endif
.endfor

# Now, clobber the environment
.unexport-env

# This is a list of vars that we handle specially below
_tricky_env_vars = MAKEOBJDIR OBJTOP
# Export our selection - sans tricky ones
.export ${_export_list:${_tricky_env_vars:${M_ListToSkip}}}

# This next bit may need tweaking
# if you don't happen to like the way I set it.
.if defined(MAKEOBJDIR)
# We are going to set this to the equivalent of the shell's
# MAKEOBJDIR='${.CURDIR:S,${SRCTOP},${OBJTOP},}'
_srctop := ${SRCTOP:U${SB_SRC:U${SB}/src}}
_objroot := ${OBJROOT:U${SB_OBJROOT:U${SB}/${SB_OBJPREFIX}}}
_objtop := ${OBJTOP:U${_objroot}${MACHINE}}
# Take care of ${MACHINE} or ${MACHINE_ARCH} (we don't use that anymore).
OBJTOP = ${_objtop:S,${MACHINE}$,\${MACHINE},:S,${MACHINE_ARCH}$,\${MACHINE_ARCH},}
# Export like this
MAKEOBJDIR = $${.CURDIR:S,${_srctop},$${OBJTOP},}
#.info ${MAKE_SAVE_ENV_VARS _srctop _objroot _objtop OBJTOP MAKEOBJDIR:L:@v@${.newline}$v=${$v}@}

# Export these as-is, and do not track...
# otherwise the environment will be ruined when we evaluate them below.
.export-env ${_tricky_env_vars}

# Now evaluate for ourselves
.for v in ${_tricky_env_vars}
$v := ${$v}
.endfor
#.info ${_tricky_env_vars:@v@${.newline}$v=${$v}@}

.endif				# MAKEOBJDIR
.endif				# level 0
