# $Id: sys.clean-env.mk,v 1.9 2010/06/08 22:36:39 sjg Exp $
#
#	@(#) Copyright (c) 2009, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

.if ${.MAKE.LEVEL} == 0
# we save any env var that starts with these
MAKE_SAVE_ENV_PREFIX += SB MK MAKE NEED_ CCACHE DISTCC USE_ SSH
env_vars != env | egrep '^(${MAKE_SAVE_ENV_PREFIX:ts|})' | sed 's,=.*,,'; echo
MAKE_SAVE_ENV_VARS += \
	PATH HOME USER LOGNAME \
	SRCTOP OBJTOP OBJROOT \
	${env_vars}

_export_list =
.for v in ${MAKE_SAVE_ENV_VARS:O:u}
.if !empty($v)
_export_list += $v
$v := ${$v}
.endif
.endfor
# now clobber the environment
.unexport-env
# export our selection - MAKEOBJDIR is tricky
.export ${_export_list:NMAKEOBJDIR}
.if defined(MAKEOBJDIR)
# you will very likely need to tweak this lot
srctop := ${SRCTOP:U${SB_SRC:U${SB}/src}}
objroot := ${OBJROOT:U${SB_OBJROOT:U${SB}/${SB_OBJPREFIX}}}
# we'll take care of MACHINE below
objtop := ${OBJTOP:U${objroot}${MACHINE}}
.if !empty(objtop)
# we would normally want something like (/bin/sh):
# MAKEOBJDIR="\${.CURDIR:S,${SRCTOP},${OBJROOT}\${MACHINE},}"
# the $$ below is how we achieve the same result here.
# since everything saved from the environment above
# has run through := we need to compensate for ${MACHINE}
MAKEOBJDIR = $${.CURDIR:S,${srctop},${objtop:S,${MACHINE},\${MACHINE},},}
# export this as-is, and do not track it...
.export-env MAKEOBJDIR
# now evaluate it for ourselves
MAKEOBJDIR := ${MAKEOBJDIR}
.endif
.endif
.endif
