# $Id: dpadd.mk,v 1.10 2005/10/09 22:56:31 sjg Exp $
#
#	@(#) Copyright (c) 2004, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

# make it easier to keep DPADD and LDADD in sync
DPADD+= ${DPLIBS}
LDADD+= ${DPLIBS:T:R:S/lib/-l/:C/\.so.*//}

# Convert DPADD into -I and -L options and add them to CPPFLAGS and LDADD
# For the -I's convert the path to a relative one.  For separate objdirs
# the DPADD paths will be to the obj tree so we need to subst anyway.

# If USE_PROFILE is yes, then check for profiled versions of libs
# and use them.

USE_PROFILE?=no
.if defined(LIBDL) && exists(${LIBDL})
.if defined(PROG) && (make(${PROG}_p) || ${USE_PROFILE} == yes) && \
	defined(LDFLAGS) && ${LDFLAGS:M-export-dynamic}
# building profiled version of a prog that needs dlopen to work
DPLIBS+= ${LIBDL}
.endif
.endif

.if defined(LIBDMALLOC) && exists(${LIBDMALLOC})
.if defined(USE_DMALLOC) && ${USE_DMALLOC} != no
.if !defined(NO_DMALLOC)
CPPFLAGS+= -DUSE_DMALLOC
.endif
DPLIBS+= ${LIBDMALLOC}
.endif
.endif

LDADD+=${DPADD:R:H:S/^/-L/g}

.if ${.CURDIR} == ${SRCTOP}
RELDIR=.
RELTOP=.
.else
RELDIR?= ${.CURDIR:S,${SRCTOP}/,,}
.if ${RELDIR} == ${.CURDIR}
RELDIR?= ${.OBJDIR:S,${OBJTOP}/,,}
.endif
RELTOP?= ${RELDIR:C,[^/]+,..,g}
.endif
RELOBJTOP?= ${OBJTOP}
RELSRCTOP?= ${SRCTOP}

.if !make(dpadd)
.ifdef LIB
# Each lib is its own src_lib, we want to include it in SRC_LIBS
# so that the correct INCLUDES_* will be picked up automatically.
# In 90% of cases, just putting lib${LIB} in SRC_LIBS would do
# the job, but we cannot guarantee that the variable for libfu-bar
# won't be LIBFUBAR.  So we make one up:
__THISLIB=${_OBJDIR}/lib${LIB}.a
SRC_LIBS+= __THISLIB
.endif
.endif

# 
# This little bit of magic, assumes that SRC_libfoo will be
# set if it cannot be correctly derrived from ${LIBFOO}
# Note that SRC_libfoo and INCLUDES_libfoo should be named for the
# actual libary name not the variable name that might refer to it.
# 99% of the time the two are the same, but the DPADD logic
# only has the libary name available, so stick to that.
# 
# __cflags_incs lets us avoid duplicates
__cflags_incs:=${CFLAGS:M-I*} ${CPPFLAGS:M-I*}
dpadd_cflags=
# if SRC_LIBS contains a word like libfoo we expand ${LIBFOO}
# but if it contained ${LIBFOO} we pass it through as is.
# we are assuming that the expansion of ${LIBFOO} will contain a '.'
.for __lib in ${SRC_LIBS:@x@${"${x:M*.*}":?$x:${${x:tu}}}@} ${DPADD}
.if (make(${PROG}_p) || defined(NEED_GPROF)) && exists(${__lib:R}_p.a)
__ldadd=-l${__lib:T:R:S,lib,,}
LDADD:=${LDADD:S,^${__ldadd}$,${__ldadd}_p,g}
.endif
# 
# if SRC_libfoo is not set, then we assume that the srcdir corresponding
# to where we found the library is correct.
#
SRC_${__lib:T:R}?= ${__lib:H:S,${OBJTOP},${RELSRCTOP},}
#
# If INCLUDES_libfoo is not set, then we'll use ${SRC_libfoo}/h if it exists,
# else just ${SRC_libfoo}.
#
INCLUDES_${__lib:T:R}?= -I${exists(${SRC_${__lib:T:R}}/h):?${SRC_${__lib:T:R}}/h:${SRC_${__lib:T:R}}}
#
# Some libs generate headers, so we potentially need both
# the src dir and the obj dir.
# If ${INCLUDES_libfoo} contains a word ending in /h, we assume that either
# 1. it does not generate headers or
# 2. INCLUDES_libfoo will have been set correctly
# XXX it gets ugly avoiding duplicates... 
# use :? to ensure .for does not prevent correct evaluation
#
dpadd_cflags+= ${empty(${INCLUDES_${__lib:T:R}:M*/h}) && empty(${__cflags_incs:M-I${__lib:H:S,${OBJTOP},${RELOBJTOP},}}):?-I${__lib:H:S,${OBJTOP},${RELOBJTOP},}: }
dpadd_cflags+= ${INCLUDES_${__lib:T:R}:@i@${empty(${__cflags_incs:M$i}):?$i: }@}
#
# even if we didn't add it, say we did.
#
__cflags_incs+=-I${__lib:H:S,${OBJTOP},${RELOBJTOP},}
__cflags_incs+=${INCLUDES_${__lib:T:R}}
.endfor
#
# eliminate any duplicates - but don't mess with the order
# force evaluation now - to avoid giving make a headache
#
dpadd_cflags:=${dpadd_cflags:u}
CPPFLAGS+= ${dpadd_cflags}

# This target is used to gather a list of
# dir: ${DPADD}
# entries
dpadd:	.NOTMAIN
.if defined(DPADD) && ${DPADD} != ""
	@echo "${RELDIR}: ${DPADD:S,${OBJTOP}/,,}"
.endif

.if !empty(WARNINGS_SET) || !empty(WARNINGS_SET_${MACHINE_ARCH})
.include <warnings.mk>
.endif
