/*	$NecBSD: kanji.h,v 1.17.16.1 1999/08/31 21:01:57 honda Exp $	*/
/*	$NetBSD$	*/

/*
 * [NetBSD for NEC PC-98 series]
 *  Copyright (c) 1994, 1995, 1996, 1997, 1998
 *	NetBSD/pc98 porting staff. All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  Copyright (c) 1994, 1995, 1996, 1997, 1998
 *	Naofumi HONDA.  All rights reserved.
 */

#ifndef	_I386_VSC_KANJI_H_
#define	_I386_VSC_KANJI_H_

/*
 * CHARACTER CODE SET TABLE.
 * You can add any char sets as you want.
 */

struct kanji kanjiset[]= {
	{
		{
			{XASCII, XKANA, XKANA, SUPGRAPH},
			{CHARSET2, CHARSET2, CHARSET2, CHARSET2},
			{STDCTRL, STDCTRL},
			 0, 1,
			 -1
		}, "JIS(j)"
	},
	{
		{
			{ROMAJI, XKANA, XKANA, SUPGRAPH},
			{CHARSET2, CHARSET2, CHARSET2, CHARSET2},
			{STDCTRL, STDCTRL},
			 0, 1,
			 -1
		}, "ROMAJI(r)"
	},
	{
		{
			{XASCII, EUCKANJI, XKANA, EUCKANJI},
			{CHARSET2, CHARSET0, CHARSET2, CHARSET0},
			{STDCTRL, STDCTRL},
			 0, 1,
			 -1
		}, "EUC(e)"
	},
	{
		{
			{ROMAJI, XKANA, SJIS, SUPGRAPH},
			{CHARSET2, CHARSET2, CHARSET0, CHARSET2},
			{STDCTRL, NOCTRL},
			 0, 2,
			 -1
		}, "SJIS(s)"
	},
	{
		{
			{ROMAJI, JIS8, XKANA, SUPGRAPH},
			{CHARSET2, CHARSET0, CHARSET2, CHARSET2},
			{STDCTRL, STDCTRL},
			 0, 1,
			 -1
		}, "USERSET(u)"
	},
	{
		{
			{XASCII, XKANA, XKANA, EUCKANJI},
			{CHARSET2, CHARSET2, CHARSET2, CHARSET0},
			{STDCTRL, STDCTRL},
			 0, 3,
			 -1
		}, "JE(je)"
	},
	{
		{
			{XASCII, SUPGRAPH, XASCII, SUPGRAPH},
			{CHARSET2, CHARSET2, CHARSET2, CHARSET2},
			{STDCTRL, STDCTRL},
			 0, 1,
			 -1
		}, "DEC(d)"
	},
/** USER SETTINGS BELOW THIS LINE ***/
};

#if defined(_KERNEL)
#if defined(FONT_LOAD)
struct FontList fontjis8list[]=
{
	{
	  0x3646, FONTGAIJI, 0,
	  {
	  0x80, 0x80, 0x1ffc, 0x80, 0x490, 0x410, 0x3ffe, 0x410,
	  0x410, 0x0, 0x7fff, 0x240, 0x240, 0x440, 0x1841, 0x603e,
	  },
	  0,
	},

	{
	  0x4b6a, FONTGAIJI, 0,
	  {
	  0x1010, 0x1010, 0x1010, 0x11ff, 0x7c10, 0x10fe, 0x1082, 0x38fe,
	  0x3482, 0x50fe, 0x5082, 0x10fe, 0x1000, 0x11ff, 0x1044, 0x1383,
	  },
	  0,
	},

	{
	  0x4d5a, FONTGAIJI, 0,
	  {
	  0x0, 0x2, 0xc, 0x4070, 0x2382, 0x1124, 0x98, 0x1fe,
	  0x7220, 0x1020, 0x17ff, 0x1020, 0x1222, 0x13fe, 0x2800, 0x47ff,
	  },
	  0,
	},

	{
	  0x6076, FONTGAIJI, 0,
	  {
	  0x6, 0xf8, 0x7c02, 0x1122, 0x1094, 0x1000, 0x11ff, 0x7c10,
	  0x1010, 0x11ff, 0x1010, 0x1492, 0x1892, 0x7092, 0x92, 0xfe,
	  },
	  0,
	},

	{
	  0x7425, FONTGAIJI, 0,
	  {
	  0x20, 0x27ff, 0x1000, 0x13fe, 0xa02, 0x2fa, 0x28a, 0x3fe,
	  0x802, 0x8fc, 0x920, 0x17ff, 0x1070, 0x20a8, 0x2727, 0x4020,
	  },
	  0,
	},

	{
	  0x7426, FONTGAIJI, 0,
	  {
	  0x0, 0x3fbe, 0x2222, 0x2222, 0x2fa2, 0x28be, 0x28a0, 0x2fa0,
	  0x2221, 0x2221, 0x3f9e, 0x0, 0x0, 0x1244, 0x2222, 0x4221,
	  },
	  0,
	},

	{
	  0x223a, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x7f8, 0x800, 0x1000, 0x1000, 0x1ff8,
	  0x1000, 0x1000, 0x800, 0x7f8, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x223b, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x1fe0, 0x10, 0x8, 0x8, 0x1ff8,
	  0x8, 0x8, 0x10, 0x1fe0, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x223c, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0xffc, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000,
	  0x1000, 0xffc, 0x0, 0x0, 0x3ffc, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x223d, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x3ff0, 0x8, 0x4, 0x4, 0x4, 0x4,
	  0x8, 0x3ff0, 0x0, 0x0, 0x3ffc, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x223e, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x7fc, 0x800, 0x1000, 0x2000, 0x2000,
	  0x2000, 0x2000, 0x1000, 0x800, 0x7fc, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x223f, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x3fe0, 0x10, 0x8, 0x4, 0x4,
	  0x4, 0x4, 0x8, 0x10, 0x3fe0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224a, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x100, 0x100, 0x280, 0x280, 0x440, 0x440,
	  0x820, 0x820, 0x1010, 0x1010, 0x2008, 0x2008, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224b, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x2008, 0x2008, 0x1010, 0x1010, 0x820, 0x820,
	  0x440, 0x440, 0x280, 0x280, 0x100, 0x100, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224c, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ffc, 0x4,
	  0x4, 0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224d, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x10, 0x8, 0xfffc, 0x2, 0x1,
	  0x2, 0xfffc, 0x8, 0x10, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224e, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x810, 0x1008, 0x3ffc, 0x4002, 0x8001,
	  0x4002, 0x3ffc, 0x1008, 0x810, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x224f, FONTGAIJI, 0,
	  {
	  0x0, 0x4004, 0x4004, 0x2008, 0x2008, 0x1ff0, 0x1010, 0x820,
	  0x820, 0x440, 0x440, 0x280, 0x280, 0x100, 0x100, 0x0,
	  },
	  0,
	},

	{
	  0x2250, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x1ff0, 0x10, 0x10, 0x10, 0x10, 0x1ff0,
	  0x10, 0x10, 0x10, 0x10, 0x1ff0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x225e, FONTGAIJI, 0,
	  {
	  0x7e0, 0x381c, 0xc003, 0x0, 0x0, 0x0, 0x0, 0x0,
	  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x225f, FONTGAIJI, 0,
	  {
	  0x0, 0x1e0, 0x330, 0x410, 0x10, 0x10, 0x3b0, 0x460,
	  0x820, 0x1860, 0x1040, 0x10c0, 0x1980, 0xf00, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x2260, FONTGAIJI, 0,
	  {
	  0x0, 0x7ffe, 0x3004, 0x300c, 0x1808, 0x1818, 0xc10, 0xc30,
	  0x620, 0x660, 0x340, 0x3c0, 0x180, 0x180, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x2263, FONTGAIJI, 0,
	  {
	  0x0, 0x42, 0x84, 0x318, 0x420, 0x18c0, 0x2100, 0x4200,
	  0x2100, 0x1080, 0x840, 0x630, 0x108, 0x84, 0x42, 0x0,
	  },
	  0,
	},

	{
	  0x2264, FONTGAIJI, 0,
	  {
	  0x0, 0x4200, 0x2100, 0x18c0, 0x420, 0x318, 0x84, 0x42,
	  0x84, 0x108, 0x210, 0xc60, 0x1080, 0x2100, 0x4200, 0x0,
	  },
	  0,
	},

	{
	  0x2266, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x0, 0x1c38, 0x2044, 0x4082, 0x4082,
	  0x4102, 0x4102, 0x2204, 0x1c38, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x2267, FONTGAIJI, 0,
	  {
	  0x0, 0x0, 0x0, 0x0, 0x1c38, 0x2244, 0x4180, 0x4180,
	  0x4180, 0x4180, 0x2244, 0x1c38, 0x0, 0x0, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x2269, FONTGAIJI, 0,
	  {
	  0x1c0, 0x240, 0x200, 0x200, 0x300, 0x300, 0x100, 0x180,
	  0x180, 0x80, 0xc0, 0xc0, 0x40, 0x40, 0x240, 0x380,
	  },
	  0,
	},

	{
	  0x226a, FONTGAIJI, 0,
	  {
	  0xe38, 0x1248, 0x1040, 0x1040, 0x1860, 0x1860, 0x820, 0xc30,
	  0xc30, 0x410, 0x618, 0x618, 0x208, 0x208, 0x1248, 0x1c70,
	  },
	  0,
	},

	{
	  0x2272, FONTGAIJI, 0,
	  {
	  0x180, 0x240, 0x240, 0x180, 0x0, 0x100, 0x280, 0x280,
	  0x440, 0x420, 0xff0, 0x810, 0x1008, 0x7c3e, 0x0, 0x0,
	  },
	  0,
	},

	{
	  0x2273, FONTGAIJI, 0,
	  {
	  0x0, 0x3040, 0x4840, 0x4880, 0x4900, 0x4900, 0x4a00, 0x3400,
	  0x58c, 0xa52, 0x1252, 0x1252, 0x2252, 0x4252, 0x418c, 0x0,
	  },
	  0,
	},

	{
	  0x2274, FONTGAIJI, 0,
	  {
	  0x20, 0x420, 0x420, 0x43c, 0x7fc, 0x3fe0, 0x3c20, 0x420,
	  0x420, 0x43c, 0x7fc, 0x3fe0, 0x3c20, 0x420, 0x420, 0x400,
	  },
	  0,
	},

	{
	  0x2275, FONTGAIJI, 0,
	  {
	  0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x5e0, 0x630,
	  0x430, 0x430, 0x430, 0x460, 0x4c0, 0x500, 0x600, 0x400,
	  },
	  0,
	},

	{
	  0x2276, FONTGAIJI, 0,
	  {
	  0x80, 0x80, 0xc0, 0xe0, 0xb0, 0x98, 0x8c, 0x84,
	  0x84, 0x88, 0x90, 0x80, 0xf80, 0x1f80, 0x1f00, 0xe00,
	  },
	  0,
	},

	{
	  0x2277, FONTGAIJI, 0,
	  {
	  0x100, 0x380, 0x920, 0x1ff0, 0x920, 0x100, 0x7c0, 0x380,
	  0x380, 0x380, 0x380, 0x380, 0x100, 0x100, 0x100, 0x100,
	  },
	  0,
	},

	{
	  0x2278, FONTGAIJI, 0,
	  {
	  0x100, 0x380, 0x920, 0x1ff0, 0x920, 0x380, 0x380, 0x100,
	  0x100, 0x380, 0x380, 0x920, 0x1ff0, 0x920, 0x380, 0x100,
	  },
	  0,
	},

	{
	  0x2279, FONTGAIJI, 0,
	  {
	  0x0, 0x7e0, 0xf20, 0x1f20, 0x1f20, 0x1f20, 0xf20, 0x720,
	  0x120, 0x120, 0x120, 0x120, 0x120, 0x120, 0x120, 0x120,
	  },
	  0,
	},

	{
	  0x227e, FONTGAIJI, 0,
	  {
	  0x3c0, 0xc30, 0x1008, 0x2004, 0x4002, 0x4002, 0x8001, 0x8001,
	  0x8001, 0x8001, 0x4002, 0x4002, 0x2004, 0x1008, 0xc30, 0x3c0,
	  },
	  0,
	},
	{
	 0, 0, 0,
	}
};

struct ConvTbl jis8tbl[] = {
	 {0x2240, 0x2d7c}
	,{0x2241, 0x2d7b}
	,{0x225c, 0x2d77}
	,{0x225d, 0x2d76}
	,{0x2261, 0x2d71}
	,{0x2262, 0x2d70}
	,{0x2265, 0x2d75}
	,{0x2268, 0x2d7a}
	,{0x2821, 0x2c24}
	,{0x2822, 0x2c26}
	,{0x2823, 0x2c30}
	,{0x2824, 0x2c34}
	,{0x2825, 0x2c3c}
	,{0x2826, 0x2c38}
	,{0x2827, 0x2c40}
	,{0x2828, 0x2c50}
	,{0x2829, 0x2c48}
	,{0x282a, 0x2c58}
	,{0x282b, 0x2c60}
	,{0x282c, 0x2c25}
	,{0x282d, 0x2c27}
	,{0x282e, 0x2c33}
	,{0x282f, 0x2c37}
	,{0x2830, 0x2c3f}
	,{0x2831, 0x2c3b}
	,{0x2832, 0x2c47}
	,{0x2833, 0x2c57}
	,{0x2834, 0x2c4f}
	,{0x2835, 0x2c5f}
	,{0x2836, 0x2c6f}
	,{0x2837, 0x2c44}
	,{0x2838, 0x2c53}
	,{0x2839, 0x2c4c}
	,{0x283a, 0x2c5b}
	,{0x283b, 0x2c63}
	,{0x283c, 0x2c41}
	,{0x283d, 0x2c54}
	,{0x283e, 0x2c49}
	,{0x283f, 0x2c5c}
	,{0x2840, 0x2c66}
	,{0x3033, 0x724d	/**/ }
	,{0x3139, 0x567D			}
	,{0x3229, 0x7274	/**/ }
	,{0x3342, 0x695a	/*ay*/ }
	,{0x3349, 0x5978	/*h*/ }
	,{0x3376, 0x635e	/*}*/ }
	,{0x3443, 0x5e75	/**/ }
	,{0x3452, 0x6b5d	/*|*/ }
	,{0x375b, 0x7074	/*z*/ }
	,{0x395c, 0x6268	/*{*/ }
	,{0x3c49, 0x6922	/*A*/ }
	,{0x3f59, 0x7057	/*x*/ }
	,{0x4128, 0x6c4d	/*G*/ }
	,{0x445b, 0x5464	/*ٚ*/ }
	,{0x4557, 0x626a	/*v*/ }
	,{0x456e, 0x5b6d	/**/ }
	,{0x4573, 0x5e39	/**/ }
	,{0x4676, 0x6d6e	/**/ }
	,{0x4768, 0x6a24	/**/ }
	,{0x4930, 0x5b58	/*Ow*/ }
	,{0x4b79, 0x5056	/**/ }
	,{0x4c79, 0x692e	/*M*/ }
	,{0x4f36, 0x6446	/*U*/ }
	,{0x5056, 0x4b79	/*Ԗ*/ }
	,{0x5464, 0x445b	/**/ }
	,{0x5978, 0x3349	/*852a*/ }
	,{0x5b58, 0x4930	/*wO*/ }
	,{0x5b6d, 0x456e	/**/ }
	,{0x5e39, 0x4573	/**/ }
	,{0x5e75, 0x3443	/**/ }
	,{0x6268, 0x395c	/*{*/ }
	,{0x626a, 0x4557	/*v*/ }
	,{0x635e, 0x3376	/*}*/ }
	,{0x6446, 0x4f36	/*ĘU*/ }
	,{0x6922, 0x3c49	/*A*/ }
	,{0x692e, 0x4c79	/*M*/ }
	,{0x695a, 0x3342	/*ya*/ }
	,{0x6a24, 0x4768	/*墔*/ }
	,{0x6b5d, 0x3452	/*|*/ }
	,{0x6c4d, 0x4128	/*ˑG*/ }
	,{0x6d6e, 0x4676	/*玓*/ }
	,{0x7057, 0x3f59	/*Րx*/ }
	,{0x7074, 0x375b	/*z*/ }
	,{0x724d, 0x3033	/*ˈ*/ }
	,{0x7274, 0x3229	/**/ }
	,{0x7421, 0x3646	/*Ɤ*/ }
	,{0x7422, 0x4b6a	/*ꠖ*/ }
	,{0x7423, 0x4d5a	/*ꡗy*/ }
	,{0x7424, 0x6076	/**/ }
	,
};
#else	/* !FONT_LOAD */
struct FontList fontjis8list[]=
	{
	 0, 0, 0,
	}
};

struct ConvTbl jis8tbl[] = {
	/* nothing */
};
#endif	/* !FONT_LOAD */
#endif	/* _KERNEL */
#endif	/* !_I386_VSC_KANJI_H_ */
