/*	$NetBSD: pfilter.c,v 1.3 2020/07/04 04:00:53 lukem Exp $	*/

#if defined(HAVE_TNFTPD_H)
#include "tnftpd.h"
#endif

#include <stdio.h>

#if USE_BLOCKLIST
#include <blocklist.h>
#elif USE_BLACKLIST
#include <blacklist.h>
#endif

#include "pfilter.h"

#if USE_BLOCKLIST
static struct blocklist *blstate;
#elif USE_BLACKLIST
static struct blacklist *blstate;
#endif

void
pfilter_open(void)
{
#if USE_BLOCKLIST
	if (blstate == NULL)
		blstate = blocklist_open();
#elif USE_BLACKLIST
	if (blstate == NULL)
		blstate = blacklist_open();
#endif
}

void
pfilter_notify(int what, const char *msg)
{
#if USE_BLOCKLIST || USE_BLACKLIST
	pfilter_open();

	if (blstate == NULL)
		return;


#if USE_BLOCKLIST
	blocklist_r(blstate, what, STDIN_FILENO, msg);
#elif USE_BLOCKLIST
	blacklist_r(blstate, what, STDIN_FILENO, msg);
#endif
#endif /* USE_BLOCKLIST || USE_BLACKLIST */
}
