/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.RootContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactJabberImpl;
import net.java.sip.communicator.service.customavatar.CustomAvatarService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.osgi.framework.ServiceReference;

public class ServerStoredContactListJabberImpl {
    private static final Logger logger = Logger.getLogger(ServerStoredContactListJabberImpl.class);
    private Roster roster = null;
    private final RootContactGroupJabberImpl rootGroup;
    private final OperationSetPersistentPresenceJabberImpl parentOperationSet;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private final Vector<ServerStoredGroupListener> serverStoredGroupListeners = new Vector();
    private ImageRetriever imageRetriever = null;
    private ChangeListener rosterChangeListener = null;
    private InfoRetreiver infoRetreiver = null;
    private boolean isRosterInitialized = false;
    private final Object rosterInitLock = new Object();
    private PresenceStatus initialStatus = null;
    private String initialStatusMessage = null;

    ServerStoredContactListJabberImpl(OperationSetPersistentPresenceJabberImpl parentOperationSet, ProtocolProviderServiceJabberImpl provider, InfoRetreiver infoRetreiver) {
        this.parentOperationSet = parentOperationSet;
        this.jabberProvider = provider;
        this.rootGroup = new RootContactGroupJabberImpl(this.jabberProvider);
        this.infoRetreiver = infoRetreiver;
    }

    public ContactGroup getRootGroup() {
        return this.rootGroup;
    }

    RosterEntry getRosterEntry(BareJid user) {
        if (this.roster == null) {
            return null;
        }
        return this.roster.getEntry(user);
    }

    RosterGroup getRosterGroup(String name) {
        return this.roster.getGroup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            if (!this.serverStoredGroupListeners.contains(listener)) {
                this.serverStoredGroupListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            this.serverStoredGroupListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireGroupEvent(ContactGroupJabberImpl group, int eventID) {
        ArrayList<ServerStoredGroupListener> listeners;
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        ServerStoredGroupEvent evt = new ServerStoredGroupEvent((ContactGroup)group, eventID, this.parentOperationSet.getServerStoredContactListRoot(), (ProtocolProviderService)this.jabberProvider, (OperationSetPersistentPresence)this.parentOperationSet);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following grp event: " + evt));
        }
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            listeners = new ArrayList<ServerStoredGroupListener>(this.serverStoredGroupListeners);
        }
        if (eventID == 1) {
            Iterator<Contact> iter = group.contacts();
            while (iter.hasNext()) {
                ContactJabberImpl c = (ContactJabberImpl)iter.next();
                if (this.roster == null) continue;
                this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(c.getAddressAsJid().asBareJid()));
            }
        }
        for (ServerStoredGroupListener listener : listeners) {
            if (eventID == 2) {
                listener.groupRemoved(evt);
                continue;
            }
            if (eventID == 3) {
                listener.groupNameChanged(evt);
                continue;
            }
            if (eventID == 1) {
                listener.groupCreated(evt);
                continue;
            }
            if (eventID != 4) continue;
            listener.groupResolved(evt);
        }
    }

    void fireContactRemoved(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Removing " + contact.getAddress() + " from " + parentGroup.getGroupName()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 2);
    }

    private void fireContactMoved(ContactGroup oldParentGroup, ContactGroup newParentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionMovedEvent((Contact)contact, oldParentGroup, newParentGroup);
    }

    ProtocolProviderServiceJabberImpl getParentProvider() {
        return this.jabberProvider;
    }

    public ContactGroupJabberImpl findContactGroup(String name) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        name = name.trim();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (!contactGroup.getGroupName().trim().equals(name)) continue;
            return contactGroup;
        }
        return null;
    }

    private ContactGroupJabberImpl findContactGroupByNameCopy(String name) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        name = name.trim();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (contactGroup.getNameCopy() == null || !contactGroup.getNameCopy().trim().equals(name)) continue;
            return contactGroup;
        }
        return null;
    }

    public ContactJabberImpl findContactById(Jid id) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        ContactJabberImpl result = null;
        BareJid userId = id.asBareJid();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            result = contactGroup.findContact((Jid)userId);
            if (result == null) continue;
            return result;
        }
        ContactGroupJabberImpl volatileGroup = this.getNonPersistentGroup();
        if (volatileGroup != null && (result = volatileGroup.findContact(id)) != null) {
            return result;
        }
        return this.rootGroup.findContact((Jid)userId);
    }

    public ContactGroup findContactGroup(ContactJabberImpl child) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        Jid contactAddress = child.getAddressAsJid();
        while (contactGroups.hasNext()) {
            ContactGroupJabberImpl contactGroup = (ContactGroupJabberImpl)contactGroups.next();
            if (contactGroup.findContact(contactAddress) == null) continue;
            return contactGroup;
        }
        if (this.rootGroup.findContact(contactAddress) != null) {
            return this.rootGroup;
        }
        return null;
    }

    public void addContact(String id) throws OperationFailedException {
        this.addContact(null, id);
    }

    public void addContact(ContactGroup parent, String id) throws OperationFailedException {
        EntityBareJid completeID;
        ContactJabberImpl existingContact;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding contact " + id + " to parent=" + parent));
        }
        if ((existingContact = this.findContactById((Jid)(completeID = this.parseAddressString(id)))) != null && existingContact.isPersistent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Contact " + completeID + " already exists in group " + this.findContactGroup(existingContact)));
            }
            throw new OperationFailedException("Contact " + completeID + " already exists.", 5);
        }
        try {
            String[] parentNames = null;
            if (parent != null && parent != this.getRootGroup()) {
                parentNames = new String[]{parent.getGroupName()};
            }
            StanzaListener presenceInterceptor = new StanzaListener((BareJid)completeID){
                final /* synthetic */ BareJid val$completeID;
                {
                    this.val$completeID = bareJid;
                }

                public void processStanza(Stanza packet) {
                    Presence presence = (Presence)packet;
                    if (presence.getType() == Presence.Type.subscribe && this.val$completeID.equals((CharSequence)presence.getTo().asBareJid())) {
                        Nick nicknameExt = new Nick(JabberActivator.getGlobalDisplayDetailsService().getDisplayName((ProtocolProviderService)ServerStoredContactListJabberImpl.this.jabberProvider));
                        presence.addExtension((ExtensionElement)nicknameExt);
                    }
                }
            };
            this.jabberProvider.getConnection().addPacketInterceptor(presenceInterceptor, (StanzaFilter)new StanzaTypeFilter(Presence.class));
            this.getParentProvider().getConnection().setReplyTimeout(45000L);
            this.roster.createEntry((BareJid)completeID, completeID.toString(), parentNames);
            this.getParentProvider().getConnection().setReplyTimeout((long)SmackConfiguration.getDefaultReplyTimeout());
            this.jabberProvider.getConnection().removePacketInterceptor(presenceInterceptor);
        }
        catch (XMPPException.XMPPErrorException ex) {
            String errTxt = "Error adding new jabber entry";
            logger.error((Object)errTxt, (Throwable)ex);
            int errorCode = 4;
            XMPPError err = ex.getXMPPError();
            if (err != null) {
                switch (err.getCondition()) {
                    case forbidden: 
                    case not_allowed: 
                    case not_authorized: {
                        errorCode = 403;
                        break;
                    }
                    default: {
                        errorCode = 500;
                    }
                }
                errTxt = err.getConditionText();
            }
            throw new OperationFailedException(errTxt, errorCode, (Throwable)ex);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            throw new OperationFailedException("Could not add contact", 4, e);
        }
    }

    ContactJabberImpl createVolatileContact(Jid id, boolean isPrivateMessagingContact, String displayName) {
        VolatileContactJabberImpl newVolatileContact = new VolatileContactJabberImpl(id, this, isPrivateMessagingContact, displayName);
        ContactGroupJabberImpl theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            theVolatileGroup = new VolatileContactGroupJabberImpl(JabberActivator.getResources().getI18NString("service.gui.NOT_IN_CONTACT_LIST_GROUP_NAME"), this);
            theVolatileGroup.addContact(newVolatileContact);
            this.rootGroup.addSubGroup(theVolatileGroup);
            this.fireGroupEvent(theVolatileGroup, 1);
        } else {
            theVolatileGroup.addContact(newVolatileContact);
            this.fireContactAdded(theVolatileGroup, newVolatileContact);
        }
        return newVolatileContact;
    }

    public boolean isPrivateMessagingContact(Jid contactAddress) {
        ContactGroupJabberImpl theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            return false;
        }
        ContactJabberImpl contact = theVolatileGroup.findContact(contactAddress);
        if (contact == null || !(contact instanceof VolatileContactJabberImpl)) {
            return false;
        }
        return ((VolatileContactJabberImpl)contact).isPrivateMessagingContact();
    }

    synchronized ContactJabberImpl createUnresolvedContact(ContactGroup parentGroup, Jid id) {
        ContactJabberImpl existingContact = this.findContactById(id);
        if (existingContact != null) {
            return existingContact;
        }
        ContactJabberImpl newUnresolvedContact = new ContactJabberImpl(id, this, true);
        if (parentGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)parentGroup).addContact(newUnresolvedContact);
        } else if (parentGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)parentGroup).addContact(newUnresolvedContact);
        }
        this.fireContactAdded(parentGroup, newUnresolvedContact);
        return newUnresolvedContact;
    }

    synchronized ContactGroupJabberImpl createUnresolvedContactGroup(String groupName) {
        ContactGroupJabberImpl existingGroup = this.findContactGroup(groupName);
        if (existingGroup != null) {
            return existingGroup;
        }
        ContactGroupJabberImpl newUnresolvedGroup = new ContactGroupJabberImpl(groupName, this);
        this.rootGroup.addSubGroup(newUnresolvedGroup);
        this.fireGroupEvent(newUnresolvedGroup, 1);
        return newUnresolvedGroup;
    }

    public void createGroup(String groupName) throws OperationFailedException {
        ContactGroupJabberImpl existingGroup;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating group: " + groupName));
        }
        if ((existingGroup = this.findContactGroup(groupName)) != null && existingGroup.isPersistent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContactGroup " + groupName + " already exists."));
            }
            throw new OperationFailedException("ContactGroup " + groupName + " already exists.", 6);
        }
        RosterGroup newRosterGroup = this.roster.createGroup(groupName);
        ContactGroupJabberImpl newGroup = new ContactGroupJabberImpl(newRosterGroup, new ArrayList().iterator(), this, true);
        this.rootGroup.addSubGroup(newGroup);
        this.fireGroupEvent(newGroup, 1);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Group " + groupName + " created."));
        }
    }

    public void removeGroup(ContactGroupJabberImpl groupToRemove) throws OperationFailedException {
        try {
            Vector<Contact> localCopy = new Vector<Contact>();
            Iterator<Object> iter = groupToRemove.contacts();
            while (iter.hasNext()) {
                localCopy.add(iter.next());
            }
            for (ContactJabberImpl contactJabberImpl : localCopy) {
                if (!contactJabberImpl.isPersistent()) continue;
                this.roster.removeEntry(contactJabberImpl.getSourceEntry());
            }
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException ex) {
            logger.error((Object)"Error removing group", ex);
            throw new OperationFailedException(ex.getMessage(), 1, ex);
        }
    }

    void removeContact(ContactJabberImpl contactToRemove) throws OperationFailedException {
        if (contactToRemove instanceof VolatileContactJabberImpl) {
            this.contactDeleted(contactToRemove);
            return;
        }
        try {
            RosterEntry entry = contactToRemove.getSourceEntry();
            if (entry != null) {
                this.roster.removeEntry(entry);
            }
        }
        catch (XMPPException.XMPPErrorException ex) {
            String errTxt = "Error removing contact";
            logger.error((Object)errTxt, (Throwable)ex);
            int errorCode = 4;
            XMPPError err = ex.getXMPPError();
            if (err != null) {
                switch (err.getCondition()) {
                    case forbidden: 
                    case not_allowed: 
                    case not_authorized: {
                        errorCode = 403;
                    }
                }
                errTxt = err.getConditionText();
            }
            throw new OperationFailedException(errTxt, errorCode, (Throwable)ex);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException ex) {
            throw new OperationFailedException("Could not remove contact", 1, ex);
        }
    }

    public void renameGroup(ContactGroupJabberImpl groupToRename, String newName) {
        try {
            groupToRename.getSourceGroup().setName(newName);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            logger.error((Object)("Could not rename " + groupToRename + " to " + newName));
        }
        groupToRename.setNameCopy(newName);
    }

    public void moveContact(ContactJabberImpl contact, AbstractContactGroupJabberImpl newParent) throws OperationFailedException {
        if (!contact.isPersistent()) {
            String contactAddress = null;
            contactAddress = contact instanceof VolatileContactJabberImpl && ((VolatileContactJabberImpl)contact).isPrivateMessagingContact() ? contact.getPersistableAddress() : contact.getAddress();
            try {
                this.addContact(newParent, contactAddress);
                return;
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Cannot move contact! ", (Throwable)ex);
                throw new OperationFailedException(ex.getMessage(), 1, (Throwable)ex);
            }
        }
        try {
            this.getParentProvider().getConnection().setReplyTimeout(45000L);
            this.roster.createEntry(contact.getSourceEntry().getJid(), contact.getDisplayName(), new String[]{newParent.getGroupName()});
            this.getParentProvider().getConnection().setReplyTimeout((long)SmackConfiguration.getDefaultReplyTimeout());
            newParent.addContact(contact);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException ex) {
            logger.error((Object)"Cannot move contact! ", ex);
            throw new OperationFailedException(ex.getMessage(), 1, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OperationSetPersistentPresenceJabberImpl.ContactChangesListener presenceChangeListener) {
        this.roster = Roster.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection());
        presenceChangeListener.storeEvents();
        this.roster.addRosterListener((RosterListener)presenceChangeListener);
        this.roster.setSubscriptionMode(Roster.SubscriptionMode.manual);
        this.initRoster();
        Object object = this.rosterInitLock;
        synchronized (object) {
            this.isRosterInitialized = true;
        }
        this.sendInitialStatus();
        presenceChangeListener.processStoredEvents();
        this.rosterChangeListener = new ChangeListener();
        this.roster.addRosterListener((RosterListener)this.rosterChangeListener);
    }

    void sendInitialStatus() {
        try {
            if (this.initialStatus != null) {
                this.parentOperationSet.publishPresenceStatus(this.initialStatus, this.initialStatusMessage);
            } else {
                this.getParentProvider().getConnection().sendStanza((Stanza)new Presence(Presence.Type.available));
            }
        }
        catch (InterruptedException | OperationFailedException | SmackException.NotConnectedException ex) {
            logger.error((Object)"Error publishing initial presence", ex);
        }
        this.initialStatus = null;
        this.initialStatusMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        if (this.imageRetriever != null) {
            this.imageRetriever.quit();
            this.imageRetriever = null;
        }
        if (this.roster != null) {
            this.roster.removeRosterListener((RosterListener)this.rosterChangeListener);
        }
        this.rosterChangeListener = null;
        this.roster = null;
        Object object = this.rosterInitLock;
        synchronized (object) {
            this.isRosterInitialized = false;
        }
    }

    private synchronized void initRoster() {
        ContactGroupJabberImpl group;
        Object contact;
        if (this.roster.getUnfiledEntryCount() > 0) {
            for (RosterEntry item : this.roster.getUnfiledEntries()) {
                contact = this.findContactById((Jid)item.getJid());
                if (!ServerStoredContactListJabberImpl.isEntryDisplayable(item)) {
                    if (contact == null) continue;
                    ContactGroup contactGroup = ((ContactJabberImpl)((Object)contact)).getParentContactGroup();
                    if (contactGroup instanceof RootContactGroupJabberImpl) {
                        ((RootContactGroupJabberImpl)contactGroup).removeContact((ContactJabberImpl)((Object)contact));
                    } else {
                        ((ContactGroupJabberImpl)contactGroup).removeContact((ContactJabberImpl)((Object)contact));
                    }
                    this.fireContactRemoved(contactGroup, (ContactJabberImpl)((Object)contact));
                    continue;
                }
                if (contact == null) {
                    contact = new ContactJabberImpl(item, this, true, true);
                    this.rootGroup.addContact((ContactJabberImpl)((Object)contact));
                    this.fireContactAdded(this.rootGroup, (ContactJabberImpl)((Object)contact));
                } else {
                    ContactGroup contactGroup = ((ContactJabberImpl)((Object)contact)).getParentContactGroup();
                    if (!this.rootGroup.equals(contactGroup)) {
                        this.contactMoved(contactGroup, this.rootGroup, (ContactJabberImpl)((Object)contact));
                    }
                    ((ContactJabberImpl)((Object)contact)).setResolved(item);
                    this.fireContactResolved(this.rootGroup, (ContactJabberImpl)((Object)contact));
                }
                try {
                    this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(item.getJid()));
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Error processing presence", throwable);
                }
            }
        }
        Iterator<Contact> iter = this.rootGroup.contacts();
        ArrayList<Object> contactsToRemove = new ArrayList<Object>();
        while (iter.hasNext()) {
            contact = (ContactJabberImpl)iter.next();
            if (((ContactJabberImpl)((Object)contact)).isResolved()) continue;
            contactsToRemove.add(contact);
        }
        for (ContactJabberImpl contactJabberImpl : contactsToRemove) {
            this.rootGroup.removeContact(contactJabberImpl);
            this.fireContactRemoved(this.rootGroup, contactJabberImpl);
        }
        contactsToRemove.clear();
        for (RosterGroup rosterGroup : this.roster.getGroups()) {
            group = this.findContactGroup(rosterGroup.getName());
            if (group == null) continue;
            group.setResolved(rosterGroup);
            this.fireGroupEvent(group, 4);
        }
        Iterator<ContactGroup> iterGroups = this.rootGroup.subgroups();
        ArrayList<ContactGroupJabberImpl> arrayList = new ArrayList<ContactGroupJabberImpl>();
        while (iterGroups.hasNext()) {
            group = (ContactGroupJabberImpl)iterGroups.next();
            if (!group.isPersistent()) continue;
            if (!group.isResolved()) {
                arrayList.add(group);
            }
            Iterator<Contact> iterContacts = group.contacts();
            while (iterContacts.hasNext()) {
                Object contact3 = (ContactJabberImpl)iterContacts.next();
                if (((ContactJabberImpl)((Object)contact3)).isResolved()) continue;
                contactsToRemove.add(contact3);
            }
            for (ContactJabberImpl contactJabberImpl : contactsToRemove) {
                group.removeContact(contactJabberImpl);
                this.fireContactRemoved(group, contactJabberImpl);
            }
            contactsToRemove.clear();
        }
        for (ContactGroupJabberImpl group3 : arrayList) {
            this.rootGroup.removeSubGroup(group3);
            this.fireGroupEvent(group3, 2);
        }
        for (RosterGroup item : this.roster.getGroups()) {
            ContactGroupJabberImpl group4 = this.findContactGroup(item.getName());
            if (group4 != null) continue;
            ContactGroupJabberImpl contactGroupJabberImpl = new ContactGroupJabberImpl(item, item.getEntries().iterator(), this, true);
            this.rootGroup.addSubGroup(contactGroupJabberImpl);
            this.fireGroupEvent(contactGroupJabberImpl, 1);
            if (this.roster == null) continue;
            Iterator<Contact> cIter = contactGroupJabberImpl.contacts();
            while (cIter.hasNext()) {
                Jid address = ((ContactJabberImpl)cIter.next()).getAddressAsJid();
                this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(address.asBareJid()));
            }
        }
    }

    ContactGroupJabberImpl getNonPersistentGroup() {
        String groupName = JabberActivator.getResources().getI18NString("service.gui.NOT_IN_CONTACT_LIST_GROUP_NAME");
        for (int i = 0; i < this.getRootGroup().countSubgroups(); ++i) {
            ContactGroupJabberImpl gr = (ContactGroupJabberImpl)this.getRootGroup().getGroup(i);
            if (gr.isPersistent() || !gr.getGroupName().equals(groupName)) continue;
            return gr;
        }
        return null;
    }

    void fireContactAdded(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (this.roster != null) {
            this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(contact.getAddressAsJid().asBareJid()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 1);
    }

    void fireContactResolved(ContactGroup parentGroup, ContactJabberImpl contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        if (this.roster != null) {
            this.parentOperationSet.firePresenceStatusChanged(this.roster.getPresence(contact.getAddressAsJid().asBareJid()));
        }
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 4);
    }

    protected void addContactForImageUpdate(ContactJabberImpl contact) {
        if (contact instanceof VolatileContactJabberImpl && ((VolatileContactJabberImpl)contact).isPrivateMessagingContact()) {
            return;
        }
        if (this.imageRetriever == null) {
            this.imageRetriever = new ImageRetriever();
            this.imageRetriever.start();
        }
        this.imageRetriever.addContact(contact);
    }

    static boolean isEntryDisplayable(RosterEntry entry) {
        if (entry.getType() == RosterPacket.ItemType.both || entry.getType() == RosterPacket.ItemType.to) {
            return true;
        }
        return (entry.getType() == RosterPacket.ItemType.none || entry.getType() == RosterPacket.ItemType.from) && entry.isSubscriptionPending() || entry.getGroups().size() > 0;
    }

    private void contactDeleted(ContactJabberImpl contact) {
        ContactGroup group = this.findContactGroup(contact);
        if (group == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Could not find ParentGroup for deleted entry:" + contact.getAddress()));
            }
            return;
        }
        if (group instanceof ContactGroupJabberImpl) {
            ContactGroupJabberImpl groupImpl = (ContactGroupJabberImpl)group;
            groupImpl.removeContact(contact);
            if (groupImpl.countContacts() == 0) {
                this.rootGroup.removeSubGroup(groupImpl);
                this.fireContactRemoved(groupImpl, contact);
                this.fireGroupEvent(groupImpl, 2);
            } else {
                this.fireContactRemoved(groupImpl, contact);
            }
        } else if (group instanceof RootContactGroupJabberImpl) {
            this.rootGroup.removeContact(contact);
            this.fireContactRemoved(this.rootGroup, contact);
        }
    }

    private byte[] searchForCustomAvatar(String address) {
        try {
            ServiceReference[] refs = JabberActivator.bundleContext.getServiceReferences(CustomAvatarService.class.getName(), null);
            if (refs == null) {
                return null;
            }
            for (ServiceReference r : refs) {
                CustomAvatarService avatarService = (CustomAvatarService)JabberActivator.bundleContext.getService(r);
                byte[] res = avatarService.getAvatar(address);
                if (res == null) continue;
                return res;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void contactMoved(ContactGroup oldGroup, ContactGroup newGroup, ContactJabberImpl contact) {
        if (oldGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)oldGroup).removeContact(contact);
        } else if (oldGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)oldGroup).removeContact(contact);
        }
        if (newGroup instanceof ContactGroupJabberImpl) {
            ((ContactGroupJabberImpl)newGroup).addContact(contact);
        } else if (newGroup instanceof RootContactGroupJabberImpl) {
            ((RootContactGroupJabberImpl)newGroup).addContact(contact);
        }
        this.fireContactMoved(oldGroup, newGroup, contact);
        if (oldGroup instanceof ContactGroupJabberImpl && oldGroup.countContacts() == 0) {
            this.rootGroup.removeSubGroup((ContactGroupJabberImpl)oldGroup);
            this.fireGroupEvent((ContactGroupJabberImpl)oldGroup, 2);
        }
    }

    private EntityBareJid parseAddressString(String id) throws OperationFailedException {
        try {
            Jid temp = JidCreate.from((String)id);
            if (!temp.hasLocalpart()) {
                AccountID accountID = this.jabberProvider.getAccountID();
                Jid accountJid = JidCreate.from((String)accountID.getUserID());
                return JidCreate.entityBareFrom((Localpart)Localpart.from((String)id), (Domainpart)accountJid.getDomain());
            }
            return temp.asEntityBareJidOrThrow();
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException("Could not parse id", 0, (Throwable)e);
        }
    }

    public List<Presence> getPresences(BareJid user) {
        return this.roster.getPresences(user);
    }

    boolean isRosterInitialized() {
        return this.isRosterInitialized;
    }

    Object getRosterInitLock() {
        return this.rosterInitLock;
    }

    void setInitialStatus(PresenceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    void setInitialStatusMessage(String initialStatusMessage) {
        this.initialStatusMessage = initialStatusMessage;
    }

    private class ImageRetriever
    extends Thread {
        private final List<ContactJabberImpl> contactsForUpdate = new Vector<ContactJabberImpl>();
        private boolean running = false;

        ImageRetriever() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vector<ContactJabberImpl> copyContactsForUpdate = null;
                this.running = true;
                while (this.running) {
                    List<ContactJabberImpl> list = this.contactsForUpdate;
                    synchronized (list) {
                        if (this.contactsForUpdate.isEmpty()) {
                            this.contactsForUpdate.wait();
                        }
                        if (!this.running) {
                            return;
                        }
                        copyContactsForUpdate = new Vector<ContactJabberImpl>(this.contactsForUpdate);
                        this.contactsForUpdate.clear();
                    }
                    for (ContactJabberImpl contact : copyContactsForUpdate) {
                        byte[] imgBytes = this.getAvatar(contact);
                        if (imgBytes != null) {
                            byte[] oldImage = contact.getImage(false);
                            contact.setImage(imgBytes);
                            ServerStoredContactListJabberImpl.this.parentOperationSet.fireContactPropertyChangeEvent("Image", (Contact)contact, oldImage, imgBytes);
                            continue;
                        }
                        contact.setImage(new byte[0]);
                    }
                }
            }
            catch (InterruptedException ex) {
                logger.error((Object)"ImageRetriever error waiting will stop now!", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addContact(ContactJabberImpl contact) {
            List<ContactJabberImpl> list = this.contactsForUpdate;
            synchronized (list) {
                if (!this.contactsForUpdate.contains((Object)contact)) {
                    this.contactsForUpdate.add(contact);
                    this.contactsForUpdate.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            List<ContactJabberImpl> list = this.contactsForUpdate;
            synchronized (list) {
                this.running = false;
                this.contactsForUpdate.notifyAll();
            }
        }

        private byte[] getAvatar(ContactJabberImpl contact) {
            if (ServerStoredContactListJabberImpl.this.infoRetreiver == null) {
                return null;
            }
            byte[] result = null;
            try {
                Iterator<ServerStoredDetails.GenericDetail> iter = ServerStoredContactListJabberImpl.this.infoRetreiver.getDetails(contact.getAddressAsJid().asEntityBareJidOrThrow(), ServerStoredDetails.ImageDetail.class);
                if (iter.hasNext()) {
                    ServerStoredDetails.ImageDetail imgDetail = (ServerStoredDetails.ImageDetail)iter.next();
                    result = imgDetail.getBytes();
                }
                if (result == null) {
                    result = ServerStoredContactListJabberImpl.this.searchForCustomAvatar(contact.getAddress());
                }
                return result;
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cannot load image for contact " + (Object)((Object)contact) + ": " + ex.getMessage()), (Throwable)ex);
                }
                if ((result = ServerStoredContactListJabberImpl.this.searchForCustomAvatar(contact.getAddress())) == null) {
                    result = new byte[]{};
                }
                return result;
            }
        }
    }

    private class ChangeListener
    implements RosterListener {
        private ChangeListener() {
        }

        public void entriesAdded(Collection<Jid> addresses) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("entriesAdded " + addresses));
            }
            for (Jid id : addresses) {
                this.addEntryToContactList(id);
            }
        }

        private ContactJabberImpl addEntryToContactList(Jid rosterEntryID) {
            RosterEntry entry = ServerStoredContactListJabberImpl.this.roster.getEntry(rosterEntryID.asBareJid());
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(entry)) {
                return null;
            }
            ContactJabberImpl contact = ServerStoredContactListJabberImpl.this.findContactById((Jid)entry.getJid());
            if (contact == null) {
                contact = this.findPrivateContactByRealId((Jid)entry.getJid());
            }
            if (contact != null) {
                if (contact.isPersistent()) {
                    contact.setResolved(entry);
                    return contact;
                }
                if (contact instanceof VolatileContactJabberImpl) {
                    ContactGroup oldParentGroup = contact.getParentContactGroup();
                    if (oldParentGroup instanceof ContactGroupJabberImpl && !oldParentGroup.isPersistent()) {
                        ((ContactGroupJabberImpl)oldParentGroup).removeContact(contact);
                        ServerStoredContactListJabberImpl.this.fireContactRemoved(oldParentGroup, contact);
                    }
                } else {
                    return contact;
                }
            }
            contact = new ContactJabberImpl(entry, ServerStoredContactListJabberImpl.this, true, true);
            if (entry.getGroups() == null || entry.getGroups().size() == 0) {
                ServerStoredContactListJabberImpl.this.rootGroup.addContact(contact);
                ServerStoredContactListJabberImpl.this.fireContactAdded(ServerStoredContactListJabberImpl.this.rootGroup, contact);
                return contact;
            }
            Iterator iterator = entry.getGroups().iterator();
            if (iterator.hasNext()) {
                RosterGroup group = (RosterGroup)iterator.next();
                ContactGroupJabberImpl parentGroup = ServerStoredContactListJabberImpl.this.findContactGroup(group.getName());
                if (parentGroup != null) {
                    parentGroup.addContact(contact);
                    ServerStoredContactListJabberImpl.this.fireContactAdded(ServerStoredContactListJabberImpl.this.findContactGroup(contact), contact);
                } else {
                    ContactGroupJabberImpl newGroup = new ContactGroupJabberImpl(group, group.getEntries().iterator(), ServerStoredContactListJabberImpl.this, true);
                    ServerStoredContactListJabberImpl.this.rootGroup.addSubGroup(newGroup);
                    ServerStoredContactListJabberImpl.this.fireGroupEvent(newGroup, 1);
                }
                return contact;
            }
            return contact;
        }

        private ContactJabberImpl findPrivateContactByRealId(Jid id) {
            ContactGroupJabberImpl volatileGroup = ServerStoredContactListJabberImpl.this.getNonPersistentGroup();
            if (volatileGroup == null) {
                return null;
            }
            Iterator<Contact> it = volatileGroup.contacts();
            while (it.hasNext()) {
                Contact contact = it.next();
                if (contact.getPersistableAddress() == null || !contact.getPersistableAddress().equals(id.asBareJid().toString())) continue;
                return (ContactJabberImpl)contact;
            }
            return null;
        }

        public void entriesUpdated(Collection<Jid> addresses) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("entriesUpdated  " + addresses));
            }
            for (Jid contactID : addresses) {
                RosterEntry entry = ServerStoredContactListJabberImpl.this.roster.getEntry(contactID.asBareJid());
                ContactJabberImpl contact = this.addEntryToContactList(contactID);
                if (contact == null) continue;
                if (entry.getGroups().size() == 0) {
                    this.checkForRename(entry.getName(), contact);
                    ContactGroup contactGroup = contact.getParentContactGroup();
                    if (!ServerStoredContactListJabberImpl.this.rootGroup.equals(contactGroup)) {
                        ServerStoredContactListJabberImpl.this.contactMoved(contactGroup, ServerStoredContactListJabberImpl.this.rootGroup, contact);
                    }
                }
                for (RosterGroup gr : entry.getGroups()) {
                    ContactGroupJabberImpl cgr = ServerStoredContactListJabberImpl.this.findContactGroup(gr.getName());
                    if (cgr == null) {
                        ContactGroupJabberImpl group = ServerStoredContactListJabberImpl.this.findContactGroupByNameCopy(gr.getName());
                        if (group != null) {
                            group.setSourceGroup(gr);
                            ServerStoredContactListJabberImpl.this.fireGroupEvent(group, 3);
                        } else {
                            ContactGroup currentParentGroup = contact.getParentContactGroup();
                            if (currentParentGroup.countContacts() > 1) {
                                cgr = currentParentGroup;
                            } else {
                                boolean present = false;
                                for (RosterGroup entryGr : entry.getGroups()) {
                                    if (!entryGr.getName().equals(currentParentGroup.getGroupName())) continue;
                                    present = true;
                                    break;
                                }
                                if (!present && currentParentGroup instanceof ContactGroupJabberImpl) {
                                    ContactGroupJabberImpl currentGroup = (ContactGroupJabberImpl)currentParentGroup;
                                    currentGroup.setSourceGroup(gr);
                                    ServerStoredContactListJabberImpl.this.fireGroupEvent(currentGroup, 3);
                                }
                            }
                        }
                    }
                    if (cgr == null) continue;
                    ContactGroup contactGroup = contact.getParentContactGroup();
                    if (!gr.getName().equals(contactGroup.getGroupName())) {
                        ContactGroupJabberImpl newParentGroup = ServerStoredContactListJabberImpl.this.findContactGroup(gr.getName());
                        if (newParentGroup == null) {
                            newParentGroup = new ContactGroupJabberImpl(gr, new ArrayList().iterator(), ServerStoredContactListJabberImpl.this, true);
                            ServerStoredContactListJabberImpl.this.rootGroup.addSubGroup(newParentGroup);
                            ServerStoredContactListJabberImpl.this.fireGroupEvent(newParentGroup, 1);
                        }
                        ServerStoredContactListJabberImpl.this.contactMoved(contactGroup, newParentGroup, contact);
                        continue;
                    }
                    this.checkForRename(entry.getName(), contact);
                }
            }
        }

        private void checkForRename(String newValue, ContactJabberImpl contact) {
            if (newValue != null && !newValue.equals(contact.getServerDisplayName())) {
                String oldValue = contact.getServerDisplayName();
                contact.setServerDisplayName(newValue);
                ServerStoredContactListJabberImpl.this.parentOperationSet.fireContactPropertyChangeEvent("DisplayName", (Contact)contact, oldValue, newValue);
            }
        }

        public void entriesDeleted(Collection<Jid> addresses) {
            for (Jid address : addresses) {
                ContactJabberImpl contact;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("entry deleted " + address));
                }
                if ((contact = ServerStoredContactListJabberImpl.this.findContactById(address)) == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Could not find contact for deleted entry:" + address));
                    continue;
                }
                ServerStoredContactListJabberImpl.this.contactDeleted(contact);
            }
        }

        public void presenceChanged(Presence presence) {
        }
    }
}

