/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetContactCapabilitiesJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.caps.CapsConfigurationPersistence;
import net.java.sip.communicator.impl.protocol.jabber.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jxmpp.jid.Jid;

public class ScServiceDiscoveryManager
implements StanzaListener {
    private static final Logger logger = Logger.getLogger(ScServiceDiscoveryManager.class);
    private final boolean cacheNonCaps;
    private final Map<Jid, DiscoverInfo> nonCapsCache = new ConcurrentHashMap<Jid, DiscoverInfo>();
    private EntityCapsManager capsManager;
    private ServiceDiscoveryManager discoveryManager;
    private final ProtocolProviderService parentProvider;
    private DiscoveryInfoRetriever retriever = new DiscoveryInfoRetriever();
    private final Map<Jid, String> userCaps = new ConcurrentHashMap<Jid, String>();
    private final List<UserCapsNodeListener> userCapsNodeListeners = new LinkedList<UserCapsNodeListener>();
    private static final UserCapsNodeListener[] NO_USER_CAPS_NODE_LISTENERS = new UserCapsNodeListener[0];
    private static String entityNode = OSUtils.IS_ANDROID ? "http://android.jitsi.org" : "http://jitsi.org";

    public static void initIdentity() {
        String name = System.getProperty("sip-communicator.application.name", "Jitsi ") + System.getProperty("sip-communicator.version", "SVN");
        ServiceDiscoveryManager.setDefaultIdentity((DiscoverInfo.Identity)new DiscoverInfo.Identity("client", name, "pc"));
        EntityCapsManager.setDefaultEntityNode((String)entityNode);
    }

    public ScServiceDiscoveryManager(ProtocolProviderService parentProvider, ConfigurationService configService, XMPPConnection connection, String[] featuresToRemove, String[] featuresToAdd, boolean cacheNonCaps) {
        this.parentProvider = parentProvider;
        this.discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        this.cacheNonCaps = cacheNonCaps;
        if (featuresToRemove != null) {
            for (String featureToRemove : featuresToRemove) {
                this.discoveryManager.removeFeature(featureToRemove);
            }
        }
        if (featuresToAdd != null) {
            for (String featureToAdd : featuresToAdd) {
                if (this.discoveryManager.includesFeature(featureToAdd)) continue;
                this.discoveryManager.addFeature(featureToAdd);
            }
        }
        this.capsManager = EntityCapsManager.getInstanceFor((XMPPConnection)connection);
        this.capsManager.setEntityNode(entityNode);
        EntityCapsManager.setPersistentCache((EntityCapsPersistentCache)new CapsConfigurationPersistence(configService));
        connection.addAsyncStanzaListener((StanzaListener)this, (StanzaFilter)new StanzaTypeFilter(Presence.class));
    }

    public void addFeature(String feature) {
        this.discoveryManager.addFeature(feature);
    }

    public List<String> getFeatures() {
        return this.discoveryManager.getFeatures();
    }

    public boolean includesFeature(String feature) {
        return this.discoveryManager.includesFeature(feature);
    }

    public void removeFeature(String feature) {
        this.discoveryManager.removeFeature(feature);
    }

    public void processStanza(Stanza packet) {
        boolean online = packet instanceof Presence && ((Presence)packet).isAvailable();
        CapsExtension ext = (CapsExtension)packet.getExtension("c", "http://jabber.org/protocol/caps");
        if (ext != null && online) {
            this.addUserCapsNode(packet.getFrom(), ext.getNode(), ext.getVer());
        } else if (!online) {
            this.removeUserCapsNode(packet.getFrom());
        }
    }

    public DiscoverInfo discoverInfo(Jid entityID) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.discoverInfo(entityID, null, null);
    }

    private DiscoverInfo discoverInfo(Jid entityID, EntityCapsManager.NodeVerHash caps, OperationSetContactCapabilitiesJabberImpl capabilitiesOpSet) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        DiscoverInfo discoverInfo = this.discoveryManager.discoverInfo(entityID, caps == null ? null : caps.getNodeVer());
        if (caps != null && discoverInfo != null && !EntityCapsManager.verifyDiscoverInfoVersion((String)caps.getVer(), (String)caps.getHash(), (DiscoverInfo)discoverInfo)) {
            if (!caps.getHash().equals("")) {
                logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
            }
            caps = null;
        }
        boolean fireEvent = false;
        if (caps == null) {
            if (this.cacheNonCaps) {
                this.nonCapsCache.put(entityID, discoverInfo);
                fireEvent = true;
            }
        } else {
            fireEvent = true;
        }
        if (fireEvent && capabilitiesOpSet != null) {
            capabilitiesOpSet.fireContactCapabilitiesChanged(entityID.asBareJid(), this.getFullJidsByBareJid((Jid)entityID.asBareJid()));
        }
        return discoverInfo;
    }

    public DiscoverInfo discoverInfoNonBlocking(Jid entityID) {
        DiscoverInfo discoverInfo = EntityCapsManager.getDiscoverInfoByUser((Jid)entityID);
        EntityCapsManager.NodeVerHash caps = EntityCapsManager.getNodeVerHashByJid((Jid)entityID);
        boolean isInfoValid = false;
        if (discoverInfo != null && caps != null) {
            isInfoValid = EntityCapsManager.verifyDiscoverInfoVersion((String)caps.getVer(), (String)caps.getHash(), (DiscoverInfo)discoverInfo);
        }
        if (discoverInfo != null && isInfoValid) {
            return discoverInfo;
        }
        if (this.cacheNonCaps && (discoverInfo = this.nonCapsCache.get(entityID)) != null) {
            return discoverInfo;
        }
        this.retriever.addEntityForRetrieve(entityID, caps);
        return null;
    }

    public DiscoverItems discoverItems(Jid entityID) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.discoveryManager.discoverItems(entityID);
    }

    public boolean supportsFeature(Jid jid, String feature) {
        DiscoverInfo info;
        try {
            info = this.discoverInfo(jid);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            logger.info((Object)("failed to retrieve disco info for " + jid + " feature " + feature), ex);
            return false;
        }
        return info != null && info.containsFeature((CharSequence)feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<UserCapsNodeListener> list = this.userCapsNodeListeners;
        synchronized (list) {
            if (!this.userCapsNodeListeners.contains(listener)) {
                this.userCapsNodeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener != null) {
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                this.userCapsNodeListeners.remove(listener);
            }
        }
    }

    public List<Jid> getFullJidsByBareJid(Jid bareJid) {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        for (Jid jid : this.userCaps.keySet()) {
            if (!bareJid.equals((CharSequence)jid.asBareJid())) continue;
            jids.add(jid);
        }
        return jids;
    }

    private void addUserCapsNode(Jid user, String node, String ver) {
        if (user != null && node != null && ver != null) {
            String nodeVer = this.userCaps.get(user);
            if (nodeVer != null && nodeVer.equals(node + "#" + ver)) {
                return;
            }
            nodeVer = node + "#" + ver;
            this.userCaps.put(user, nodeVer);
            this.fireUserCapsNodeEvent(true, user, nodeVer);
        }
    }

    public EntityCapsManager.NodeVerHash getCapsByUser(Jid user) {
        return EntityCapsManager.getNodeVerHashByJid((Jid)user);
    }

    public void removeUserCapsNode(Jid user) {
        if (user == null) {
            return;
        }
        String nodeVer = this.userCaps.remove(user);
        if (nodeVer != null) {
            this.fireUserCapsNodeEvent(false, user, nodeVer);
        }
    }

    public void removeContactCapsNode(Contact contact) {
        String nodeVer = null;
        Jid lastRemovedJid = null;
        Iterator<Jid> iter = this.userCaps.keySet().iterator();
        while (iter.hasNext()) {
            Jid jid = iter.next();
            if (!jid.equals(contact.getAddress())) continue;
            nodeVer = this.userCaps.get(jid);
            lastRemovedJid = jid;
            iter.remove();
        }
        EntityCapsManager.removeUserCapsNode((String)contact.getAddress());
        if (nodeVer != null) {
            this.fireUserCapsNodeEvent(false, lastRemovedJid, nodeVer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserCapsNodeEvent(boolean add, Jid user, String nodeVer) {
        UserCapsNodeListener[] userCapsNodeListenerArray = this.userCapsNodeListeners;
        synchronized (this.userCapsNodeListeners) {
            UserCapsNodeListener[] listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (listeners.length != 0) {
                for (UserCapsNodeListener listener : listeners) {
                    if (add) {
                        listener.userCapsNodeAdded(user, this.getFullJidsByBareJid((Jid)user.asBareJid()), nodeVer, true);
                        continue;
                    }
                    listener.userCapsNodeRemoved(user, this.getFullJidsByBareJid((Jid)user.asBareJid()), nodeVer, false);
                }
            }
            return;
        }
    }

    public void stop() {
        if (this.retriever != null) {
            this.retriever.stop();
        }
        this.discoveryManager.removeNodeInformationProvider(this.capsManager.getLocalNodeVer());
        this.capsManager = null;
        this.discoveryManager = null;
    }

    private class DiscoveryInfoRetriever
    implements Runnable {
        private boolean stopped = true;
        private Thread retrieverThread = null;
        private final Map<Jid, EntityCapsManager.NodeVerHash> entities = new HashMap<Jid, EntityCapsManager.NodeVerHash>();
        private OperationSetContactCapabilitiesJabberImpl capabilitiesOpSet;

        private DiscoveryInfoRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.stopped = false;
                while (!this.stopped) {
                    Map.Entry<Jid, EntityCapsManager.NodeVerHash> entityToProcess = null;
                    Map<Jid, EntityCapsManager.NodeVerHash> map = this.entities;
                    synchronized (map) {
                        Iterator<Map.Entry<Jid, EntityCapsManager.NodeVerHash>> iter;
                        if (this.entities.size() == 0) {
                            try {
                                this.entities.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if ((iter = this.entities.entrySet().iterator()).hasNext()) {
                            entityToProcess = iter.next();
                            iter.remove();
                        }
                    }
                    if (entityToProcess == null) continue;
                    try {
                        ScServiceDiscoveryManager.this.discoverInfo(entityToProcess.getKey(), entityToProcess.getValue(), this.capabilitiesOpSet);
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.error((Object)("Error requesting discover info for " + entityToProcess.getKey()), ex);
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error requesting discovery info, thread ended unexpectedly", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntityForRetrieve(Jid entityID, EntityCapsManager.NodeVerHash caps) {
            Map<Jid, EntityCapsManager.NodeVerHash> map = this.entities;
            synchronized (map) {
                if (!this.entities.containsKey(entityID)) {
                    this.entities.put(entityID, caps);
                    this.entities.notifyAll();
                    if (this.retrieverThread == null) {
                        this.start();
                    }
                }
            }
        }

        private void start() {
            this.capabilitiesOpSet = (OperationSetContactCapabilitiesJabberImpl)ScServiceDiscoveryManager.this.parentProvider.getOperationSet(OperationSetContactCapabilities.class);
            this.retrieverThread = new Thread((Runnable)this, ScServiceDiscoveryManager.class.getName());
            this.retrieverThread.setDaemon(true);
            this.retrieverThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Map<Jid, EntityCapsManager.NodeVerHash> map = this.entities;
            synchronized (map) {
                this.stopped = true;
                this.entities.notifyAll();
                this.retrieverThread = null;
            }
        }
    }
}

