/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.IncomingFileTransferRequestJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OutgoingFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractFileTransfer;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.xmpp.extensions.thumbnail.Thumbnail;
import org.jitsi.xmpp.extensions.thumbnail.ThumbnailFile;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetFileTransferJabberImpl
implements OperationSetFileTransfer {
    private static final Logger logger = Logger.getLogger(OperationSetFileTransferJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private final Vector<FileTransferListener> fileTransferListeners = new Vector();

    public OperationSetFileTransferJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
    }

    public FileTransfer sendFile(Contact toContact, File file) throws IllegalStateException, IllegalArgumentException, OperationNotSupportedException {
        OutgoingFileTransferJabberImpl outgoingTransfer;
        try {
            this.assertConnected();
            if (file.length() > this.getMaximumFileLength()) {
                throw new IllegalArgumentException("File length exceeds the allowed one for this protocol");
            }
            EntityFullJid fullJid = null;
            OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)this.jabberProvider.getOperationSet(OperationSetMultiUserChat.class);
            if (mucOpSet != null && mucOpSet.isPrivateMessagingContact(toContact.getAddress())) {
                fullJid = JidCreate.entityFullFrom((String)toContact.getAddress());
            } else {
                Jid jid = JidCreate.from((String)toContact.getAddress());
                Roster r = Roster.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection());
                int bestPriority = -1;
                PresenceStatus jabberStatus = null;
                for (Presence presence : r.getPresences(jid.asBareJid())) {
                    PresenceStatus tempStatus;
                    int priority;
                    if (!this.jabberProvider.isFeatureListSupported(presence.getFrom(), "http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer")) continue;
                    int n = priority = presence.getPriority() == Integer.MIN_VALUE ? 0 : presence.getPriority();
                    if (priority > bestPriority) {
                        bestPriority = priority;
                        fullJid = presence.getFrom().asEntityFullJidIfPossible();
                        jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.jabberProvider);
                        continue;
                    }
                    if (priority != bestPriority || jabberStatus == null || (tempStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.jabberProvider)).compareTo(jabberStatus) <= 0) continue;
                    fullJid = presence.getFrom().asEntityFullJidIfPossible();
                    jabberStatus = tempStatus;
                }
            }
            if (fullJid == null) {
                throw new OperationNotSupportedException("Contact client or server does not support file transfers.");
            }
            FileTransferManager manager = FileTransferManager.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection());
            OutgoingFileTransfer transfer = manager.createOutgoingFileTransfer(fullJid);
            outgoingTransfer = new OutgoingFileTransferJabberImpl(toContact, file, transfer, this.jabberProvider);
            FileTransferCreatedEvent event = new FileTransferCreatedEvent((FileTransfer)outgoingTransfer, new Date());
            this.fireFileTransferCreated(event);
            transfer.sendFile(file, "Sending file");
            new FileTransferProgressThread((org.jivesoftware.smackx.filetransfer.FileTransfer)transfer, outgoingTransfer).start();
        }
        catch (SmackException | XmppStringprepException e) {
            logger.error((Object)"Failed to send file.", e);
            throw new OperationNotSupportedException("Could not start file transfer", (Exception)e);
        }
        return outgoingTransfer;
    }

    public FileTransfer sendFile(Contact toContact, Contact fromContact, String remotePath, String localPath) throws IllegalStateException, IllegalArgumentException, OperationNotSupportedException {
        return this.sendFile(toContact, new File(localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            if (!this.fileTransferListeners.contains(listener)) {
                this.fileTransferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            this.fileTransferListeners.remove(listener);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.jabberProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to send a file.");
        }
        if (!this.jabberProvider.isRegistered()) {
            if (this.opSetPersPresence.getPresenceStatus().isOnline()) {
                this.opSetPersPresence.fireProviderStatusChangeEvent(this.opSetPersPresence.getPresenceStatus(), (PresenceStatus)this.jabberProvider.getJabberStatusEnum().getStatus("Offline"));
            }
            throw new IllegalStateException("The provider must be signed on the service before being able to send a file.");
        }
    }

    public long getMaximumFileLength() {
        return 0x80000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequest(IncomingFileTransferRequestJabberImpl request) {
        Iterator<FileTransferListener> listeners;
        FileTransferRequestEvent event = new FileTransferRequestEvent((OperationSetFileTransfer)this, (IncomingFileTransferRequest)request, new Date());
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequestRejected(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestRejected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferCreated(FileTransferCreatedEvent event) {
        Iterator<FileTransferListener> listeners;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferCreated(event);
        }
    }

    private static int parseJabberStatus(FileTransfer.Status jabberStatus) {
        if (jabberStatus.equals((Object)FileTransfer.Status.complete)) {
            return 0;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.cancelled)) {
            return 1;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.in_progress) || jabberStatus.equals((Object)FileTransfer.Status.negotiated)) {
            return 4;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.error)) {
            return 2;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.refused)) {
            return 3;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.negotiating_transfer) || jabberStatus.equals((Object)FileTransfer.Status.negotiating_stream)) {
            return 6;
        }
        return 5;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                FileTransferNegotiator.getInstanceFor((XMPPConnection)connection);
            }
        });
    }

    protected static class FileTransferProgressThread
    extends Thread {
        private final org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer;
        private final AbstractFileTransfer fileTransfer;
        private long initialFileSize;

        public FileTransferProgressThread(org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer, AbstractFileTransfer transfer, long initialFileSize) {
            this.jabberTransfer = jabberTransfer;
            this.fileTransfer = transfer;
            this.initialFileSize = initialFileSize;
        }

        public FileTransferProgressThread(org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer, AbstractFileTransfer transfer) {
            this.jabberTransfer = jabberTransfer;
            this.fileTransfer = transfer;
        }

        @Override
        public void run() {
            long progress;
            int status;
            String statusReason = "";
            block2: while (true) {
                try {
                    while (true) {
                        Thread.sleep(10L);
                        status = OperationSetFileTransferJabberImpl.parseJabberStatus(this.jabberTransfer.getStatus());
                        progress = this.fileTransfer.getTransferedBytes();
                        if (status == 2 || status == 0 || status == 1 || status == 3) {
                            if (this.fileTransfer instanceof OutgoingFileTransferJabberImpl) {
                                ((OutgoingFileTransferJabberImpl)this.fileTransfer).removeThumbnailHandler();
                            }
                            if (status != 0 || this.fileTransfer.getStatus() != 6) break block2;
                            this.fileTransfer.fireStatusChangeEvent(4, "Status changed");
                            this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
                            break block2;
                        }
                        this.fileTransfer.fireStatusChangeEvent(status, "Status changed");
                        this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Unable to sleep thread.", (Throwable)e);
                    continue;
                }
                break;
            }
            if (this.jabberTransfer.getError() != null) {
                logger.error((Object)("An error occured while transfering file: " + this.jabberTransfer.getError().getMessage()));
            }
            if (this.jabberTransfer.getException() != null) {
                XMPPError error;
                logger.error((Object)"An exception occured while transfering file: ", (Throwable)this.jabberTransfer.getException());
                if (this.jabberTransfer.getException() instanceof XMPPException.XMPPErrorException && (error = ((XMPPException.XMPPErrorException)((Object)this.jabberTransfer.getException())).getXMPPError()) != null && (error.getCondition() == XMPPError.Condition.not_acceptable || error.getCondition() == XMPPError.Condition.forbidden)) {
                    status = 3;
                }
                statusReason = this.jabberTransfer.getException().getMessage();
            }
            if (this.initialFileSize > 0L && status == 0 && this.fileTransfer.getTransferedBytes() < this.initialFileSize) {
                status = 1;
            }
            this.fileTransfer.fireStatusChangeEvent(status, statusReason);
            this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
        }
    }

    private class FileTransferRequestListener
    implements org.jivesoftware.smackx.filetransfer.FileTransferListener {
        private FileTransferRequestListener() {
        }

        private StreamInitiation getStreamInitiation(FileTransferRequest request) {
            try {
                Method gsi = request.getClass().getDeclaredMethod("getStreamInitiation", new Class[0]);
                gsi.setAccessible(true);
                return (StreamInitiation)gsi.invoke((Object)request, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)"Cannot invoke getStreamInitiation", (Throwable)e);
                return null;
            }
        }

        public void fileTransferRequest(FileTransferRequest request) {
            Thumbnail thumbnail;
            StreamInitiation.File file;
            logger.info((Object)"Incoming XMPP file transfer request");
            IncomingFileTransferRequestJabberImpl incomingFileTransferRequest = new IncomingFileTransferRequestJabberImpl(OperationSetFileTransferJabberImpl.this.jabberProvider, OperationSetFileTransferJabberImpl.this, request);
            boolean isThumbnailedFile = false;
            StreamInitiation si = this.getStreamInitiation(request);
            if (si != null && (file = si.getFile()) instanceof ThumbnailFile && (thumbnail = ((ThumbnailFile)file).getThumbnail()) != null) {
                isThumbnailedFile = true;
                incomingFileTransferRequest.fetchThumbnailAndNotify(thumbnail.getCid());
            }
            if (!isThumbnailedFile) {
                OperationSetFileTransferJabberImpl.this.fireFileTransferRequest(incomingFileTransferRequest);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() != RegistrationState.REGISTERED) {
                return;
            }
            OperationSetFileTransferJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)OperationSetFileTransferJabberImpl.this.jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
            FileTransferManager.getInstanceFor((XMPPConnection)OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection()).addFileTransferListener((org.jivesoftware.smackx.filetransfer.FileTransferListener)new FileTransferRequestListener());
        }
    }
}

