/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetChangePassword;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class OperationSetChangePasswordJabberImpl
implements OperationSetChangePassword {
    private ProtocolProviderServiceJabberImpl protocolProvider;
    private static final Logger logger = Logger.getLogger(OperationSetChangePasswordJabberImpl.class);

    OperationSetChangePasswordJabberImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public void changePassword(String newPass) throws IllegalStateException, OperationFailedException {
        AccountManager accountManager = AccountManager.getInstance((XMPPConnection)this.protocolProvider.getConnection());
        try {
            accountManager.changePassword(newPass);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Tried to change jabber password, but the server does not support inband password changes", e);
            }
            throw new OperationFailedException("In-band password changes not supported", 18, e);
        }
    }

    public boolean supportsPasswordChange() {
        try {
            Jid service = JidCreate.from((String)this.protocolProvider.getAccountID().getService());
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(service);
            return discoverInfo.containsFeature((CharSequence)"jabber:iq:register");
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Exception occurred while trying to find out if inband registrations are supported. Returning trueanyway.");
            }
            return true;
        }
    }
}

