/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomConfigurationFormFieldJabberImpl;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationFormField;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;

public class ChatRoomConfigurationFormJabberImpl
implements ChatRoomConfigurationForm {
    private Logger logger = Logger.getLogger(ChatRoomConfigurationFormJabberImpl.class);
    protected Form smackConfigForm;
    protected Form smackSubmitForm;
    private MultiUserChat smackMultiUserChat;

    public ChatRoomConfigurationFormJabberImpl(MultiUserChat multiUserChat, Form smackConfigForm) {
        this.smackMultiUserChat = multiUserChat;
        this.smackConfigForm = smackConfigForm;
        this.smackSubmitForm = smackConfigForm.createAnswerForm();
    }

    public Iterator<ChatRoomConfigurationFormField> getConfigurationSet() {
        Vector<ChatRoomConfigurationFormFieldJabberImpl> configFormFields = new Vector<ChatRoomConfigurationFormFieldJabberImpl>();
        for (FormField smackFormField : this.smackConfigForm.getFields()) {
            if (smackFormField == null || smackFormField.getType().equals((Object)FormField.Type.hidden)) continue;
            ChatRoomConfigurationFormFieldJabberImpl jabberConfigField = new ChatRoomConfigurationFormFieldJabberImpl(smackFormField, this.smackSubmitForm);
            configFormFields.add(jabberConfigField);
        }
        return Collections.unmodifiableList(configFormFields).iterator();
    }

    public void submit() throws OperationFailedException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Sends chat room configuration form to the server.");
        }
        try {
            this.smackMultiUserChat.sendConfigurationForm(this.smackSubmitForm);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
            this.logger.error((Object)"Failed to submit the configuration form.", e);
            throw new OperationFailedException("Failed to submit the configuration form.", 1);
        }
    }
}

