/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.AbstractConferenceMember;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CoinPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JinglePacketFactory;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoType;
import org.jitsi.xmpp.extensions.jingle.TransferPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferredPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.MediaPresenceExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.Jid;

public class CallPeerJabberImpl
extends MediaAwareCallPeer<CallJabberImpl, CallPeerMediaHandlerJabberImpl, ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(CallPeerJabberImpl.class);
    private boolean cancelled = false;
    private final Object candSyncRoot = new Object();
    private boolean contentAddWithNoCands = false;
    private boolean sessionInitiateProcessed = false;
    private final Object sessionInitiateSyncRoot = new Object();
    private final Object sidSyncRoot = new Object();
    private ContentPacketExtension.SendersEnum audioSenders = ContentPacketExtension.SendersEnum.none;
    private ContentPacketExtension.SendersEnum videoSenders = ContentPacketExtension.SendersEnum.none;
    private DiscoverInfo discoverInfo;
    private boolean initiator = false;
    private Jid peerJID;
    private JingleIQ sessionInitIQ;

    public CallPeerJabberImpl(Jid peerAddress, CallJabberImpl owningCall) {
        super((MediaAwareCall)owningCall);
        this.peerJID = peerAddress;
        this.setMediaHandler(new CallPeerMediaHandlerJabberImpl(this));
    }

    public CallPeerJabberImpl(Jid peerAddress, CallJabberImpl owningCall, JingleIQ sessionIQ) {
        this(peerAddress, owningCall);
        this.sessionInitIQ = sessionIQ;
    }

    public synchronized void answer() throws OperationFailedException {
        Iterable<ContentPacketExtension> answer;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            answer = mediaHandler.generateSessionAccept();
            for (ContentPacketExtension c : answer) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception exc) {
            logger.info((Object)"Failed to answer an incoming call", (Throwable)exc);
            String reasonText = "Error: " + exc.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)this.sessionInitIQ.getTo(), (Jid)this.sessionInitIQ.getFrom(), (String)this.sessionInitIQ.getSID(), (Reason)Reason.FAILED_APPLICATION, (String)reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            try {
                ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new OperationFailedException("Could not send session terminate after failing to answer a call", 0, e);
            }
            return;
        }
        JingleIQ response = JinglePacketFactory.createSessionAccept((Jid)this.sessionInitIQ.getTo(), (Jid)this.sessionInitIQ.getFrom(), (String)this.getSID(), answer);
        try {
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)response);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send session accept", 0, e);
        }
        try {
            mediaHandler.start();
        }
        catch (UndeclaredThrowableException e) {
            Throwable exc = e.getUndeclaredThrowable();
            logger.info((Object)"Failed to establish a connection", exc);
            String reasonText = "Error: " + exc.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)this.sessionInitIQ.getTo(), (Jid)this.sessionInitIQ.getFrom(), (String)this.sessionInitIQ.getSID(), (Reason)Reason.GENERAL_ERROR, (String)reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            try {
                ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            }
            catch (InterruptedException | SmackException.NotConnectedException e1) {
                throw new OperationFailedException("Could not send session terminate after failing to start media handler", 0, (Throwable)e);
            }
            return;
        }
        this.setState(CallPeerState.CONNECTED);
    }

    public String getSID() {
        return this.sessionInitIQ != null ? this.sessionInitIQ.getSID() : null;
    }

    public JingleIQ getSessionIQ() {
        return this.sessionInitIQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hangup(boolean failed, String reasonText, ExtensionElement reasonOtherExtension) throws SmackException.NotConnectedException, InterruptedException {
        CallPeerState prevPeerState = this.getState();
        if (CallPeerState.DISCONNECTED.equals(prevPeerState) || CallPeerState.FAILED.equals(prevPeerState)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignoring a request to hangup a call peer that is already DISCONNECTED");
            }
            return;
        }
        this.setState(failed ? CallPeerState.FAILED : CallPeerState.DISCONNECTED, reasonText);
        JingleIQ responseIQ = null;
        if (prevPeerState.equals(CallPeerState.CONNECTED) || CallPeerState.isOnHold((CallPeerState)prevPeerState)) {
            responseIQ = JinglePacketFactory.createBye((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID());
        } else if (CallPeerState.CONNECTING.equals(prevPeerState) || CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(prevPeerState) || CallPeerState.ALERTING_REMOTE_SIDE.equals(prevPeerState)) {
            String jingleSID = this.getSID();
            if (jingleSID == null) {
                Object object = this.sidSyncRoot;
                synchronized (object) {
                    this.cancelled = true;
                    return;
                }
            }
            responseIQ = JinglePacketFactory.createCancel((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID());
        } else if (prevPeerState.equals(CallPeerState.INCOMING_CALL)) {
            responseIQ = JinglePacketFactory.createBusy((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID());
        } else if (!prevPeerState.equals(CallPeerState.BUSY) && !prevPeerState.equals(CallPeerState.FAILED)) {
            logger.info((Object)"Could not determine call peer state!");
        }
        if (responseIQ != null) {
            if (reasonOtherExtension != null) {
                ReasonPacketExtension reason = (ReasonPacketExtension)responseIQ.getExtension("reason", "");
                if (reason != null) {
                    reason.setOtherExtension(reasonOtherExtension);
                } else if (reasonOtherExtension instanceof ReasonPacketExtension) {
                    responseIQ.setReason((ReasonPacketExtension)reasonOtherExtension);
                }
            }
            if (((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection() != null) {
                ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)responseIQ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initiateSession(Iterable<ExtensionElement> sessionInitiateExtensions) throws OperationFailedException {
        this.initiator = false;
        List<ContentPacketExtension> offer = ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).createContentList();
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        Iterator<ExtensionElement> iterator = this.sidSyncRoot;
        synchronized (iterator) {
            this.sessionInitIQ = JinglePacketFactory.createSessionInitiate((Jid)protocolProvider.getOurJID(), (Jid)this.peerJID, (String)JingleIQ.generateSID(), offer);
            if (this.cancelled) {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).getTransportManager().close();
                return;
            }
        }
        if (sessionInitiateExtensions != null) {
            for (ExtensionElement sessionInitiateExtension : sessionInitiateExtensions) {
                this.sessionInitIQ.addExtension(sessionInitiateExtension);
            }
        }
        try {
            protocolProvider.getConnection().sendStanza((Stanza)this.sessionInitIQ);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send session init IQ", 0, e);
        }
    }

    void processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processColibriConferenceIQ(conferenceIQ);
    }

    public void processContentAccept(JingleIQ content) throws SmackException.NotConnectedException, InterruptedException {
        List contents = content.getContentList();
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            mediaHandler.processAnswer(contents);
            for (ContentPacketExtension c : contents) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to process a content-accept", (Throwable)e);
            String reason = "Error: " + e.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.sessionInitIQ.getSID(), (Reason)Reason.INCOMPATIBLE_PARAMETERS, (String)reason);
            this.setState(CallPeerState.FAILED, reason);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
        mediaHandler.start();
    }

    public void processContentAdd(final JingleIQ content) throws SmackException.NotConnectedException, InterruptedException {
        MediaStream newVideoStream;
        JingleIQ contentIQ;
        Iterable<ContentPacketExtension> answerContents;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        List contents = content.getContentList();
        boolean noCands = false;
        MediaStream oldVideoStream = mediaHandler.getStream(MediaType.VIDEO);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Looking for candidates in content-add.");
        }
        try {
            if (!this.contentAddWithNoCands) {
                mediaHandler.processOffer(contents);
                for (ContentPacketExtension c : contents) {
                    if (JingleUtils.getFirstCandidate(c, 1) != null) continue;
                    this.contentAddWithNoCands = true;
                    noCands = true;
                }
            }
            if (noCands) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = CallPeerJabberImpl.this.candSyncRoot;
                            synchronized (object) {
                                CallPeerJabberImpl.this.candSyncRoot.wait();
                            }
                            CallPeerJabberImpl.this.processContentAdd(content);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException throwable) {
                            // empty catch block
                        }
                        CallPeerJabberImpl.this.contentAddWithNoCands = false;
                    }
                }.start();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"No candidates found in content-add, started new thread.");
                }
                return;
            }
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Wrapping up connectivity establishment");
            }
            answerContents = mediaHandler.generateSessionAccept();
            contentIQ = null;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred", (Throwable)e);
            answerContents = null;
            contentIQ = JinglePacketFactory.createContentReject((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID(), answerContents);
        }
        if (contentIQ == null) {
            contentIQ = JinglePacketFactory.createContentAccept((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID(), answerContents);
            for (ContentPacketExtension c : answerContents) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)contentIQ);
        mediaHandler.start();
        if (oldVideoStream == null && (newVideoStream = mediaHandler.getStream(MediaType.VIDEO)) != null && mediaHandler.isRTPTranslationEnabled(MediaType.VIDEO)) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (OperationFailedException ofe) {
                logger.error((Object)"Failed to enable RTP translation", (Throwable)ofe);
            }
        }
    }

    public void processContentModify(JingleIQ content) throws SmackException.NotConnectedException, InterruptedException {
        ContentPacketExtension ext = (ContentPacketExtension)content.getContentList().get(0);
        MediaType mediaType = this.getMediaType(ext);
        try {
            boolean modify = ext.getFirstChildOfType(RtpDescriptionPacketExtension.class) != null;
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).reinitContent(ext.getName(), ext, modify);
            this.setSenders(mediaType, ext.getSenders());
            if (MediaType.VIDEO.equals((Object)mediaType)) {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to process an incoming content-modify", (Throwable)e);
            String reason = "Error: " + e.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.sessionInitIQ.getSID(), (Reason)Reason.INCOMPATIBLE_PARAMETERS, (String)reason);
            this.setState(CallPeerState.FAILED, reason);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
    }

    public void processContentReject(JingleIQ content) throws SmackException.NotConnectedException, InterruptedException {
        if (content.getContentList().isEmpty()) {
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)this.sessionInitIQ.getTo(), (Jid)this.sessionInitIQ.getFrom(), (String)this.sessionInitIQ.getSID(), (Reason)Reason.INCOMPATIBLE_PARAMETERS, (String)"Error: content rejected");
            this.setState(CallPeerState.FAILED, "Error: content rejected");
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
    }

    public void processContentRemove(JingleIQ content) {
        List contents = content.getContentList();
        boolean videoContentRemoved = false;
        if (!contents.isEmpty()) {
            CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
            for (ContentPacketExtension c : contents) {
                mediaHandler.removeContent(c.getName());
                MediaType mediaType = this.getMediaType(c);
                this.setSenders(mediaType, ContentPacketExtension.SendersEnum.none);
                if (!MediaType.VIDEO.equals((Object)mediaType)) continue;
                videoContentRemoved = true;
            }
        }
        if (videoContentRemoved) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to update Jingle sessions");
            }
        }
    }

    public void processSessionAccept(JingleIQ sessionInitIQ) throws SmackException.NotConnectedException, InterruptedException {
        this.sessionInitIQ = sessionInitIQ;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        List answer = sessionInitIQ.getContentList();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            mediaHandler.processAnswer(answer);
            for (ContentPacketExtension c : answer) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception exc) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Failed to process a session-accept", (Throwable)exc);
            }
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)sessionInitIQ.getTo(), (Jid)sessionInitIQ.getFrom(), (String)sessionInitIQ.getSID(), (Reason)Reason.INCOMPATIBLE_PARAMETERS, (String)(exc.getClass().getName() + ": " + exc.getMessage()));
            this.setState(CallPeerState.FAILED, "Error: " + exc.getMessage());
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
        this.setState(CallPeerState.CONNECTED);
        mediaHandler.start();
        this.sendModifyVideoContent();
    }

    public void processSessionInfo(SessionInfoPacketExtension info) throws SmackException.NotConnectedException, InterruptedException {
        switch (info.getType()) {
            case ringing: {
                this.setState(CallPeerState.ALERTING_REMOTE_SIDE);
                break;
            }
            case hold: {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).setRemotelyOnHold(true);
                this.reevalRemoteHoldStatus();
                break;
            }
            case unhold: 
            case active: {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).setRemotelyOnHold(false);
                this.reevalRemoteHoldStatus();
                break;
            }
            default: {
                logger.warn((Object)"Received SessionInfoPacketExtension of unknown type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processSessionInitiate(JingleIQ sessionInitIQ) throws SmackException.NotConnectedException, InterruptedException {
        Object calleeURI;
        this.sessionInitIQ = sessionInitIQ;
        this.initiator = true;
        List offer = sessionInitIQ.getContentList();
        try {
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processOffer(offer);
            CoinPacketExtension coin = null;
            for (ExtensionElement ext : sessionInitIQ.getExtensions()) {
                if (!ext.getElementName().equals("conference-info")) continue;
                coin = (CoinPacketExtension)ext;
                break;
            }
            if (coin != null) {
                this.setConferenceFocus(Boolean.parseBoolean((String)coin.getAttribute("isfocus")));
            }
        }
        catch (Exception ex) {
            logger.info((Object)"Failed to process an incoming session initiate", (Throwable)ex);
            String reasonText = "Error: " + ex.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)sessionInitIQ.getTo(), (Jid)sessionInitIQ.getFrom(), (String)sessionInitIQ.getSID(), (Reason)Reason.INCOMPATIBLE_PARAMETERS, (String)reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
        if (this.getDiscoveryInfo() == null) {
            calleeURI = sessionInitIQ.getFrom();
            this.retrieveDiscoveryInfo((Jid)calleeURI);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"will send ringing response: ");
        }
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)JinglePacketFactory.createRinging((JingleIQ)sessionInitIQ));
        calleeURI = this.sessionInitiateSyncRoot;
        synchronized (calleeURI) {
            this.sessionInitiateProcessed = true;
            this.sessionInitiateSyncRoot.notify();
        }
        DiscoverInfo discoverInfo = this.getDiscoveryInfo();
        if (discoverInfo != null && discoverInfo.containsFeature((CharSequence)"urn:ietf:rfc:3264")) {
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)JinglePacketFactory.createDescriptionInfo((Jid)sessionInitIQ.getTo(), (Jid)sessionInitIQ.getFrom(), (String)sessionInitIQ.getSID(), ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).getLocalContentList()));
        }
        this.processSourceAdd(sessionInitIQ);
    }

    public void processSessionTerminate(JingleIQ jingleIQ) {
        String reasonStr = "Call ended by remote side.";
        ReasonPacketExtension reasonExt = jingleIQ.getReason();
        if (reasonExt != null) {
            String text;
            Reason reason = reasonExt.getReason();
            if (reason != null) {
                reasonStr = reasonStr + " Reason: " + reason.toString() + ".";
            }
            if ((text = reasonExt.getText()) != null) {
                reasonStr = reasonStr + " " + text;
            }
        }
        this.setState(CallPeerState.DISCONNECTED, reasonStr);
    }

    public void processTransfer(TransferPacketExtension transfer) throws OperationFailedException {
        Jid attendantAddress = transfer.getFrom();
        if (attendantAddress == null) {
            throw new OperationFailedException("Session transfer must contain a 'from' attribute value.", 11);
        }
        Jid calleeAddress = transfer.getTo();
        if (calleeAddress == null) {
            throw new OperationFailedException("Session transfer must contain a 'to' attribute value.", 11);
        }
        Roster roster = Roster.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection());
        if (!roster.contains(calleeAddress.asBareJid())) {
            String failedMessage = "Transfer impossible:\nAccount roster does not contain transfer peer: " + calleeAddress.asBareJid();
            this.setState(CallPeerState.FAILED, failedMessage);
            logger.info((Object)failedMessage);
        }
        OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicTelephony.class);
        CallJabberImpl calleeCall = new CallJabberImpl(basicTelephony);
        TransferPacketExtension calleeTransfer = new TransferPacketExtension();
        String sid = transfer.getSID();
        calleeTransfer.setFrom(attendantAddress);
        if (sid != null) {
            calleeTransfer.setSID(sid);
            calleeTransfer.setTo(calleeAddress);
        }
        basicTelephony.createOutgoingCall(calleeCall, calleeAddress.toString(), Arrays.asList(calleeTransfer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTransportInfo(JingleIQ jingleIQ) throws SmackException.NotConnectedException, InterruptedException {
        Object object;
        try {
            if (this.isInitiator()) {
                object = this.sessionInitiateSyncRoot;
                synchronized (object) {
                    if (!this.sessionInitiateProcessed) {
                        try {
                            this.sessionInitiateSyncRoot.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processTransportInfo(jingleIQ.getContentList());
        }
        catch (OperationFailedException ofe) {
            logger.warn((Object)"Failed to process an incoming transport-info", (Throwable)ofe);
            String reasonText = "Error: " + ofe.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.sessionInitIQ.getSID(), (Reason)Reason.GENERAL_ERROR, (String)reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)errResp);
            return;
        }
        object = this.candSyncRoot;
        synchronized (object) {
            this.candSyncRoot.notify();
        }
    }

    public void putOnHold(boolean onHold) throws OperationFailedException {
        SessionInfoType type;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        mediaHandler.setLocallyOnHold(onHold);
        if (onHold) {
            type = SessionInfoType.hold;
        } else {
            type = SessionInfoType.unhold;
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).reinitAllContents();
        }
        this.reevalLocalHoldStatus();
        JingleIQ onHoldIQ = JinglePacketFactory.createSessionInfo((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID(), (SessionInfoType)type);
        try {
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendStanza((Stanza)onHoldIQ);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send session info", 0, e);
        }
    }

    private void sendAddVideoContent() throws SmackException.NotConnectedException, InterruptedException {
        List<ContentPacketExtension> contents;
        try {
            contents = ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).createContentList(MediaType.VIDEO);
        }
        catch (Exception exc) {
            logger.warn((Object)"Failed to gather content for video type", (Throwable)exc);
            return;
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentAdd((Jid)protocolProvider.getOurJID(), (Jid)this.peerJID, (String)this.getSID(), contents);
        protocolProvider.getConnection().sendStanza((Stanza)contentIQ);
    }

    public void sendCoinSessionInfo() throws SmackException.NotConnectedException, InterruptedException {
        JingleIQ sessionInfoIQ = JinglePacketFactory.createSessionInfo((Jid)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), (Jid)this.peerJID, (String)this.getSID());
        CoinPacketExtension coinExt = new CoinPacketExtension(((CallJabberImpl)this.getCall()).isConferenceFocus());
        sessionInfoIQ.addExtension((ExtensionElement)coinExt);
        XMPPConnection connection = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection();
        if (connection != null) {
            connection.sendStanza((Stanza)sessionInfoIQ);
        }
    }

    private MediaDirection getDirectionForJingle(MediaType mediaType) {
        CallJabberImpl call;
        ContentPacketExtension.SendersEnum senders;
        MediaDirection direction = MediaDirection.INACTIVE;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        if (MediaType.AUDIO == mediaType && mediaHandler.isLocalAudioTransmissionEnabled() || MediaType.VIDEO == mediaType && this.isLocalVideoStreaming()) {
            direction = direction.or(MediaDirection.SENDONLY);
        }
        if ((senders = this.getSenders(mediaType)) == null || senders == ContentPacketExtension.SendersEnum.both || this.isInitiator() && senders == ContentPacketExtension.SendersEnum.initiator || !this.isInitiator() && senders == ContentPacketExtension.SendersEnum.responder) {
            direction = direction.or(MediaDirection.RECVONLY);
        }
        if ((call = (CallJabberImpl)this.getCall()) != null && call.isConferenceFocus()) {
            for (CallPeerJabberImpl peer : call.getCallPeerList()) {
                if (peer == this || (senders = peer.getSenders(mediaType)) != null && senders != ContentPacketExtension.SendersEnum.both && (!peer.isInitiator() || senders != ContentPacketExtension.SendersEnum.initiator) && (peer.isInitiator() || senders != ContentPacketExtension.SendersEnum.responder)) continue;
                direction = direction.or(MediaDirection.SENDONLY);
                break;
            }
        }
        return direction;
    }

    public boolean sendModifyVideoContent() throws SmackException.NotConnectedException, InterruptedException {
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        MediaDirection direction = this.getDirectionForJingle(MediaType.VIDEO);
        ContentPacketExtension remoteContent = mediaHandler.getLocalContent(MediaType.VIDEO.toString());
        if (remoteContent == null) {
            if (direction == MediaDirection.INACTIVE) {
                return false;
            }
            if (this.getState() == CallPeerState.CONNECTED) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding video content for " + (Object)((Object)this)));
                }
                this.sendAddVideoContent();
                return true;
            }
            return false;
        }
        if (direction == MediaDirection.INACTIVE) {
            this.sendRemoveVideoContent();
            return true;
        }
        ContentPacketExtension.SendersEnum senders = this.getSenders(MediaType.VIDEO);
        if (senders == null) {
            senders = ContentPacketExtension.SendersEnum.both;
        }
        ContentPacketExtension.SendersEnum newSenders = ContentPacketExtension.SendersEnum.none;
        if (MediaDirection.SENDRECV == direction) {
            newSenders = ContentPacketExtension.SendersEnum.both;
        } else if (MediaDirection.RECVONLY == direction) {
            newSenders = this.isInitiator() ? ContentPacketExtension.SendersEnum.initiator : ContentPacketExtension.SendersEnum.responder;
        } else if (MediaDirection.SENDONLY == direction) {
            newSenders = this.isInitiator() ? ContentPacketExtension.SendersEnum.responder : ContentPacketExtension.SendersEnum.initiator;
        }
        ContentPacketExtension ext = new ContentPacketExtension();
        String remoteContentName = remoteContent.getName();
        ext.setSenders(newSenders);
        ext.setCreator(remoteContent.getCreator());
        ext.setName(remoteContentName);
        if (newSenders != senders) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Sending content modify, senders: " + senders + "->" + newSenders));
            }
            ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
            JingleIQ contentIQ = JinglePacketFactory.createContentModify((Jid)protocolProvider.getOurJID(), (Jid)this.peerJID, (String)this.getSID(), (ContentPacketExtension)ext);
            protocolProvider.getConnection().sendStanza((Stanza)contentIQ);
        }
        try {
            mediaHandler.reinitContent(remoteContentName, ext, false);
            mediaHandler.start();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred during media reinitialization", (Throwable)e);
        }
        return newSenders != senders;
    }

    public void sendModifyVideoResolutionContent() throws SmackException.NotConnectedException, InterruptedException {
        ContentPacketExtension content;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        ContentPacketExtension remoteContent = mediaHandler.getRemoteContent(MediaType.VIDEO.toString());
        logger.info((Object)"send modify-content to change resolution");
        try {
            content = mediaHandler.createContentForMedia(MediaType.VIDEO);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to gather content for video type", (Throwable)e);
            return;
        }
        ContentPacketExtension.SendersEnum senders = remoteContent.getSenders();
        if (senders != null) {
            content.setSenders(senders);
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentModify((Jid)protocolProvider.getOurJID(), (Jid)this.peerJID, (String)this.getSID(), (ContentPacketExtension)content);
        protocolProvider.getConnection().sendStanza((Stanza)contentIQ);
        try {
            mediaHandler.reinitContent(remoteContent.getName(), content, false);
            mediaHandler.start();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred when media reinitialization", (Throwable)e);
        }
    }

    private void sendRemoveVideoContent() throws SmackException.NotConnectedException, InterruptedException {
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        ContentPacketExtension content = new ContentPacketExtension();
        ContentPacketExtension remoteContent = mediaHandler.getRemoteContent(MediaType.VIDEO.toString());
        if (remoteContent == null) {
            return;
        }
        String remoteContentName = remoteContent.getName();
        content.setName(remoteContentName);
        content.setCreator(remoteContent.getCreator());
        content.setSenders(remoteContent.getSenders());
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentRemove((Jid)protocolProvider.getOurJID(), (Jid)this.peerJID, (String)this.getSID(), Arrays.asList(content));
        protocolProvider.getConnection().sendStanza((Stanza)contentIQ);
        mediaHandler.removeContent(remoteContentName);
        this.setSenders(MediaType.VIDEO, ContentPacketExtension.SendersEnum.none);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTransportInfo(Iterable<ContentPacketExtension> contents) throws SmackException.NotConnectedException, InterruptedException {
        if (this.cancelled) {
            return;
        }
        JingleIQ transportInfo = new JingleIQ(JingleAction.TRANSPORT_INFO, this.getSID());
        for (ContentPacketExtension content : contents) {
            transportInfo.addContent(content);
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        transportInfo.setFrom(protocolProvider.getOurJID());
        transportInfo.setTo(this.peerJID);
        transportInfo.setType(IQ.Type.set);
        StanzaCollector collector = protocolProvider.getConnection().createStanzaCollectorAndSend((IQ)transportInfo);
        try {
            collector.nextResult();
        }
        finally {
            collector.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(CallPeerState newState, String reason, int reasonCode) {
        CallPeerState oldState = this.getState();
        try {
            TransportManagerJabberImpl transportManager;
            CallPeerMediaHandlerJabberImpl mediaHandler;
            if ((CallPeerState.DISCONNECTED.equals(newState) || CallPeerState.FAILED.equals(newState)) && (mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler()) != null && (transportManager = mediaHandler.getTransportManager()) != null) {
                transportManager.close();
            }
        }
        finally {
            super.setState(newState, reason, reasonCode);
        }
        if (CallPeerState.isOnHold((CallPeerState)oldState) && CallPeerState.CONNECTED.equals(newState)) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (OperationFailedException ofe) {
                logger.error((Object)("Failed to update call video state after 'hold' status removed for " + (Object)((Object)this)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transfer(Jid to, String sid) throws OperationFailedException {
        JingleIQ transferSessionInfo = new JingleIQ(JingleAction.SESSION_INFO, this.getSID());
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        transferSessionInfo.setFrom(protocolProvider.getOurJID());
        transferSessionInfo.setTo(this.getAddressAsJid());
        transferSessionInfo.setType(IQ.Type.set);
        TransferPacketExtension transfer = new TransferPacketExtension();
        if (sid != null) {
            transfer.setFrom(protocolProvider.getOurJID());
            transfer.setSID(sid);
            OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
            CallPeerJabberImpl callPeer = basicTelephony.getActiveCallPeer(sid);
            if (callPeer != null && !CallPeerState.isOnHold((CallPeerState)callPeer.getState())) {
                callPeer.putOnHold(true);
            }
            if (!CallPeerState.isOnHold((CallPeerState)this.getState())) {
                this.putOnHold(true);
            }
        }
        transfer.setTo(to);
        transferSessionInfo.addExtension((ExtensionElement)transfer);
        try {
            StanzaCollector collector = protocolProvider.getConnection().createStanzaCollectorAndSend((IQ)transferSessionInfo);
            try {
                collector.nextResultOrThrow();
            }
            finally {
                collector.cancel();
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send transfer session info", 0, e);
        }
        catch (SmackException.NoResponseException e) {
            throw new OperationFailedException("No response to the \"transfer\" request.", 11);
        }
        catch (XMPPException.XMPPErrorException e) {
            throw new OperationFailedException("Remote peer does not manage call \"transfer\". " + e.getXMPPError(), 11);
        }
        String message = (sid == null ? "Unattended" : "Attended") + " transfer to: " + to;
        try {
            this.hangup(false, message, (ExtensionElement)new ReasonPacketExtension(Reason.SUCCESS, message, (ExtensionElement)new TransferredPacketExtension()));
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send transfer", 0, e);
        }
    }

    public String getEntity() {
        return this.getAddress();
    }

    public MediaDirection getDirection(MediaType mediaType) {
        ContentPacketExtension.SendersEnum senders = this.getSenders(mediaType);
        if (senders == ContentPacketExtension.SendersEnum.none) {
            return MediaDirection.INACTIVE;
        }
        if (senders == null || senders == ContentPacketExtension.SendersEnum.both) {
            return MediaDirection.SENDRECV;
        }
        if (senders == ContentPacketExtension.SendersEnum.initiator) {
            return this.isInitiator() ? MediaDirection.RECVONLY : MediaDirection.SENDONLY;
        }
        return this.isInitiator() ? MediaDirection.SENDONLY : MediaDirection.RECVONLY;
    }

    public ContentPacketExtension.SendersEnum getSenders(MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return this.audioSenders;
            }
            case VIDEO: {
                return this.videoSenders;
            }
        }
        return ContentPacketExtension.SendersEnum.none;
    }

    public void setSenders(MediaType mediaType, ContentPacketExtension.SendersEnum senders) {
        switch (mediaType) {
            case AUDIO: {
                this.audioSenders = senders;
                break;
            }
            case VIDEO: {
                this.videoSenders = senders;
                break;
            }
            default: {
                throw new IllegalArgumentException("mediaType");
            }
        }
    }

    public MediaType getMediaType(ContentPacketExtension content) {
        String contentName = content.getName();
        if (contentName == null) {
            return null;
        }
        MediaType mediaType = JingleUtils.getMediaType(content);
        if (mediaType == null) {
            CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
            for (MediaType m : MediaType.values()) {
                ContentPacketExtension sessionContent = mediaHandler.getRemoteContent(m.toString());
                if (sessionContent == null) {
                    sessionContent = mediaHandler.getLocalContent(m.toString());
                }
                if (sessionContent == null || !contentName.equals(sessionContent.getName())) continue;
                mediaType = m;
                break;
            }
        }
        return mediaType;
    }

    public void processSourceAdd(JingleIQ content) {
        for (ContentPacketExtension c : content.getContentList()) {
            if (!MediaType.AUDIO.equals((Object)JingleUtils.getMediaType(c))) continue;
            RtpDescriptionPacketExtension rtpDesc = JingleUtils.getRtpDescription(c);
            for (MediaPresenceExtension.Source src : rtpDesc.getChildExtensionsOfType(MediaPresenceExtension.Source.class)) {
                Jid owner;
                SSRCInfoPacketExtension ssrcInfo = (SSRCInfoPacketExtension)src.getFirstChildOfType(SSRCInfoPacketExtension.class);
                if (ssrcInfo == null || (owner = ssrcInfo.getOwner()) == null) continue;
                AbstractConferenceMember member = this.findConferenceMemberByAddress(owner);
                if (member == null) {
                    member = new AbstractConferenceMember((CallPeer)this, owner.toString());
                    this.addConferenceMember((ConferenceMember)member);
                }
                member.setAudioSsrc(Long.valueOf(src.getSSRC()).longValue());
            }
        }
    }

    public void processSourceRemove(JingleIQ content) {
        for (ContentPacketExtension c : content.getContentList()) {
            if (!MediaType.AUDIO.equals((Object)JingleUtils.getMediaType(c))) continue;
            RtpDescriptionPacketExtension rtpDesc = JingleUtils.getRtpDescription(c);
            for (SourcePacketExtension src : rtpDesc.getChildExtensionsOfType(SourcePacketExtension.class)) {
                AbstractConferenceMember member;
                Jid owner;
                SSRCInfoPacketExtension ssrcInfo = (SSRCInfoPacketExtension)src.getFirstChildOfType(SSRCInfoPacketExtension.class);
                if (ssrcInfo == null || (owner = ssrcInfo.getOwner()) == null || (member = this.findConferenceMemberByAddress(owner)) == null) continue;
                this.removeConferenceMember((ConferenceMember)member);
            }
        }
    }

    private AbstractConferenceMember findConferenceMemberByAddress(Jid address) {
        for (ConferenceMember member : this.getConferenceMembers()) {
            if (!member.getAddress().equals(address)) continue;
            return (AbstractConferenceMember)member;
        }
        return null;
    }

    public String getAddress() {
        return this.peerJID.toString();
    }

    public Jid getAddressAsJid() {
        return this.peerJID;
    }

    public Contact getContact() {
        OperationSetPresence presence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetPresence.class);
        return presence == null ? null : presence.findContactByID(this.getAddress());
    }

    public DiscoverInfo getDiscoveryInfo() {
        return this.discoverInfo;
    }

    public String getDisplayName() {
        Contact contact;
        if (this.getCall() != null && (contact = this.getContact()) != null) {
            return contact.getDisplayName();
        }
        return this.peerJID.toString();
    }

    public String getURI() {
        return "xmpp:" + this.peerJID;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    private void retrieveDiscoveryInfo(Jid calleeURI) {
        try {
            DiscoverInfo discoveryInfo = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getDiscoveryManager().discoverInfo(calleeURI);
            if (discoveryInfo != null) {
                this.setDiscoveryInfo(discoveryInfo);
            }
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException xmppex) {
            logger.warn((Object)("Could not retrieve info for " + calleeURI), xmppex);
        }
    }

    public void setAddress(Jid address) {
        if (!this.peerJID.equals((CharSequence)address)) {
            String oldAddress = this.getAddress();
            this.peerJID = address;
            this.fireCallPeerChangeEvent("CallPeerAddressChange", oldAddress, address);
        }
    }

    public void setDiscoveryInfo(DiscoverInfo discoverInfo) {
        this.discoverInfo = discoverInfo;
    }

    public String getSessInitID() {
        return this.sessionInitIQ != null ? this.sessionInitIQ.getStanzaId() : null;
    }
}

