/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;

public class Bytestream
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private String sessionID;
    private Mode mode = Mode.tcp;
    private final List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    private StreamHostUsed usedHost;
    private Activate toActivate;

    public Bytestream() {
        super(ELEMENT, NAMESPACE);
    }

    public Bytestream(String SID) {
        this();
        this.setSessionID(SID);
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StreamHost addStreamHost(Jid JID, String address) {
        return this.addStreamHost(JID, address, 0);
    }

    public StreamHost addStreamHost(Jid JID, String address, int port) {
        StreamHost host = new StreamHost(JID, address, port);
        this.addStreamHost(host);
        return host;
    }

    public void addStreamHost(StreamHost host) {
        this.streamHosts.add(host);
    }

    public List<StreamHost> getStreamHosts() {
        return Collections.unmodifiableList(this.streamHosts);
    }

    public StreamHost getStreamHost(Jid JID) {
        if (JID == null) {
            return null;
        }
        for (StreamHost host : this.streamHosts) {
            if (!host.getJID().equals((CharSequence)JID)) continue;
            return host;
        }
        return null;
    }

    public int countStreamHosts() {
        return this.streamHosts.size();
    }

    public void setUsedHost(Jid JID) {
        this.usedHost = new StreamHostUsed(JID);
    }

    public StreamHostUsed getUsedHost() {
        return this.usedHost;
    }

    public Activate getToActivate() {
        return this.toActivate;
    }

    public void setToActivate(Jid targetID) {
        this.toActivate = new Activate(targetID);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        switch (this.getType()) {
            case set: {
                xml.optAttribute("sid", this.getSessionID());
                xml.optAttribute("mode", (Enum)this.getMode());
                xml.rightAngleBracket();
                if (this.getToActivate() == null) {
                    for (StreamHost streamHost : this.getStreamHosts()) {
                        xml.append(streamHost.toXML());
                    }
                    break;
                }
                xml.append(this.getToActivate().toXML());
                break;
            }
            case result: {
                xml.rightAngleBracket();
                xml.optAppend((Element)this.getUsedHost());
                for (StreamHost host : this.streamHosts) {
                    xml.append(host.toXML());
                }
                break;
            }
            case get: {
                xml.setEmptyElement();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return xml;
    }

    public static enum Mode {
        tcp,
        udp;


        public static Mode fromName(String name) {
            Mode mode;
            try {
                mode = Mode.valueOf(name);
            }
            catch (Exception ex) {
                mode = tcp;
            }
            return mode;
        }
    }

    public static class Activate
    implements NamedElement {
        public static String ELEMENTNAME = "activate";
        private final Jid target;

        public Activate(Jid target) {
            this.target = target;
        }

        public Jid getTarget() {
            return this.target;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.rightAngleBracket();
            xml.escape((CharSequence)this.getTarget());
            xml.closeElement((NamedElement)this);
            return xml;
        }
    }

    public static class StreamHostUsed
    implements NamedElement {
        public static String ELEMENTNAME = "streamhost-used";
        private final Jid JID;

        public StreamHostUsed(Jid JID) {
            this.JID = JID;
        }

        public Jid getJID() {
            return this.JID;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("jid", (CharSequence)this.getJID());
            xml.closeEmptyElement();
            return xml;
        }
    }

    public static class StreamHost
    implements NamedElement {
        public static String ELEMENTNAME = "streamhost";
        private final Jid JID;
        private final String addy;
        private final int port;

        public StreamHost(Jid jid, String address) {
            this(jid, address, 0);
        }

        public StreamHost(Jid JID, String address, int port) {
            this.JID = (Jid)Objects.requireNonNull((Object)JID, (String)"StreamHost JID must not be null");
            this.addy = (String)StringUtils.requireNotNullOrEmpty((CharSequence)address, (String)"StreamHost address must not be null");
            this.port = port;
        }

        public Jid getJID() {
            return this.JID;
        }

        public String getAddress() {
            return this.addy;
        }

        public int getPort() {
            return this.port;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("jid", (CharSequence)this.getJID());
            xml.attribute("host", this.getAddress());
            if (this.getPort() != 0) {
                xml.attribute("port", Integer.toString(this.getPort()));
            } else {
                xml.attribute("zeroconf", "_jabber.bytestreams");
            }
            xml.closeEmptyElement();
            return xml;
        }
    }
}

