/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.TransformLayer;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetBasicInstantMessaging
implements OperationSetBasicInstantMessaging {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetBasicInstantMessaging.class);
    private final List<MessageListener> messageListeners = new LinkedList<MessageListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(MessageListener listener) {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    public Message createMessage(byte[] content, String contentType, String encoding, String subject) {
        String contentAsString = null;
        boolean useDefaultEncoding = true;
        if (encoding != null) {
            try {
                contentAsString = new String(content, encoding);
                useDefaultEncoding = false;
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn((Object)("Failed to decode content using encoding " + encoding), (Throwable)ex);
            }
        }
        if (useDefaultEncoding) {
            encoding = Charset.defaultCharset().name();
            contentAsString = new String(content);
        }
        return this.createMessage(contentAsString, contentType, encoding, subject);
    }

    @Override
    public Message createMessage(String messageText) {
        return this.createMessage(messageText, "text/plain", "UTF-8", null);
    }

    @Override
    public Message createMessageWithUID(String messageText, String contentType, String messageUID) {
        return this.createMessage(messageText);
    }

    @Override
    public abstract Message createMessage(String var1, String var2, String var3, String var4);

    protected void fireMessageDelivered(Message message, Contact to) {
        this.fireMessageEvent(new MessageDeliveredEvent(message, to, new Date()));
    }

    protected void fireMessageDeliveryFailed(Message message, Contact to, int errorCode) {
        this.fireMessageEvent(new MessageDeliveryFailedEvent(message, to, errorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageEvent(EventObject evt) {
        EventObject[] events;
        ArrayList<MessageListener> listeners = null;
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            listeners = new ArrayList<MessageListener>(this.messageListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching Message Listeners=" + listeners.size() + " evt=" + evt));
        }
        MessageEventType eventType = MessageEventType.None;
        if (evt instanceof MessageDeliveredEvent) {
            eventType = MessageEventType.MessageDelivered;
        } else if (evt instanceof MessageReceivedEvent) {
            eventType = MessageEventType.MessageReceived;
        } else if (evt instanceof MessageDeliveryFailedEvent) {
            eventType = MessageEventType.MessageDeliveryFailed;
        }
        for (EventObject event : events = this.messageTransform(evt, eventType)) {
            try {
                if (event == null) {
                    return;
                }
                for (MessageListener listener : listeners) {
                    switch (eventType) {
                        case MessageDelivered: {
                            listener.messageDelivered((MessageDeliveredEvent)event);
                            break;
                        }
                        case MessageDeliveryFailed: {
                            listener.messageDeliveryFailed((MessageDeliveryFailedEvent)event);
                            break;
                        }
                        case MessageReceived: {
                            listener.messageReceived((MessageReceivedEvent)event);
                            break;
                        }
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Error delivering message", e);
            }
        }
    }

    protected void fireMessageReceived(Message message, Contact from) {
        this.fireMessageEvent(new MessageReceivedEvent(message, from, new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(MessageListener listener) {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.remove(listener);
        }
    }

    public MessageDeliveredEvent[] messageDeliveryPendingTransform(MessageDeliveredEvent evt) {
        EventObject[] transformed = this.messageTransform(evt, MessageEventType.MessageDeliveryPending);
        int size = transformed.length;
        MessageDeliveredEvent[] events = new MessageDeliveredEvent[size];
        System.arraycopy(transformed, 0, events, 0, size);
        return events;
    }

    private EventObject[] messageTransform(EventObject evt, MessageEventType eventType) {
        ProtocolProviderService protocolProvider;
        if (evt == null) {
            return new EventObject[0];
        }
        switch (eventType) {
            case MessageDelivered: {
                protocolProvider = ((MessageDeliveredEvent)evt).getDestinationContact().getProtocolProvider();
                break;
            }
            case MessageDeliveryFailed: {
                protocolProvider = ((MessageDeliveryFailedEvent)evt).getDestinationContact().getProtocolProvider();
                break;
            }
            case MessageDeliveryPending: {
                protocolProvider = ((MessageDeliveredEvent)evt).getDestinationContact().getProtocolProvider();
                break;
            }
            case MessageReceived: {
                protocolProvider = ((MessageReceivedEvent)evt).getSourceContact().getProtocolProvider();
                break;
            }
            default: {
                return new EventObject[]{evt};
            }
        }
        OperationSetInstantMessageTransformImpl opSetMessageTransform = (OperationSetInstantMessageTransformImpl)protocolProvider.getOperationSet(OperationSetInstantMessageTransform.class);
        if (opSetMessageTransform == null) {
            return new EventObject[]{evt};
        }
        LinkedList<EventObject> current = new LinkedList<EventObject>();
        current.add(evt);
        LinkedList<EventObject> next = new LinkedList<EventObject>();
        for (Map.Entry<Integer, Vector<TransformLayer>> entry : opSetMessageTransform.transformLayers.entrySet()) {
            for (TransformLayer transformLayer : entry.getValue()) {
                next.clear();
                block14: while (!current.isEmpty()) {
                    EventObject event = (EventObject)current.remove();
                    switch (eventType) {
                        case MessageDelivered: {
                            MessageDeliveredEvent transformedDelivered = transformLayer.messageDelivered((MessageDeliveredEvent)event);
                            if (transformedDelivered == null) continue block14;
                            next.add(transformedDelivered);
                            break;
                        }
                        case MessageDeliveryPending: {
                            MessageDeliveredEvent[] evts;
                            for (MessageDeliveredEvent mde : evts = transformLayer.messageDeliveryPending((MessageDeliveredEvent)event)) {
                                if (mde == null) continue;
                                next.add(mde);
                            }
                            continue block14;
                        }
                        case MessageDeliveryFailed: {
                            MessageDeliveryFailedEvent transformedDeliveryFailed = transformLayer.messageDeliveryFailed((MessageDeliveryFailedEvent)event);
                            if (transformedDeliveryFailed == null) continue block14;
                            next.add(transformedDeliveryFailed);
                            break;
                        }
                        case MessageReceived: {
                            MessageReceivedEvent transformedReceived = transformLayer.messageReceived((MessageReceivedEvent)event);
                            if (transformedReceived == null) continue block14;
                            next.add(transformedReceived);
                            break;
                        }
                        default: {
                            next.add(event);
                        }
                    }
                }
                current.addAll(next);
            }
        }
        return current.toArray(new EventObject[current.size()]);
    }

    @Override
    public boolean isContentTypeSupported(String contentType, Contact contact) {
        return contentType.equals("text/plain");
    }

    @Override
    public void sendInstantMessage(Contact to, ContactResource toResource, Message message) throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        this.sendInstantMessage(to, message);
    }

    @Override
    public long getInactivityTimeout() {
        return -1L;
    }

    static enum MessageEventType {
        None,
        MessageDelivered,
        MessageReceived,
        MessageDeliveryFailed,
        MessageDeliveryPending;

    }
}

