/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EndpointMessageBuilder;
import org.jitsi.videobridge.EndpointMessageTransport;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.rest.ColibriWebSocket;

public class Endpoint
extends AbstractEndpoint {
    private static final Logger classLogger = Logger.getLogger(Endpoint.class);
    public static final String PINNED_ENDPOINTS_PROPERTY_NAME = Endpoint.class.getName() + ".pinnedEndpoints";
    public static final String SELECTED_ENDPOINTS_PROPERTY_NAME = Endpoint.class.getName() + ".selectedEndpoints";
    private Set<String> pinnedEndpoints = new HashSet<String>();
    private Set<String> selectedEndpoints = new HashSet<String>();
    private final Logger logger;
    private String icePassword;
    private final EndpointMessageTransport messageTransport;
    private AtomicInteger selectedCount = new AtomicInteger(0);

    public Endpoint(String id, Conference conference) {
        super(conference, id);
        this.messageTransport = new EndpointMessageTransport(this);
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)conference.getLogger());
    }

    @Override
    public EndpointMessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    public SctpConnection getSctpConnection() {
        return this.getMessageTransport().getSctpConnection();
    }

    @Override
    public Set<String> getSelectedEndpoints() {
        return this.selectedEndpoints;
    }

    @Override
    public Set<String> getPinnedEndpoints() {
        return this.pinnedEndpoints;
    }

    void pinnedEndpointsChanged(Set<String> newPinnedEndpoints) {
        Set<String> oldPinnedEndpoints = this.pinnedEndpoints;
        if (!oldPinnedEndpoints.equals(newPinnedEndpoints)) {
            this.pinnedEndpoints = newPinnedEndpoints;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getID() + " pinned " + Arrays.toString(this.pinnedEndpoints.toArray())));
            }
            this.firePropertyChange(PINNED_ENDPOINTS_PROPERTY_NAME, oldPinnedEndpoints, this.pinnedEndpoints);
        }
    }

    void selectedEndpointsChanged(Set<String> newSelectedEndpoints) {
        Set<String> oldSelectedEndpoints = this.selectedEndpoints;
        if (!oldSelectedEndpoints.equals(newSelectedEndpoints)) {
            this.selectedEndpoints = newSelectedEndpoints;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getID() + " selected " + Arrays.toString(this.selectedEndpoints.toArray())));
            }
            this.firePropertyChange(SELECTED_ENDPOINTS_PROPERTY_NAME, oldSelectedEndpoints, this.selectedEndpoints);
        }
    }

    @Override
    public void sendMessage(String msg) throws IOException {
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            messageTransport.sendMessage(msg);
        }
    }

    @Override
    protected void maybeExpire() {
        if (this.getSctpConnection() == null && this.getChannelCount(null) == 0) {
            this.expire();
        }
    }

    @Override
    public void expire() {
        super.expire();
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            ((AbstractEndpointMessageTransport)messageTransport).close();
        }
    }

    void setSctpConnection(SctpConnection sctpConnection) {
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            messageTransport.setSctpConnection(sctpConnection);
        }
        if (this.getSctpConnection() == null) {
            this.maybeExpire();
        }
    }

    public boolean acceptWebSocket(String password) {
        String icePassword = this.getIcePassword();
        if (icePassword == null || !icePassword.equals(password)) {
            this.logger.warn((Object)("Incoming web socket request with an invalid password.Expected: " + icePassword + ", received " + password));
            return false;
        }
        return true;
    }

    public void onWebSocketConnect(ColibriWebSocket ws) {
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            messageTransport.onWebSocketConnect(ws);
        }
    }

    public void onWebSocketClose(ColibriWebSocket ws, int statusCode, String reason) {
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            messageTransport.onWebSocketClose(ws, statusCode, reason);
        }
    }

    public void onWebSocketText(ColibriWebSocket ws, String message) {
        EndpointMessageTransport messageTransport = this.getMessageTransport();
        if (messageTransport != null) {
            messageTransport.onWebSocketText(ws, message);
        }
    }

    private String getIcePassword() {
        String password;
        if (this.icePassword != null) {
            return this.icePassword;
        }
        List<RtpChannel> channels = this.getChannels();
        if (channels == null || channels.isEmpty()) {
            return null;
        }
        TransportManager tm = channels.get(0).getTransportManager();
        if (tm instanceof IceUdpTransportManager && (password = ((IceUdpTransportManager)tm).getIcePassword()) != null) {
            this.icePassword = password;
            return password;
        }
        return null;
    }

    @Override
    public void incrementSelectedCount() {
        int newValue = this.selectedCount.incrementAndGet();
        if (newValue == 1) {
            String selectedUpdate = EndpointMessageBuilder.createSelectedUpdateMessage(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint " + this.getID() + " is now selected, sending message: " + selectedUpdate));
            }
            try {
                this.sendMessage(selectedUpdate);
            }
            catch (IOException e) {
                this.logger.error((Object)("Error sending SelectedUpdate message: " + e));
            }
        }
    }

    @Override
    public void decrementSelectedCount() {
        int newValue = this.selectedCount.decrementAndGet();
        if (newValue == 0) {
            String selectedUpdate = EndpointMessageBuilder.createSelectedUpdateMessage(false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint " + this.getID() + " is no longer selected, sending message: " + selectedUpdate));
            }
            try {
                this.sendMessage(selectedUpdate);
            }
            catch (IOException e) {
                this.logger.error((Object)("Error sending SelectedUpdate message: " + e));
            }
        }
    }
}

