/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.util.Objects;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.concurrent.MonotonicAtomicLong;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RawUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.octo.OctoTransportManager;
import org.jitsi.videobridge.util.Expireable;
import org.jitsi.videobridge.util.ExpireableImpl;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.osgi.framework.BundleContext;

public abstract class Channel
extends PropertyChangeNotifier
implements Expireable {
    public static final int DEFAULT_EXPIRE = 60;
    public static final String INITIATOR_PROPERTY = "initiator";
    public static final String ENDPOINT_PROPERTY_NAME = ".endpoint";
    private static final Logger classLogger = Logger.getLogger(Channel.class);
    private final String channelBundleId;
    private final long creationTimestamp = System.currentTimeMillis();
    private final Content content;
    private AbstractEndpoint endpoint;
    private int expire = 60;
    private boolean expired = false;
    private final String id;
    private boolean initiator = true;
    private final MonotonicAtomicLong lastActivityTime = new MonotonicAtomicLong();
    private final MonotonicAtomicLong lastTransportActivityTime = new MonotonicAtomicLong();
    private final MonotonicAtomicLong lastPayloadActivityTime = new MonotonicAtomicLong();
    private StreamConnector streamConnector;
    private TransportManager transportManager;
    protected final String transportNamespace;
    private final Object transportManagerSyncRoot = new Object();
    private final Logger logger;
    private final ExpireableImpl expireableImpl;

    public static String getLoggingId(Channel channel) {
        String id = channel == null ? "null" : channel.getID();
        Content content = channel == null ? null : channel.getContent();
        AbstractEndpoint endpoint = channel == null ? null : channel.getEndpoint();
        return Content.getLoggingId(content) + ",ch_id=" + id + ",endp_id=" + (endpoint == null ? "null" : endpoint.getID());
    }

    public Channel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) {
        Objects.requireNonNull(content, "content");
        org.jivesoftware.smack.util.StringUtils.requireNotNullOrEmpty((CharSequence)id, (String)"id");
        this.id = id;
        this.content = content;
        this.channelBundleId = channelBundleId;
        if (initiator != null) {
            this.initiator = initiator;
        }
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)content.getConference().getLogger());
        if (StringUtils.isNullOrEmpty((String)transportNamespace)) {
            transportNamespace = this.getContent().getConference().getVideobridge().getDefaultTransportManager();
        }
        this.transportNamespace = transportNamespace;
        this.expireableImpl = new ExpireableImpl(this.getLoggingId(), this::expire);
        this.touch();
    }

    protected abstract void closeStream() throws IOException;

    protected StreamConnector createStreamConnector() {
        TransportManager transportManager = this.getTransportManager();
        return transportManager != null ? transportManager.getStreamConnector(this) : null;
    }

    protected MediaStreamTarget createStreamTarget() {
        TransportManager transportManager = this.getTransportManager();
        return transportManager != null ? transportManager.getStreamTarget(this) : null;
    }

    protected TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            Content content = this.getContent();
            return new IceUdpTransportManager(content.getConference(), this.isInitiator(), 2, content.getName());
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            return new RawUdpTransportManager(this);
        }
        if ("http://jitsi.org/octo".equals(xmlNamespace)) {
            return new OctoTransportManager(this);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        AbstractEndpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            iq.setEndpoint(endpoint.getID());
        }
        iq.setID(this.id);
        iq.setExpire(this.getExpire());
        iq.setInitiator(Boolean.valueOf(this.isInitiator()));
        if (this.channelBundleId != null) {
            iq.setChannelBundleId(this.channelBundleId);
        } else {
            this.describeTransportManager(iq);
        }
    }

    private void describeTransportManager(ColibriConferenceIQ.ChannelCommon iq) {
        TransportManager transportManager = this.getTransportManager();
        if (transportManager != null) {
            transportManager.describe(iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire() {
        Channel channel = this;
        synchronized (channel) {
            if (this.expired) {
                return false;
            }
            this.expired = true;
        }
        Content content = this.getContent();
        Conference conference = content.getConference();
        EventAdmin eventAdmin = conference.getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.channelExpired(this));
        }
        try {
            content.expireChannel(this);
        }
        finally {
            block31: {
                block30: {
                    block29: {
                        try {
                            this.closeStream();
                        }
                        catch (Throwable t) {
                            this.logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                            if (!(t instanceof ThreadDeath)) break block29;
                            throw (ThreadDeath)t;
                        }
                    }
                    try {
                        Object t = this.transportManagerSyncRoot;
                        synchronized (t) {
                            if (this.transportManager != null) {
                                this.transportManager.close(this);
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                        if (!(t instanceof ThreadDeath)) break block30;
                        throw (ThreadDeath)t;
                    }
                }
                try {
                    this.onEndpointChanged(this.getEndpoint(), null);
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block31;
                    throw (ThreadDeath)t;
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(Logger.Category.STATISTICS, "expire_ch," + this.getLoggingId());
            }
        }
        return true;
    }

    public BundleContext getBundleContext() {
        return this.getContent().getBundleContext();
    }

    public Content getContent() {
        return this.content;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    protected SrtpControl getSrtpControl() {
        TransportManager transportManager = this.getTransportManager();
        return transportManager == null ? null : transportManager.getSrtpControl(this);
    }

    public AbstractEndpoint getEndpoint() {
        return this.endpoint;
    }

    public AbstractEndpoint getEndpoint(long ssrc) {
        return this.getEndpoint();
    }

    public int getExpire() {
        return this.expire;
    }

    public final String getID() {
        return this.id;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime.get();
    }

    public long getLastPayloadActivityTime() {
        return this.lastPayloadActivityTime.get();
    }

    public long getLastTransportActivityTime() {
        return this.lastTransportActivityTime.get();
    }

    StreamConnector getStreamConnector() {
        if (this.streamConnector == null) {
            this.streamConnector = this.createStreamConnector();
        }
        return this.streamConnector;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            this.transportManager = this.channelBundleId == null ? this.createTransportManager(this.transportNamespace) : this.getContent().getConference().getTransportManager(this.channelBundleId, true, this.isInitiator());
            if (this.transportManager == null) {
                throw new IOException("Failed to get transport manager.");
            }
            this.transportManager.addChannel(this);
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    protected abstract void maybeStartStream() throws IOException;

    protected void onEndpointChanged(AbstractEndpoint oldValue, AbstractEndpoint newValue) {
        this.firePropertyChange(ENDPOINT_PROPERTY_NAME, (Object)oldValue, (Object)newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String newEndpointId) {
        try {
            AbstractEndpoint oldValue = this.endpoint;
            if (oldValue == null ? newEndpointId == null : oldValue.getID().equals(newEndpointId)) {
                return;
            }
            AbstractEndpoint newValue = this.getContent().getConference().getOrCreateEndpoint(newEndpointId);
            this.setEndpoint(newValue);
        }
        finally {
            this.touch();
        }
    }

    public void setEndpoint(AbstractEndpoint endpoint) {
        AbstractEndpoint oldEndpoint = this.endpoint;
        if (oldEndpoint != endpoint) {
            this.endpoint = endpoint;
            this.onEndpointChanged(oldEndpoint, endpoint);
        }
    }

    public void setExpire(int expire) {
        if (expire < 0) {
            throw new IllegalArgumentException("expire");
        }
        this.expire = expire;
        if (this.expire == 0) {
            this.expire();
        } else {
            this.touch();
        }
    }

    public void setInitiator(boolean initiator) {
        boolean oldValue = this.initiator;
        boolean newValue = this.initiator = initiator;
        this.touch();
        if (oldValue != newValue) {
            this.firePropertyChange(INITIATOR_PROPERTY, oldValue, newValue);
        }
    }

    public void setTransport(IceUdpTransportPacketExtension transport) {
        if (transport != null) {
            TransportManager transportManager = this.getTransportManager();
            if (transportManager != null) {
                transportManager.startConnectivityEstablishment(transport);
            } else {
                this.logger.warn((Object)"Failed to start connectivity establishment: transport manager is null.");
            }
        }
        this.touch();
    }

    public void touch(ActivityType activityType) {
        long now = System.currentTimeMillis();
        switch (activityType) {
            case PAYLOAD: {
                this.lastPayloadActivityTime.increase(now);
            }
            case TRANSPORT: {
                this.lastTransportActivityTime.increase(now);
            }
        }
        this.lastActivityTime.increase(now);
    }

    public void touch() {
        this.touch(ActivityType.OTHER);
    }

    void transportClosed() {
        this.expire();
    }

    void transportConnected() {
        this.logger.info(Logger.Category.STATISTICS, "transport_connected," + this.getLoggingId());
        this.touch(ActivityType.TRANSPORT);
        try {
            this.maybeStartStream();
        }
        catch (IOException ioe) {
            this.logger.warn((Object)("Failed to start stream for channel: " + this.getID() + ": " + ioe));
        }
    }

    public String getChannelBundleId() {
        return this.channelBundleId;
    }

    public String getLoggingId() {
        return Channel.getLoggingId(this);
    }

    @Override
    public boolean shouldExpire() {
        return this.getLastActivityTime() + 1000L * (long)this.getExpire() < System.currentTimeMillis();
    }

    @Override
    public void safeExpire() {
        this.expireableImpl.safeExpire();
    }

    public static enum ActivityType {
        TRANSPORT,
        PAYLOAD,
        OTHER;

    }
}

