/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.ScreenInformation;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.plugin.desktoputil.WindowUtils;
import net.java.sip.communicator.service.keybindings.KeybindingSet;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigPropertyVetoException;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;

public class SIPCommFrame
extends JFrame
implements Observer {
    private static final long serialVersionUID = 0L;
    static final String PNAME_CALCULATED_POSITIONING = "net.sip.communicator.util.swing.USE_CALCULATED_POSITIONING";
    private static final Logger logger = Logger.getLogger(SIPCommFrame.class);
    private ActionMap amap;
    private InputMap imap;
    private KeybindingSet bindings = null;
    private boolean saveSize = true;
    private boolean saveLocation = true;

    public SIPCommFrame() {
        if (!OSUtils.IS_MAC) {
            this.setContentPane(new MainContentPane());
        }
        this.init();
        this.addWindowListener(new FrameWindowAdapter());
        JRootPane rootPane = this.getRootPane();
        this.amap = rootPane.getActionMap();
        this.amap.put("close", new CloseAction());
        this.amap.put("closeEsc", new CloseEscAction());
        this.imap = rootPane.getInputMap(1);
        this.imap.put(KeyStroke.getKeyStroke(27, 0), "closeEsc");
        if (OSUtils.IS_MAC) {
            this.imap.put(KeyStroke.getKeyStroke(87, 256), "closeEsc");
            this.imap.put(KeyStroke.getKeyStroke(87, 128), "closeEsc");
        }
        WindowUtils.addWindow(this);
    }

    private void init() {
        SIPCommFrame.updateIconImages(this);
    }

    public static void updateIconImages(Window window) {
        try {
            ArrayList<Image> logos = new ArrayList<Image>(6){
                private static final long serialVersionUID = 0L;
                {
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO"));
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO_20x20"));
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO_32x32"));
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO_45x45"));
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO_64x64"));
                    this.add(DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO_128x128"));
                }
            };
            window.setIconImages((List<? extends Image>)logos);
            JOptionPane.getRootFrame().setIconImages((List<? extends Image>)logos);
        }
        catch (Exception e) {
            BufferedImage scLogo = DesktopUtilActivator.getImage("service.gui.SIP_COMMUNICATOR_LOGO");
            window.setIconImage(scLogo);
            JOptionPane.getRootFrame().setIconImage(scLogo);
        }
    }

    public SIPCommFrame(boolean saveSizeAndLocation) {
        this(saveSizeAndLocation, saveSizeAndLocation);
    }

    public SIPCommFrame(boolean saveLocation, boolean saveSize) {
        this();
        this.saveLocation = saveLocation;
        this.saveSize = saveSize;
    }

    protected void setKeybindingInput(KeybindingSet.Category category) {
        if (this.bindings != null) {
            this.bindings.deleteObserver((Observer)this);
            this.resetInputMap();
        }
        this.bindings = DesktopUtilActivator.getKeybindingsService().getBindings(category);
        if (this.bindings != null) {
            for (Map.Entry key2action : this.bindings.getBindings().entrySet()) {
                this.imap.put((KeyStroke)key2action.getKey(), key2action.getValue());
            }
            this.bindings.addObserver((Observer)this);
        }
    }

    protected void addKeybindingAction(String binding, Action action) {
        this.amap.put(binding, action);
    }

    protected void windowClosing(WindowEvent e) {
        if (this.saveLocation || this.saveSize) {
            this.saveSizeAndLocation();
        }
        this.close(false);
    }

    protected void windowDispose() {
        super.dispose();
    }

    private void saveSizeAndLocation() {
        try {
            SIPCommFrame.saveSizeAndLocation(this, this.saveSize, this.saveLocation);
        }
        catch (ConfigPropertyVetoException e) {
            logger.error((Object)"Saving the size and the location properties failed", (Throwable)e);
        }
    }

    static void saveSizeAndLocation(Component component, boolean saveSize, boolean saveLocation) throws ConfigPropertyVetoException {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        String className = component.getClass().getName().replaceAll("\\$", "_");
        if (saveSize) {
            props.put(className + ".width", component.getWidth());
            props.put(className + ".height", component.getHeight());
        }
        if (saveLocation) {
            props.put(className + ".x", component.getX());
            props.put(className + ".y", component.getY());
        }
        DesktopUtilActivator.getConfigurationService().setProperties(props);
    }

    public void setSizeAndLocation() {
        if (!this.saveLocation && !this.saveSize) {
            return;
        }
        ConfigurationService configService = DesktopUtilActivator.getConfigurationService();
        String className = this.getClass().getName();
        if (this.saveSize) {
            String widthString = configService.getString(className + ".width");
            String heightString = configService.getString(className + ".height");
            if (widthString != null && heightString != null) {
                int width = Integer.parseInt(widthString);
                int height = Integer.parseInt(heightString);
                if (width > 0 && height > 0) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if (width <= screenSize.width && height <= screenSize.height) {
                        this.setSize(width, height);
                    }
                }
            }
        }
        if (this.saveLocation) {
            String xString = configService.getString(className + ".x");
            String yString = configService.getString(className + ".y");
            if (xString != null && yString != null) {
                int y;
                int x = Integer.parseInt(xString);
                if (ScreenInformation.isTitleOnScreen(new Rectangle(x, y = Integer.parseInt(yString), this.getWidth(), this.getHeight())) || configService.getBoolean(PNAME_CALCULATED_POSITIONING, true)) {
                    this.setLocation(x, y);
                }
            } else {
                this.setCenterLocation();
            }
        }
    }

    private void setCenterLocation() {
        this.setLocationRelativeTo(null);
    }

    private void ensureOnScreenLocationAndSize() {
        ConfigurationService config = DesktopUtilActivator.getConfigurationService();
        if (!config.getBoolean(PNAME_CALCULATED_POSITIONING, true)) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle virtualBounds = ScreenInformation.getScreenBounds();
        int borderDistance = 10;
        if (!virtualBounds.contains(x, y)) {
            if (x < virtualBounds.x) {
                x = virtualBounds.x + 10;
            } else if (x > virtualBounds.x && (x = virtualBounds.x + virtualBounds.width - width - 10) < virtualBounds.x + 10) {
                x = virtualBounds.x + 10;
            }
            if (y < virtualBounds.y) {
                y = virtualBounds.y + 10;
            } else if (y > virtualBounds.y && (y = virtualBounds.y + virtualBounds.height - height - 10) < virtualBounds.y + 10) {
                y = virtualBounds.y + 10;
            }
            this.setLocation(x, y);
        }
        if (!virtualBounds.contains(x + width, y + height)) {
            if (x + width > virtualBounds.x + virtualBounds.width && (x = virtualBounds.x + virtualBounds.width - width - 10) < virtualBounds.x + 10) {
                x = virtualBounds.x + 10;
                width = virtualBounds.width - 20;
            }
            if (y + height > virtualBounds.y + virtualBounds.height && (y = virtualBounds.y + virtualBounds.height - height - 10) < virtualBounds.y + 10) {
                y = virtualBounds.y + 10;
                height = virtualBounds.height - 20;
            }
            this.setPreferredSize(new Dimension(width, height));
            this.setSize(width, height);
            this.setLocation(x, y);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setSizeAndLocation();
            this.ensureOnScreenLocationAndSize();
        }
        super.setVisible(isVisible);
    }

    public void setVisible(boolean isVisible, boolean isPackEnabled) {
        if (isVisible) {
            this.pack();
            this.setSizeAndLocation();
            this.ensureOnScreenLocationAndSize();
        }
        super.setVisible(isVisible);
    }

    @Override
    public void dispose() {
        if (this.saveLocation || this.saveSize) {
            this.saveSizeAndLocation();
        }
        if (this.bindings != null) {
            this.bindings.deleteObserver((Observer)this);
        }
        super.dispose();
    }

    private void resetInputMap() {
        this.imap.clear();
        this.imap.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof KeybindingSet) {
            KeybindingSet changedBindings = (KeybindingSet)obs;
            this.resetInputMap();
            for (Map.Entry key2action : changedBindings.getBindings().entrySet()) {
                this.imap.put((KeyStroke)key2action.getKey(), key2action.getValue());
            }
        }
    }

    protected void close(boolean escape) {
    }

    public static class MainContentPane
    extends JPanel {
        private static final long serialVersionUID = 0L;
        private boolean isColorBgEnabled;
        private boolean isImageBgEnabled;
        private Color bgStartColor;
        private Color bgEndColor;
        private BufferedImage bgImage = null;
        private TexturePaint texture = null;

        public MainContentPane() {
            super(new BorderLayout());
            this.initColors();
            this.initStyles();
        }

        @Override
        public void validate() {
            this.initStyles();
            super.validate();
        }

        @Override
        public void repaint() {
            this.initColors();
            super.repaint();
        }

        private void initColors() {
            ResourceManagementService resources = DesktopUtilActivator.getResources();
            this.isColorBgEnabled = new Boolean(resources.getSettingsString("impl.gui.IS_WINDOW_COLOR_BACKGROUND_ENABLED"));
            if (this.isColorBgEnabled) {
                this.bgStartColor = new Color(resources.getColor("service.gui.MAIN_BACKGROUND"));
                this.bgEndColor = new Color(resources.getColor("service.gui.MAIN_BACKGROUND_GRADIENT"));
            } else {
                this.bgStartColor = null;
                this.bgEndColor = null;
            }
            this.isImageBgEnabled = new Boolean(resources.getSettingsString("impl.gui.IS_WINDOW_IMAGE_BACKGROUND_ENABLED"));
            if (this.isImageBgEnabled) {
                URL bgImagePath = resources.getImageURL("service.gui.WINDOW_TITLE_BAR_BG");
                this.bgImage = ImageUtils.getBufferedImage(bgImagePath);
                Rectangle rect = new Rectangle(0, 0, this.bgImage.getWidth(), this.bgImage.getHeight());
                this.texture = new TexturePaint(this.bgImage, rect);
            }
        }

        private void initStyles() {
            ResourceManagementService resources = DesktopUtilActivator.getResources();
            int borderSize = resources.getSettingsInt("impl.gui.MAIN_WINDOW_BORDER_SIZE");
            this.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isColorBgEnabled || this.isImageBgEnabled) {
                g = g.create();
                try {
                    this.internalPaintComponent(g);
                }
                finally {
                    g.dispose();
                }
            }
        }

        private void internalPaintComponent(Graphics g) {
            AntialiasingManager.activateAntialiasing(g);
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isColorBgEnabled) {
                GradientPaint bgGradientColor = new GradientPaint(width / 2, 0.0f, this.bgStartColor, width / 2, 80.0f, this.bgEndColor);
                g2.setPaint(bgGradientColor);
                g2.fillRect(0, 0, width, 80);
                g2.setColor(this.bgEndColor);
                g2.fillRect(0, 78, width, height);
            }
            if (this.isImageBgEnabled && this.bgImage != null && this.texture != null) {
                g2.setPaint(this.texture);
                g2.fillRect(0, 0, this.getWidth(), this.bgImage.getHeight());
            }
        }
    }

    private static class FrameWindowAdapter
    extends WindowAdapter {
        private FrameWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ((SIPCommFrame)e.getWindow()).windowClosing(e);
        }
    }

    private class CloseEscAction
    extends UIAction {
        private static final long serialVersionUID = 0L;

        private CloseEscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SIPCommFrame.this.saveLocation || SIPCommFrame.this.saveSize) {
                SIPCommFrame.this.saveSizeAndLocation();
            }
            SIPCommFrame.this.close(true);
        }
    }

    private class CloseAction
    extends UIAction {
        private static final long serialVersionUID = 0L;

        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SIPCommFrame.this.saveLocation || SIPCommFrame.this.saveSize) {
                SIPCommFrame.this.saveSizeAndLocation();
            }
            SIPCommFrame.this.close(false);
        }
    }
}

