/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.argdelegation;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenURIHandler;
import java.lang.reflect.Method;
import net.java.sip.communicator.impl.argdelegation.ArgDelegationPeerImpl;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.launchutils.ArgDelegationPeer;
import net.java.sip.communicator.util.launchutils.LaunchArgHandler;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;

public class ArgDelegationActivator
extends AbstractServiceDependentActivator {
    private static BundleContext bundleContext = null;
    private ArgDelegationPeerImpl delegationPeer = null;
    private static UIService uiService = null;

    public void start(Object dependentService) {
        Application application;
        this.delegationPeer = new ArgDelegationPeerImpl(bundleContext);
        bundleContext.addServiceListener((ServiceListener)this.delegationPeer);
        LaunchArgHandler.getInstance().setDelegationPeer((ArgDelegationPeer)this.delegationPeer);
        if (OSUtils.IS_MAC && (application = Application.getApplication()) != null) {
            try {
                Method method = application.getClass().getMethod("setOpenURIHandler", OpenURIHandler.class);
                OpenURIHandler handler = new OpenURIHandler(){

                    public void openURI(AppEvent.OpenURIEvent evt) {
                        ArgDelegationActivator.this.delegationPeer.handleUri(evt.getURI().toString());
                    }
                };
                method.invoke((Object)application, handler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void stop(BundleContext bc) throws Exception {
        uiService = null;
        bc.removeServiceListener((ServiceListener)this.delegationPeer);
        this.delegationPeer = null;
        LaunchArgHandler.getInstance().setDelegationPeer(null);
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }
}

