/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.octo.OctoChannel;
import org.jitsi.videobridge.octo.OctoEndpoint;
import org.jitsi.videobridge.octo.OctoEndpointMessageTransport;

public class OctoEndpoints {
    private static final Logger classLogger = Logger.getLogger(OctoEndpoints.class);
    private Conference conference;
    private OctoChannel audioChannel;
    private OctoChannel videoChannel;
    private final Object endpointsSyncRoot = new Object();
    final OctoEndpointMessageTransport messageTransport = new OctoEndpointMessageTransport(this);
    private final Logger logger;

    public OctoEndpoints(Conference conference) {
        this.conference = conference;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)conference.getLogger());
    }

    Conference getConference() {
        return this.conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll() {
        Object object = this.endpointsSyncRoot;
        synchronized (object) {
            List<OctoEndpoint> octoEndpoints = this.getOctoEndpoints();
            octoEndpoints.forEach(AbstractEndpoint::expire);
        }
    }

    private List<OctoEndpoint> getOctoEndpoints() {
        return this.conference.getEndpoints().stream().filter(e -> e instanceof OctoEndpoint).map(e -> (OctoEndpoint)((Object)e)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChannel(MediaType mediaType, OctoChannel channel) {
        Object object = this.endpointsSyncRoot;
        synchronized (object) {
            List<OctoEndpoint> octoEndpoints = this.getOctoEndpoints();
            if (MediaType.VIDEO.equals((Object)mediaType)) {
                if (this.videoChannel != null) {
                    this.logger.error((Object)"Replacing an existing video channel");
                    octoEndpoints.forEach(e -> e.removeChannel(this.videoChannel));
                }
                this.videoChannel = channel;
                if (channel != null) {
                    octoEndpoints.forEach(e -> e.addChannel(this.videoChannel));
                }
            } else if (MediaType.AUDIO.equals((Object)mediaType)) {
                if (this.audioChannel != null) {
                    this.logger.error((Object)"Replacing an existing audio channel");
                    octoEndpoints.forEach(e -> e.removeChannel(this.audioChannel));
                }
                this.audioChannel = channel;
                if (channel != null) {
                    octoEndpoints.forEach(e -> e.addChannel(this.audioChannel));
                }
            } else {
                throw new IllegalArgumentException("mediaType: " + mediaType);
            }
            if (this.videoChannel == null && this.audioChannel == null) {
                this.removeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEndpoints(Set<String> endpointIds) {
        Object object = this.endpointsSyncRoot;
        synchronized (object) {
            List<OctoEndpoint> octoEndpoints = this.getOctoEndpoints();
            List octoEndpointIds = octoEndpoints.stream().map(AbstractEndpoint::getID).collect(Collectors.toList());
            endpointIds.removeAll(octoEndpointIds);
            endpointIds.forEach(this::addEndpoint);
            octoEndpoints.forEach(OctoEndpoint::maybeExpire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OctoEndpoint addEndpoint(String id) {
        OctoEndpoint endpoint;
        Object object = this.endpointsSyncRoot;
        synchronized (object) {
            endpoint = new OctoEndpoint(this.conference, id);
            if (this.audioChannel != null) {
                endpoint.addChannel(this.audioChannel);
            }
            if (this.videoChannel != null) {
                endpoint.addChannel(this.videoChannel);
            }
        }
        this.conference.addEndpoint(endpoint);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractEndpoint findEndpoint(long ssrc) {
        Object object = this.endpointsSyncRoot;
        synchronized (object) {
            return this.getOctoEndpoints().stream().filter(e -> e.getMediaStreamTracks().stream().anyMatch(track -> track.matches(ssrc))).findFirst().orElse(null);
        }
    }

    public void sendMessage(String msg) {
        OctoChannel channel = this.audioChannel;
        if (channel == null) {
            channel = this.videoChannel;
        }
        if (channel != null) {
            channel.sendMessage(msg, null);
        } else {
            this.logger.warn((Object)"Can not send a message, no channels.");
        }
    }
}

