/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.CachingTransformer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.cc.AdaptiveTrackProjectionContext;
import org.jitsi.videobridge.cc.GenericAdaptiveTrackProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.vp8.VP8AdaptiveTrackProjectionContext;

public class AdaptiveTrackProjection {
    private static final Logger logger = Logger.getLogger(AdaptiveTrackProjection.class);
    public static final RawPacket[] EMPTY_PACKET_ARR = AdaptiveTrackProjectionContext.EMPTY_PACKET_ARR;
    private final WeakReference<MediaStreamTrackDesc> weakSource;
    private final long targetSsrc;
    private AdaptiveTrackProjectionContext context;
    private int contextPayloadType = -1;
    private int idealIndex = -1;
    private int targetIndex = -1;

    AdaptiveTrackProjection(@NotNull MediaStreamTrackDesc source) {
        this.weakSource = new WeakReference<MediaStreamTrackDesc>(source);
        this.targetSsrc = source.getRTPEncodings()[0].getPrimarySSRC();
    }

    public MediaStreamTrackDesc getSource() {
        return (MediaStreamTrackDesc)this.weakSource.get();
    }

    int getIdealIndex() {
        return this.idealIndex;
    }

    void setIdealIndex(int value) {
        this.idealIndex = value;
    }

    int getTargetIndex() {
        return this.targetIndex;
    }

    void setTargetIndex(int value) {
        this.targetIndex = value;
    }

    public boolean accept(@NotNull RawPacket rtpPacket) {
        MediaStreamTrackDesc source;
        AdaptiveTrackProjectionContext contextCopy = this.getContext(rtpPacket);
        RTPEncodingDesc encoding = this.getSource().getMediaStreamTrackReceiver().findRTPEncodingDesc(rtpPacket);
        if (encoding == null) {
            logger.warn((Object)("Dropping an RTP packet, because the SSRC has not been signaled:" + rtpPacket.getSSRCAsLong()));
            return false;
        }
        int targetIndexCopy = this.targetIndex;
        boolean accept = contextCopy.accept(rtpPacket, encoding.getIndex(), targetIndexCopy);
        if (contextCopy.needsKeyframe() && targetIndexCopy > -1 && (source = this.getSource()) != null) {
            ((RTPTranslatorImpl)source.getMediaStreamTrackReceiver().getStream().getRTPTranslator()).getRtcpFeedbackMessageSender().requestKeyframe(this.targetSsrc);
        }
        return accept;
    }

    private synchronized AdaptiveTrackProjectionContext getContext(@NotNull RawPacket rtpPacket) {
        MediaFormat format;
        byte payloadType = rtpPacket.getPayloadType();
        if (this.context == null || this.contextPayloadType != payloadType) {
            MediaStreamTrackDesc source = this.getSource();
            format = (MediaFormat)source.getMediaStreamTrackReceiver().getStream().getDynamicRTPPayloadTypes().get(payloadType);
        } else {
            format = this.context.getFormat();
        }
        if ("VP8".equalsIgnoreCase(format.getEncoding())) {
            int payloadLen;
            int payloadOffset;
            boolean hasTemporalLayerIndex;
            byte[] buf = rtpPacket.getBuffer();
            boolean bl = hasTemporalLayerIndex = DePacketizer.VP8PayloadDescriptor.getTemporalLayerIndex((byte[])buf, (int)(payloadOffset = rtpPacket.getPayloadOffset()), (int)(payloadLen = rtpPacket.getPayloadLength())) > -1;
            if (hasTemporalLayerIndex && !(this.context instanceof VP8AdaptiveTrackProjectionContext)) {
                this.context = new VP8AdaptiveTrackProjectionContext(format, this.getRtpState());
                this.contextPayloadType = payloadType;
            } else if (!hasTemporalLayerIndex && !(this.context instanceof GenericAdaptiveTrackProjectionContext)) {
                this.context = new GenericAdaptiveTrackProjectionContext(format, this.getRtpState());
                this.contextPayloadType = payloadType;
            }
            return this.context;
        }
        if (this.context == null || this.contextPayloadType != payloadType) {
            this.context = new GenericAdaptiveTrackProjectionContext(format, this.getRtpState());
            this.contextPayloadType = payloadType;
            return this.context;
        }
        return this.context;
    }

    private RtpState getRtpState() {
        if (this.context == null) {
            MediaStreamTrackDesc track = this.getSource();
            long ssrc = track.getRTPEncodings()[0].getPrimarySSRC();
            return new RtpState(0L, 0L, ssrc, 1, 1L);
        }
        return this.context.getRtpState();
    }

    RawPacket[] rewriteRtp(@NotNull RawPacket rtpPacket) throws RewriteException {
        AdaptiveTrackProjectionContext contextCopy = this.context;
        if (contextCopy == null) {
            return EMPTY_PACKET_ARR;
        }
        RawPacketCache incomingRawPacketCache = null;
        MediaStreamTrackDesc source = this.getSource();
        if (source != null) {
            MediaStreamImpl stream = source.getMediaStreamTrackReceiver().getStream();
            if (stream != null) {
                CachingTransformer cachingTransformer = stream.getCachingTransformer();
                if (cachingTransformer != null) {
                    incomingRawPacketCache = cachingTransformer.getIncomingRawPacketCache();
                } else {
                    logger.warn((Object)"incoming packet cache is null.");
                }
            } else {
                logger.warn((Object)"stream is null.");
            }
        }
        return contextCopy.rewriteRtp(rtpPacket, incomingRawPacketCache);
    }

    public boolean rewriteRtcp(@NotNull RawPacket rtcpPacket) {
        AdaptiveTrackProjectionContext contextCopy = this.context;
        if (contextCopy == null) {
            return true;
        }
        return contextCopy.rewriteRtcp(rtcpPacket);
    }

    public long getSSRC() {
        return this.targetSsrc;
    }
}

