/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPReport;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.rtp.RTCPReportAdapter;
import org.jitsi.util.ArrayUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.concurrent.RecurringRunnable;
import org.jitsi.util.concurrent.RecurringRunnableExecutor;
import org.jitsi.util.function.AbstractFunction;
import org.jitsi.util.function.Predicate;
import org.jitsi.util.function.RawPacketTransformation;
import org.jitsi.util.function.SeqNumPacketTranslation;
import org.jitsi.util.function.TimestampPacketTranslation;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;

public class LipSyncHack
implements TransformEngine {
    public static final byte[] KEY_FRAME_BUFFER = new byte[]{-112, -28, 56, 37, 83, 80, 108, -117, -114, 113, -15, 114, -66, -34, 0, 1, 50, 98, 69, -86, -112, -32, -128, 1, 0, 32, 16, 15, 0, -99, 1, 42, 64, 1, -76, 0, 7, 7, 9, 3, 11, 11, 17, 51, 9, 16, 75, 0, 0, 12, 44, 9, -18, 13, 2, -55, 62, -41, -73, 54, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 112, -10, 78, 92, 0, -2, -17, -71, 0};
    public static final String KEY_FRAMES_PER_INJECTION_PNAME = "org.jitsi.videobridge.LipSyncHack.KEY_FRAMES_PER_INJECTION_PNAME";
    public static final String PERIOD_MS_PNAME = "org.jitsi.videobridge.LipSyncHack.PERIOD_MS_PNAME";
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static final int KEY_FRAMES_PER_PERIOD = cfg.getInt("org.jitsi.videobridge.LipSyncHack.KEY_FRAMES_PER_INJECTION_PNAME", 10);
    private static final int PERIOD_MS = cfg.getInt("org.jitsi.videobridge.LipSyncHack.PERIOD_MS_PNAME", 500);
    private static final long TS_INCREMENT_PER_FRAME = 3000L;
    private static final Logger logger = Logger.getLogger(LipSyncHack.class);
    private static final Random rnd = new Random();
    private final RecurringRunnableExecutor recurringRunnableExecutor = new RecurringRunnableExecutor(LipSyncHack.class.getSimpleName());
    private final RTPTransformer rtpTransformer = new RTPTransformer();
    private final RTCPTransformer rtcpTransformer = new RTCPTransformer();
    private RTCPReportListener rtcpReportListener;
    private final VideoChannel dest;
    private final List<Long> acceptedAudioSSRCs = new ArrayList<Long>();
    private final List<Long> acceptedVideoSSRCs = new ArrayList<Long>();
    private final Object filterSyncRoot = new Object();
    private final Map<Long, Injection> injections = new HashMap<Long, Injection>();
    private final Map<Long, AbstractFunction<RawPacket, RawPacket>> transformations = new ConcurrentHashMap<Long, AbstractFunction<RawPacket, RawPacket>>();
    private int vp8pt = -1;

    LipSyncHack(VideoChannel dest) {
        this.dest = dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRTPTranslatorWillWriteAudio(RawPacket pkt, RtpChannel source) {
        MediaStream stream;
        Long acceptedAudioSSRC = pkt.getSSRCAsLong();
        if (this.acceptedAudioSSRCs.contains(acceptedAudioSSRC)) {
            return;
        }
        if (this.dest == null || (stream = this.dest.getStream()) == null || !stream.isStarted()) {
            return;
        }
        Object[] sourceTracks = source.getEndpoint().getMediaStreamTracks(MediaType.VIDEO);
        if (ArrayUtils.isNullOrEmpty((Object[])sourceTracks)) {
            return;
        }
        Object[] sourceEncodings = sourceTracks[0].getRTPEncodings();
        if (ArrayUtils.isNullOrEmpty((Object[])sourceEncodings)) {
            return;
        }
        long receiveVideoSSRC = sourceEncodings[0].getPrimarySSRC();
        if (receiveVideoSSRC < 0L) {
            return;
        }
        this.acceptedAudioSSRCs.add(acceptedAudioSSRC);
        Object object = this.filterSyncRoot;
        synchronized (object) {
            if (this.acceptedVideoSSRCs.contains(receiveVideoSSRC) || this.injections.containsKey(receiveVideoSSRC)) {
                return;
            }
            Injection injection = new Injection(receiveVideoSSRC);
            this.injections.put(receiveVideoSSRC, injection);
            this.recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)injection);
            if (this.rtcpReportListener == null) {
                this.rtcpReportListener = new RTCPReportListener();
                stream.getMediaStreamStats().getRTCPReports().addRTCPReportListener((org.jitsi.service.neomedia.rtp.RTCPReportListener)this.rtcpReportListener);
            }
        }
    }

    private RawPacket[] make(int ssrc, int seqNumOff, long tsOff, int sz) {
        if (this.vp8pt == -1) {
            this.vp8pt = this.dest.getStream().getDynamicRTPPayloadType("VP8") & 0xFF;
        }
        return LipSyncHack.make(ssrc, (byte)this.vp8pt, seqNumOff, tsOff, sz);
    }

    private static RawPacket[] make(int ssrc, byte pt, int seqNumOff, long tsOff, int sz) {
        RawPacket[] kfs = new RawPacket[sz];
        for (int i = 0; i < sz; ++i) {
            byte[] buf = (byte[])KEY_FRAME_BUFFER.clone();
            kfs[i] = new RawPacket(buf, 0, buf.length);
            kfs[i].setSSRC(ssrc);
            kfs[i].setPayloadType(pt);
            int seqnum = seqNumOff + i & 0xFFFF;
            kfs[i].setSequenceNumber(seqnum);
            long timestamp = tsOff + (long)i * 3000L & 0xFFFFFFFFL;
            kfs[i].setTimestamp(timestamp);
        }
        return kfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRTPTranslatorWillWriteVideo(RawPacket pkt, RtpChannel source) {
        Long acceptedVideoSSRC = pkt.getSSRCAsLong();
        if (this.acceptedVideoSSRCs.contains(acceptedVideoSSRC)) {
            return;
        }
        Object object = this.filterSyncRoot;
        synchronized (object) {
            Injection injectState;
            Object[] sourceEncodings;
            this.acceptedVideoSSRCs.add(acceptedVideoSSRC);
            Object[] sourceTracks = source.getStream().getMediaStreamTrackReceiver().getMediaStreamTracks();
            if (!ArrayUtils.isNullOrEmpty((Object[])sourceTracks) && !ArrayUtils.isNullOrEmpty((Object[])(sourceEncodings = sourceTracks[0].getRTPEncodings()))) {
                acceptedVideoSSRC = sourceEncodings[0].getPrimarySSRC();
                for (Object sourceEncoding : sourceEncodings) {
                    long primarySSRC = sourceEncoding.getPrimarySSRC();
                    if (primarySSRC <= -1L) continue;
                    this.acceptedVideoSSRCs.add(primarySSRC);
                }
            }
            if ((injectState = this.injections.get(acceptedVideoSSRC)) == null) {
                return;
            }
            injectState.stop();
            this.recurringRunnableExecutor.deRegisterRecurringRunnable((RecurringRunnable)injectState);
            int seqNum = pkt.getSequenceNumber();
            long ts = pkt.getTimestamp();
            int seqNumDelta = injectState.maxSeqNum + 10 - seqNum & 0xFFFF;
            long tsDelta = injectState.maxTs + 30000L - ts & 0xFFFFFFFFL;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new_translation,stream=" + this.dest.getStream().hashCode() + " ssrc=" + acceptedVideoSSRC + ",ts_delta=" + tsDelta + ",seq_num_delta=" + seqNumDelta));
            }
            this.transformations.put(acceptedVideoSSRC, (AbstractFunction<RawPacket, RawPacket>)new SeqNumPacketTranslation(seqNumDelta).andThen((AbstractFunction)new TimestampPacketTranslation(tsDelta)));
        }
    }

    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    class RTCPReportListener
    extends RTCPReportAdapter {
        RTCPReportListener() {
        }

        public void rtcpReportReceived(RTCPReport report) {
            for (RTCPFeedback feedback : report.getFeedbackReports()) {
                long ssrc = feedback.getSSRC();
                Injection injection = (Injection)LipSyncHack.this.injections.get(ssrc);
                if (injection == null || LipSyncHack.this.transformations.containsKey(ssrc)) continue;
                injection.stop();
            }
        }
    }

    private class Injection
    implements RecurringRunnable {
        final long receiveVideoSSRC;
        int maxSeqNum = -1;
        long maxTs = -1L;
        boolean running = true;
        long lastRunMs = -1L;

        Injection(long receiveVideoSSRC) {
            this.receiveVideoSSRC = receiveVideoSSRC;
        }

        public long getTimeUntilNextRun() {
            if (!this.running) {
                return Long.MAX_VALUE;
            }
            long timeSinceLastProcess = Math.max(System.currentTimeMillis() - this.lastRunMs, 0L);
            return Math.max((long)PERIOD_MS - timeSinceLastProcess, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.running) {
                return;
            }
            this.lastRunMs = System.currentTimeMillis();
            MediaStream stream = LipSyncHack.this.dest.getStream();
            if (stream == null) {
                return;
            }
            Injection injection = this;
            synchronized (injection) {
                if (!this.running) {
                    return;
                }
                if (this.maxSeqNum == -1) {
                    this.maxSeqNum = rnd.nextInt(65535);
                    this.maxTs = (long)rnd.nextInt() & 0xFFFFFFFFL;
                } else {
                    this.maxSeqNum = this.maxSeqNum + KEY_FRAMES_PER_PERIOD & 0xFFFF;
                    this.maxTs = this.maxTs + (long)KEY_FRAMES_PER_PERIOD * 3000L & 0xFFFFFFFFL;
                }
            }
            long tsOff = this.maxTs - (long)(KEY_FRAMES_PER_PERIOD - 1) * 3000L & 0xFFFFFFFFL;
            int seqNumOff = this.maxSeqNum - KEY_FRAMES_PER_PERIOD - 1 & 0xFFFF;
            RawPacket[] kfs = LipSyncHack.this.make((int)this.receiveVideoSSRC, seqNumOff, tsOff, KEY_FRAMES_PER_PERIOD);
            for (int i = 0; i < KEY_FRAMES_PER_PERIOD; ++i) {
                try {
                    stream.injectPacket(kfs[i], true, (TransformEngine)LipSyncHack.this);
                    continue;
                }
                catch (TransmissionFailedException e) {
                    logger.error((Object)"failed to inject a black keyframe.", (Throwable)e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new_injection,stream=" + stream.hashCode() + " ssrc=" + this.receiveVideoSSRC + ",max_ts=" + kfs[kfs.length - 1].getTimestamp() + ",max_seq_num=" + kfs[kfs.length - 1].getSequenceNumber()));
            }
        }

        public synchronized void stop() {
            this.running = false;
        }
    }

    private class RTCPTransformer
    extends SinglePacketTransformerAdapter {
        RTCPTransformer() {
            super((Predicate)RTCPPacketPredicate.INSTANCE);
        }

        public RawPacket transform(RawPacket pkt) {
            if (LipSyncHack.this.injections.isEmpty()) {
                return pkt;
            }
            switch (RTCPUtils.getPacketType((ByteArrayBuffer)pkt)) {
                case 200: {
                    long ssrc = RawPacket.getRTCPSSRC((ByteArrayBuffer)pkt);
                    AbstractFunction transformation = (AbstractFunction)LipSyncHack.this.transformations.get(ssrc);
                    if (transformation == null) break;
                    return (RawPacket)transformation.apply((Object)pkt);
                }
            }
            return pkt;
        }
    }

    private class RTPTransformer
    implements PacketTransformer {
        private RTPTransformer() {
        }

        public void close() {
            LipSyncHack.this.recurringRunnableExecutor.close();
            if (LipSyncHack.this.rtcpReportListener != null) {
                LipSyncHack.this.dest.getStream().getMediaStreamStats().getRTCPReports().removeRTCPReportListener((org.jitsi.service.neomedia.rtp.RTCPReportListener)LipSyncHack.this.rtcpReportListener);
            }
        }

        public RawPacket[] reverseTransform(RawPacket[] pkts) {
            return pkts;
        }

        public RawPacket[] transform(RawPacket[] pkts) {
            if (ArrayUtils.isNullOrEmpty((Object[])pkts)) {
                return pkts;
            }
            RawPacket[] cumulExtras = null;
            for (int i = 0; i < pkts.length; ++i) {
                if (pkts[i] == null || !RTPPacketPredicate.INSTANCE.test((ByteArrayBuffer)pkts[i])) continue;
                Long ssrc = pkts[i].getSSRCAsLong();
                AbstractFunction transformation = (AbstractFunction)LipSyncHack.this.transformations.get(ssrc);
                if (transformation == null) {
                    assert (!LipSyncHack.this.injections.containsKey(ssrc));
                    transformation = RawPacketTransformation.identity;
                    int seqNumOff = pkts[i].getSequenceNumber() - 10 & 0xFFFF;
                    long tsOff = pkts[i].getTimestamp() - 30000L & 0xFFFFFFFFL;
                    Object[] extras = LipSyncHack.this.make(ssrc.intValue(), seqNumOff, tsOff, 10);
                    cumulExtras = (RawPacket[])ArrayUtils.concat(cumulExtras, (Object[])extras);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("new_translation,stream=" + LipSyncHack.this.dest.getStream().hashCode() + " ssrc=" + ssrc + ",pt=" + LipSyncHack.this.vp8pt + ",ts_delta=0,seq_num_delta=0"));
                    }
                    LipSyncHack.this.transformations.put(ssrc, transformation);
                }
                pkts[i] = (RawPacket)transformation.apply((Object)pkts[i]);
            }
            return (RawPacket[])ArrayUtils.concat(cumulExtras, (Object[])pkts);
        }
    }
}

