/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import org.jivesoftware.smack.provider.IQProvider;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;
import org.xmpp.jnodes.smack.JingleTrackerIQ;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleTrackerProvider
extends IQProvider<JingleTrackerIQ> {
    public JingleTrackerIQ parse(XmlPullParser parser, int depth) throws Exception {
        JingleTrackerIQ iq = new JingleTrackerIQ();
        boolean done = false;
        while (!done) {
            int eventType = parser.getEventType();
            String elementName = parser.getName();
            if (eventType == 2) {
                TrackerEntry.Type type;
                if (elementName.equals(TrackerEntry.Type.relay.toString())) {
                    type = TrackerEntry.Type.relay;
                } else if (elementName.equals(TrackerEntry.Type.tracker.toString())) {
                    type = TrackerEntry.Type.tracker;
                } else {
                    parser.next();
                    continue;
                }
                String protocol = parser.getAttributeValue(null, "protocol");
                TrackerEntry.Policy policy = TrackerEntry.Policy.valueOf("_" + parser.getAttributeValue(null, "policy"));
                Jid address = JidCreate.from((String)parser.getAttributeValue(null, "address"));
                String verified = parser.getAttributeValue(null, "verified");
                if (address != null && address.length() > 0) {
                    TrackerEntry entry = new TrackerEntry(type, policy, address, protocol);
                    if (verified != null && verified.equals("true")) {
                        entry.setVerified(true);
                    }
                    iq.addEntry(entry);
                }
            } else if (eventType == 3 && elementName.equals("services")) {
                done = true;
            }
            if (done) continue;
            parser.next();
        }
        return iq;
    }
}

