/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.utils.MediaType;

public abstract class AbstractQualityControlWrapper<T extends MediaAwareCallPeer<?, ?, ?>>
implements QualityControl {
    protected final T peer;
    private QualityControl qualityControl;
    protected QualityPreset remoteSendMaxPreset = null;
    private float maxFrameRate = -1.0f;

    protected AbstractQualityControlWrapper(T peer) {
        this.peer = peer;
    }

    protected QualityControl getMediaQualityControl() {
        if (this.qualityControl != null) {
            return this.qualityControl;
        }
        MediaStream stream = ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)((Object)this.peer)).getMediaHandler())).getStream(MediaType.VIDEO);
        if (stream instanceof VideoMediaStream) {
            this.qualityControl = ((VideoMediaStream)stream).getQualityControl();
        }
        return this.qualityControl;
    }

    public QualityPreset getRemoteReceivePreset() {
        QualityControl qc = this.getMediaQualityControl();
        return qc == null ? null : qc.getRemoteReceivePreset();
    }

    public QualityPreset getRemoteSendMinPreset() {
        QualityControl qc = this.getMediaQualityControl();
        return qc == null ? null : qc.getRemoteSendMinPreset();
    }

    public QualityPreset getRemoteSendMaxPreset() {
        QualityControl qControls = this.getMediaQualityControl();
        if (qControls == null) {
            return this.remoteSendMaxPreset;
        }
        QualityPreset qp = qControls.getRemoteSendMaxPreset();
        if (qp != null && this.maxFrameRate > 0.0f) {
            qp = new QualityPreset(qp.getResolution(), (float)((int)this.maxFrameRate));
        }
        return qp;
    }

    public void setMaxFrameRate(float f) {
        this.maxFrameRate = f;
    }

    public void setRemoteSendMaxPreset(QualityPreset preset) {
        QualityControl qControls = this.getMediaQualityControl();
        if (qControls != null) {
            qControls.setRemoteSendMaxPreset(preset);
        } else {
            this.remoteSendMaxPreset = preset;
        }
    }

    public abstract void setPreferredRemoteSendMaxPreset(QualityPreset var1) throws MediaException;
}

