/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.TimestampUtils;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;

class InterArrival {
    private static final int kBurstDeltaThresholdMs = 5;
    private static final Logger logger = Logger.getLogger(InterArrival.class);
    private boolean burstGrouping;
    private TimestampGroup currentTimestampGroup = new TimestampGroup();
    private final long kTimestampGroupLengthTicks;
    private final DiagnosticContext diagnosticContext;
    private TimestampGroup prevTimestampGroup = new TimestampGroup();
    private double timestampToMsCoeff;
    private int numConsecutiveReorderedPackets;
    private static final int kReorderedResetThreshold = 3;
    private static final int kArrivalTimeOffsetThresholdMs = 3000;

    private static long latestTimestamp(long timestamp1, long timestamp2) {
        return TimestampUtils.latestTimestamp((long)timestamp1, (long)timestamp2);
    }

    public InterArrival(long timestampGroupLengthTicks, double timestampToMsCoeff, boolean enableBurstGrouping, @NotNull DiagnosticContext diagnosticContext) {
        this.kTimestampGroupLengthTicks = timestampGroupLengthTicks;
        this.timestampToMsCoeff = timestampToMsCoeff;
        this.burstGrouping = enableBurstGrouping;
        this.numConsecutiveReorderedPackets = 0;
        this.diagnosticContext = diagnosticContext;
    }

    private boolean belongsToBurst(long arrivalTimeMs, long timestamp) {
        if (!this.burstGrouping) {
            return false;
        }
        if (this.currentTimestampGroup.completeTimeMs < 0L) {
            throw new IllegalStateException("currentTimestampGroup.completeTimeMs");
        }
        long arrivalTimeDeltaMs = arrivalTimeMs - this.currentTimestampGroup.completeTimeMs;
        long timestampDiff = TimestampUtils.subtractAsUnsignedInt32((long)timestamp, (long)this.currentTimestampGroup.timestamp);
        long tsDeltaMs = (long)(this.timestampToMsCoeff * (double)timestampDiff + 0.5);
        if (tsDeltaMs == 0L) {
            return true;
        }
        long propagationDeltaMs = arrivalTimeDeltaMs - tsDeltaMs;
        return propagationDeltaMs < 0L && arrivalTimeDeltaMs <= 5L;
    }

    public boolean computeDeltas(long timestamp, long arrivalTimeMs, int packetSize, long[] deltas) {
        return this.computeDeltas(timestamp, arrivalTimeMs, packetSize, deltas, -1L);
    }

    public boolean computeDeltas(long timestamp, long arrivalTimeMs, int packetSize, long[] deltas, long systemTimeMs) {
        if (deltas == null) {
            throw new NullPointerException("deltas");
        }
        if (deltas.length != 3) {
            throw new IllegalArgumentException("deltas.length");
        }
        boolean calculatedDeltas = false;
        if (this.currentTimestampGroup.isFirstPacket()) {
            this.currentTimestampGroup.timestamp = timestamp;
            this.currentTimestampGroup.firstTimestamp = timestamp;
        } else {
            if (!this.isPacketInOrder(timestamp)) {
                return false;
            }
            if (this.isNewTimestampGroup(arrivalTimeMs, timestamp)) {
                if (this.prevTimestampGroup.completeTimeMs >= 0L) {
                    deltas[0] = TimestampUtils.subtractAsUnsignedInt32((long)this.currentTimestampGroup.timestamp, (long)this.prevTimestampGroup.timestamp);
                    long arrivalTimeDeltaMs = deltas[1] = this.currentTimestampGroup.completeTimeMs - this.prevTimestampGroup.completeTimeMs;
                    long systemTimeDeltaMs = this.currentTimestampGroup.lastSystemTimeMs - this.prevTimestampGroup.lastSystemTimeMs;
                    if (this.prevTimestampGroup.lastSystemTimeMs != -1L && this.currentTimestampGroup.lastSystemTimeMs != -1L && arrivalTimeDeltaMs - systemTimeDeltaMs >= 3000L) {
                        logger.warn((Object)("The arrival time clock offset has changed (diff = " + String.valueOf(arrivalTimeDeltaMs - systemTimeDeltaMs) + " ms), resetting."));
                        this.Reset();
                        return false;
                    }
                    if (arrivalTimeDeltaMs < 0L) {
                        ++this.numConsecutiveReorderedPackets;
                        if (this.numConsecutiveReorderedPackets >= 3) {
                            logger.warn((Object)"Packets are being reordered on the path from the socket to the bandwidth estimator. Ignoring this packet for bandwidth estimation.");
                            this.Reset();
                        }
                        return false;
                    }
                    this.numConsecutiveReorderedPackets = 0;
                    deltas[2] = (int)(this.currentTimestampGroup.size - this.prevTimestampGroup.size);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)this.diagnosticContext.makeTimeSeriesPoint("computed_deltas").addField("inter_arrival", (Object)this.hashCode()).addField("arrival_time_ms", (Object)arrivalTimeMs).addField("timestamp_delta", (Object)deltas[0]).addField("arrival_time_ms_delta", (Object)deltas[1]).addField("payload_size_delta", (Object)deltas[2]));
                    }
                    calculatedDeltas = true;
                }
                this.prevTimestampGroup.copy(this.currentTimestampGroup);
                this.currentTimestampGroup.firstTimestamp = timestamp;
                this.currentTimestampGroup.timestamp = timestamp;
                this.currentTimestampGroup.size = 0L;
            } else {
                this.currentTimestampGroup.timestamp = InterArrival.latestTimestamp(this.currentTimestampGroup.timestamp, timestamp);
            }
        }
        this.currentTimestampGroup.size += (long)packetSize;
        this.currentTimestampGroup.completeTimeMs = arrivalTimeMs;
        this.currentTimestampGroup.lastSystemTimeMs = systemTimeMs;
        return calculatedDeltas;
    }

    private boolean isNewTimestampGroup(long arrivalTimeMs, long timestamp) {
        if (this.currentTimestampGroup.isFirstPacket()) {
            return false;
        }
        if (this.belongsToBurst(arrivalTimeMs, timestamp)) {
            return false;
        }
        long timestampDiff = TimestampUtils.subtractAsUnsignedInt32((long)timestamp, (long)this.currentTimestampGroup.firstTimestamp);
        return timestampDiff > this.kTimestampGroupLengthTicks;
    }

    private boolean isPacketInOrder(long timestamp) {
        boolean inOrder;
        if (this.currentTimestampGroup.isFirstPacket()) {
            return true;
        }
        long timestampDiff = TimestampUtils.subtractAsUnsignedInt32((long)timestamp, (long)this.currentTimestampGroup.firstTimestamp);
        long tsDeltaMs = (long)(this.timestampToMsCoeff * (double)timestampDiff + 0.5);
        boolean bl = inOrder = timestampDiff < 0x80000000L;
        if (!inOrder && logger.isTraceEnabled()) {
            logger.trace((Object)this.diagnosticContext.makeTimeSeriesPoint("reordered_packet").addField("inter_arrival", (Object)this.hashCode()).addField("ts_delta_ms", (Object)tsDeltaMs));
        }
        return inOrder;
    }

    public void Reset() {
        this.numConsecutiveReorderedPackets = 0;
        this.currentTimestampGroup = new TimestampGroup();
        this.prevTimestampGroup = new TimestampGroup();
    }

    private static class TimestampGroup {
        public long completeTimeMs = -1L;
        public long size = 0L;
        public long firstTimestamp = 0L;
        public long timestamp = 0L;
        public long lastSystemTimeMs = -1L;

        private TimestampGroup() {
        }

        public void copy(TimestampGroup source) {
            this.completeTimeMs = source.completeTimeMs;
            this.firstTimestamp = source.firstTimestamp;
            this.size = source.size;
            this.timestamp = source.timestamp;
        }

        public boolean isFirstPacket() {
            return this.completeTimeMs == -1L;
        }
    }
}

