/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.NativelySupportedAudioFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPIStream;
import org.jitsi.utils.logging.Logger;

public class DataSource
extends AbstractPushBufferCaptureDevice {
    private static final Logger logger = Logger.getLogger(DataSource.class);
    final boolean aec;
    final WASAPISystem audioSystem = (WASAPISystem)AudioSystem.getAudioSystem("wasapi");

    public DataSource() {
        this(null);
    }

    public DataSource(MediaLocator locator) {
        super(locator);
        this.aec = this.audioSystem.isDenoise() || this.audioSystem.isEchoCancel();
    }

    protected WASAPIStream createStream(int streamIndex, FormatControl formatControl) {
        return new WASAPIStream(this, formatControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws IOException {
        super.doConnect();
        MediaLocator locator = this.getLocator();
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            for (PushBufferStream stream : this.getStreams()) {
                ((WASAPIStream)stream).setLocator(locator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDisconnect() {
        try {
            Object object = this.getStreamSyncRoot();
            synchronized (object) {
                for (PushBufferStream stream : this.getStreams()) {
                    try {
                        ((WASAPIStream)stream).setLocator(null);
                    }
                    catch (IOException ioe) {
                        logger.error((Object)("Failed to disconnect " + stream.getClass().getName()), (Throwable)ioe);
                    }
                }
            }
        }
        finally {
            super.doDisconnect();
        }
    }

    Format[] getIAudioClientSupportedFormats() {
        return this.getIAudioClientSupportedFormats(0);
    }

    private Format[] getIAudioClientSupportedFormats(int streamIndex) {
        Format[] superSupportedFormats = super.getSupportedFormats(streamIndex);
        if (superSupportedFormats == null || superSupportedFormats.length == 0) {
            return superSupportedFormats;
        }
        ArrayList<Format> supportedFormats = new ArrayList<Format>(superSupportedFormats.length);
        for (Format format : superSupportedFormats) {
            if (!(format instanceof NativelySupportedAudioFormat) || supportedFormats.contains(format)) continue;
            supportedFormats.add(format);
        }
        int supportedFormatCount = supportedFormats.size();
        return supportedFormatCount == superSupportedFormats.length ? superSupportedFormats : supportedFormats.toArray(new Format[supportedFormatCount]);
    }

    @Override
    protected Format[] getSupportedFormats(int streamIndex) {
        if (this.aec) {
            List<AudioFormat> aecSupportedFormats = this.audioSystem.getAECSupportedFormats();
            return aecSupportedFormats.toArray(new Format[aecSupportedFormats.size()]);
        }
        return this.getIAudioClientSupportedFormats(streamIndex);
    }
}

