/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol;

import java.io.IOException;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.utils.logging.Logger;

abstract class AbstractBufferStream<T extends DataSource>
extends AbstractControls
implements SourceStream {
    private static final Logger logger = Logger.getLogger(AbstractBufferStream.class);
    private static final ContentDescriptor CONTENT_DESCRIPTOR = new ContentDescriptor("raw");
    protected final T dataSource;
    protected final FormatControl formatControl;

    protected AbstractBufferStream(T dataSource, FormatControl formatControl) {
        this.dataSource = dataSource;
        this.formatControl = formatControl;
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException ioex) {
            logger.error((Object)("Failed to stop " + this.getClass().getSimpleName()), (Throwable)ioex);
        }
    }

    protected Format doGetFormat() {
        return null;
    }

    protected Format doSetFormat(Format format) {
        return null;
    }

    public boolean endOfStream() {
        return false;
    }

    public ContentDescriptor getContentDescriptor() {
        return CONTENT_DESCRIPTOR;
    }

    public long getContentLength() {
        return -1L;
    }

    public Object[] getControls() {
        if (this.formatControl != null) {
            return new Object[]{this.formatControl};
        }
        return ControlsAdapter.EMPTY_CONTROLS;
    }

    public Format getFormat() {
        return this.formatControl == null ? null : this.formatControl.getFormat();
    }

    Format internalGetFormat() {
        return this.doGetFormat();
    }

    Format internalSetFormat(Format format) {
        return this.doSetFormat(format);
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }
}

