/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.version.Version;
import org.jitsi.utils.version.VersionImpl;
import org.jitsi.utils.version.VersionService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class AbstractVersionActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(AbstractVersionActivator.class);
    private static final Pattern PARSE_VERSION_STRING_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.([\\d\\.]+)");

    protected abstract Version getCurrentVersion();

    public void start(BundleContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        Version currentVersion = this.getCurrentVersion();
        VersionServiceImpl versionServiceImpl = new VersionServiceImpl(currentVersion);
        context.registerService(VersionService.class.getName(), (Object)versionServiceImpl, null);
        this.logger.info((Object)("VersionService registered: " + currentVersion.getApplicationName() + " " + currentVersion));
    }

    public void stop(BundleContext context) throws Exception {
    }

    static class VersionServiceImpl
    implements VersionService {
        private final Version version;

        private VersionServiceImpl(Version version) {
            this.version = version;
        }

        public Version parseVersionString(String versionString) {
            Matcher matcher = PARSE_VERSION_STRING_PATTERN.matcher(versionString);
            if (matcher.matches() && matcher.groupCount() == 3) {
                return new VersionImpl(this.version.getApplicationName(), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), this.version.getPreReleaseID());
            }
            return null;
        }

        public Version getCurrentVersion() {
            return this.version;
        }
    }
}

