/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.retry;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jitsi.osgi.ServiceUtils2;
import org.jitsi.retry.RetryTask;
import org.jitsi.utils.logging.Logger;
import org.osgi.framework.BundleContext;

public class RetryStrategy {
    private static final Logger logger = Logger.getLogger(RetryStrategy.class);
    private final ScheduledExecutorService executor;
    private RetryTask task;
    private ScheduledFuture<?> future;
    private final TaskRunner taskRunner = new TaskRunner();

    public RetryStrategy() {
        this(Executors.newScheduledThreadPool(1));
    }

    public RetryStrategy(BundleContext osgiContext) throws IllegalArgumentException {
        this.executor = ServiceUtils2.getService(osgiContext, ScheduledExecutorService.class);
        if (this.executor == null) {
            throw new IllegalArgumentException("Failed to obtain ScheduledExecutorService from given OSGi context");
        }
    }

    public RetryStrategy(ScheduledExecutorService retryExecutor) {
        if (retryExecutor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = retryExecutor;
    }

    public synchronized void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.task.setCancelled(true);
    }

    public synchronized boolean isCancelled() {
        return this.task != null && this.task.isCancelled();
    }

    public synchronized void runRetryingTask(RetryTask task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        this.task = task;
        this.future = this.executor.schedule(this.taskRunner, task.getInitialDelay(), TimeUnit.MILLISECONDS);
    }

    private synchronized void scheduleRetry() {
        if (this.task == null || this.task.isCancelled()) {
            return;
        }
        this.future = this.executor.schedule(this.taskRunner, this.task.getRetryDelay(), TimeUnit.MILLISECONDS);
    }

    class TaskRunner
    implements Runnable {
        TaskRunner() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (RetryStrategy.this.task.getCallable().call().booleanValue()) {
                        RetryStrategy.this.scheduleRetry();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    if (!RetryStrategy.this.task.willRetryAfterException()) break block3;
                    RetryStrategy.this.scheduleRetry();
                }
            }
        }
    }
}

